/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.intellij.utils.URLUtil;
import com.jetbrains.plugin.structure.intellij.utils.xincludes.DefaultXIncludePathResolver;
import com.jetbrains.plugin.structure.intellij.utils.xincludes.XIncludeException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginXmlXIncludePathResolver
extends DefaultXIncludePathResolver {
    private final List<URL> myPluginMetaInfUrls;

    public PluginXmlXIncludePathResolver(List<URL> metaInfUrl) {
        this.myPluginMetaInfUrls = new ArrayList<URL>(metaInfUrl);
    }

    @NotNull
    private URL defaultResolve(@NotNull String relativePath, @Nullable String base) {
        if (base != null && relativePath.startsWith("/META-INF/")) {
            try {
                return new URL(new URL(base), ".." + relativePath);
            }
            catch (MalformedURLException e) {
                throw new XIncludeException(e);
            }
        }
        return super.resolvePath(relativePath, base);
    }

    @NotNull
    private URL getMetaInfRelativeUrl(@NotNull URL metaInf, @NotNull String relativePath) throws MalformedURLException {
        if (relativePath.startsWith("/")) {
            return new URL(metaInf, ".." + relativePath);
        }
        return new URL(metaInf, relativePath);
    }

    @Override
    @NotNull
    public URL resolvePath(@NotNull String relativePath, @Nullable String base) {
        URL url = this.defaultResolve(relativePath, base);
        if (!URLUtil.resourceExists(url)) {
            for (URL metaInf : this.myPluginMetaInfUrls) {
                try {
                    URL entryUrl = this.getMetaInfRelativeUrl(metaInf, relativePath);
                    if (!URLUtil.resourceExists(entryUrl)) continue;
                    return entryUrl;
                }
                catch (MalformedURLException malformedURLException) {
                }
            }
        }
        return url;
    }
}

