/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Parent;
import org.jdom2.Text;
import org.jdom2.util.IteratorIterable;
import org.jetbrains.annotations.NotNull;

public class PluginXmlUtil {
    private static final Pattern JAVA_CLASS_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");
    private static final String[] CLASS_LIKE_STRINGS = new String[]{"class", "interface", "implementation", "instance"};

    private static Set<String> extractReferencedClasses(@NotNull Element rootElement) {
        HashSet<String> referencedClasses = new HashSet<String>();
        IteratorIterable descendants = rootElement.getDescendants();
        while (descendants.hasNext()) {
            Parent parent;
            Content next = (Content)descendants.next();
            if (next instanceof Element) {
                Element element = (Element)next;
                if (PluginXmlUtil.isClassLikeName(element.getName())) {
                    referencedClasses.addAll(PluginXmlUtil.extractClasses(element.getTextNormalize()));
                }
                for (Attribute attribute : element.getAttributes()) {
                    if (!PluginXmlUtil.isClassLikeName(attribute.getName())) continue;
                    referencedClasses.addAll(PluginXmlUtil.extractClasses(attribute.getValue().trim()));
                }
                continue;
            }
            if (!(next instanceof Text) || !((parent = next.getParent()) instanceof Element) || !PluginXmlUtil.isClassLikeName(((Element)parent).getName())) continue;
            referencedClasses.addAll(PluginXmlUtil.extractClasses(((Text)next).getTextTrim()));
        }
        return referencedClasses;
    }

    private static boolean isClassLikeName(@NotNull String label) {
        for (String string : CLASS_LIKE_STRINGS) {
            if (!StringUtil.containsIgnoreCase(label, string)) continue;
            return true;
        }
        return false;
    }

    private static List<String> extractClasses(@NotNull String text) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = JAVA_CLASS_PATTERN.matcher(text);
        while (matcher.find()) {
            result.add(matcher.group().replace('.', '/'));
        }
        return result;
    }

    @NotNull
    public static Set<String> getAllClassesReferencedFromXml(IdePlugin plugin) {
        Document document = plugin.getUnderlyingDocument();
        Element rootElement = document.getRootElement();
        if (rootElement != null) {
            return PluginXmlUtil.extractReferencedClasses(rootElement);
        }
        return Collections.emptySet();
    }
}

