/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.logging.Logger;
import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.InvalidDescriptorProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.intellij.beans.IdeaVersionBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginBeanExtractor;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependencyBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginVendorBean;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginImpl;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.problems.DefaultChangeNotes;
import com.jetbrains.plugin.structure.intellij.problems.DefaultDescription;
import com.jetbrains.plugin.structure.intellij.problems.InvalidDependencyBean;
import com.jetbrains.plugin.structure.intellij.problems.InvalidModuleBean;
import com.jetbrains.plugin.structure.intellij.problems.InvalidSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.InvalidUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.MissingOptionalDependencyConfigurationFile;
import com.jetbrains.plugin.structure.intellij.problems.NoModuleDependencies;
import com.jetbrains.plugin.structure.intellij.problems.NonLatinDescription;
import com.jetbrains.plugin.structure.intellij.problems.PluginWordInPluginName;
import com.jetbrains.plugin.structure.intellij.problems.PropertyWithDefaultValue;
import com.jetbrains.plugin.structure.intellij.problems.ShortChangeNotes;
import com.jetbrains.plugin.structure.intellij.problems.ShortDescription;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildGreaterThanUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.TooLongPropertyValue;
import com.jetbrains.plugin.structure.intellij.problems.UnresolvedXIncludeElements;
import com.jetbrains.plugin.structure.intellij.utils.StringUtil;
import com.jetbrains.plugin.structure.intellij.utils.xincludes.JDOMXIncluder;
import com.jetbrains.plugin.structure.intellij.utils.xincludes.XIncludePathResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jdom2.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;

final class PluginCreator {
    private static final int MAX_VERSION_LENGTH = 64;
    private static final int MAX_PROPERTY_LENGTH = 255;
    private static final int MAX_LONG_PROPERTY_LENGTH = 65535;
    private final IdePluginImpl myPlugin;
    private final List<PluginProblem> myProblems = new ArrayList<PluginProblem>();
    private final String myDescriptorPath;
    private final boolean myValidateDescriptor;
    private final File myActualFile;
    private final Logger myLogger;

    PluginCreator(@NotNull String descriptorPath, boolean validateDescriptor, @NotNull Document document, @NotNull URL documentUrl, @NotNull XIncludePathResolver pathResolver, @NotNull File actualFile, @NotNull Logger logger) {
        this.myDescriptorPath = descriptorPath;
        this.myValidateDescriptor = validateDescriptor;
        this.myActualFile = actualFile;
        this.myLogger = logger;
        this.myPlugin = this.resolveDocumentAndValidateBean(document, documentUrl, pathResolver);
    }

    PluginCreator(String descriptorPath, PluginProblem singleProblem, File actualFile) {
        if (singleProblem.getLevel() != PluginProblem.Level.ERROR) {
            throw new IllegalArgumentException("Only severe problems allowed here");
        }
        this.myActualFile = actualFile;
        this.myDescriptorPath = descriptorPath;
        this.myValidateDescriptor = true;
        this.myProblems.add(singleProblem);
        this.myPlugin = null;
        this.myLogger = null;
    }

    private void validatePluginBean(PluginBean bean) {
        if (this.myValidateDescriptor) {
            this.validateAttributes(bean);
            this.validateId(bean.id);
            this.validateName(bean.name);
            this.validateVersion(bean.pluginVersion);
            this.validateDescription(bean.getDescription());
            this.validateChangeNotes(bean.getChangeNotes());
            this.validateVendor(bean.vendor);
            this.validateIdeaVersion(bean.ideaVersion);
            if (bean.dependencies != null) {
                for (PluginDependencyBean dependencyBean : bean.dependencies) {
                    if (!StringUtil.isEmpty(dependencyBean.pluginId)) continue;
                    this.registerProblem((PluginProblem)new InvalidDependencyBean(this.myDescriptorPath));
                }
            }
            if (bean.modules != null) {
                for (String module : bean.modules) {
                    if (!StringUtil.isEmpty(module)) continue;
                    this.registerProblem((PluginProblem)new InvalidModuleBean(this.myDescriptorPath));
                }
            }
        }
    }

    private void validateAttributes(@NotNull PluginBean bean) {
        if (bean.url != null) {
            this.validatePropertyLength("plugin url", bean.url, 255);
        }
    }

    private void validateVersion(String pluginVersion) {
        if (StringUtil.isEmpty(pluginVersion)) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("version", this.myDescriptorPath));
        } else {
            this.validatePropertyLength("version", pluginVersion, 64);
        }
    }

    private void validatePlugin(IdePlugin plugin) {
        int moduleDependenciesCnt = 0;
        for (PluginDependency dependency : plugin.getDependencies()) {
            if (!dependency.isModule()) continue;
            ++moduleDependenciesCnt;
        }
        if (moduleDependenciesCnt == 0) {
            this.registerProblem(new NoModuleDependencies(this.myDescriptorPath));
        }
        IdeVersion sinceBuild = plugin.getSinceBuild();
        IdeVersion untilBuild = plugin.getUntilBuild();
        if (sinceBuild != null && untilBuild != null && sinceBuild.compareTo(untilBuild) > 0) {
            this.registerProblem((PluginProblem)new SinceBuildGreaterThanUntilBuild(this.myDescriptorPath, sinceBuild, untilBuild));
        }
    }

    public Map<PluginDependency, String> getOptionalDependenciesConfigurationFiles() {
        return this.myPlugin.getOptionalDependenciesConfigFiles();
    }

    public void addOptionalDescriptor(PluginDependency pluginDependency, String configurationFile, PluginCreator optionalCreator) {
        PluginCreationResult<IdePlugin> pluginCreationResult = optionalCreator.getPluginCreationResult();
        if (pluginCreationResult instanceof PluginCreationSuccess) {
            this.myPlugin.addOptionalDescriptor(configurationFile, (IdePlugin)((PluginCreationSuccess)pluginCreationResult).getPlugin());
        } else {
            this.registerProblem((PluginProblem)new MissingOptionalDependencyConfigurationFile(this.myDescriptorPath, pluginDependency, configurationFile));
        }
    }

    @Nullable
    private IdePluginImpl resolveDocumentAndValidateBean(@NotNull Document originalDocument, @NotNull URL documentUrl, @NotNull XIncludePathResolver pathResolver) {
        Document document = this.resolveXIncludesOfDocument(originalDocument, documentUrl, pathResolver);
        if (document == null) {
            return null;
        }
        PluginBean bean = this.readDocumentIntoXmlBean(document);
        if (bean == null) {
            return null;
        }
        this.validatePluginBean(bean);
        if (this.hasErrors()) {
            return null;
        }
        IdePluginImpl plugin = new IdePluginImpl(document, bean);
        this.validatePlugin(plugin);
        if (this.hasErrors()) {
            return null;
        }
        return plugin;
    }

    @Nullable
    private Document resolveXIncludesOfDocument(@NotNull Document originalDocument, @NotNull URL documentUrl, @NotNull XIncludePathResolver pathResolver) {
        try {
            return JDOMXIncluder.resolve(originalDocument, documentUrl.toExternalForm(), false, pathResolver);
        }
        catch (Exception e) {
            this.myLogger.info("Unable to resolve x-include elements of descriptor " + this.myDescriptorPath, (Throwable)e);
            this.registerProblem((PluginProblem)new UnresolvedXIncludeElements(this.myDescriptorPath));
            return null;
        }
    }

    @Nullable
    private PluginBean readDocumentIntoXmlBean(@NotNull Document document) {
        try {
            return PluginBeanExtractor.extractPluginBean(document);
        }
        catch (Exception e) {
            this.registerProblem((PluginProblem)new UnableToReadDescriptor(this.myDescriptorPath));
            this.myLogger.error("Unable to read plugin descriptor " + this.myDescriptorPath, (Throwable)e);
            return null;
        }
    }

    public File getActualFile() {
        return this.myActualFile;
    }

    public void registerProblem(@NotNull PluginProblem problem) {
        this.myProblems.add(problem);
    }

    public boolean isSuccess() {
        return !this.hasErrors();
    }

    public boolean hasOnlyInvalidDescriptorErrors() {
        for (PluginProblem problem : this.getProblems()) {
            if (problem.getLevel() != PluginProblem.Level.ERROR || problem instanceof InvalidDescriptorProblem) continue;
            return false;
        }
        return true;
    }

    public boolean hasErrors() {
        for (PluginProblem problem : this.getProblems()) {
            if (problem.getLevel() != PluginProblem.Level.ERROR) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PluginCreationResult<IdePlugin> getPluginCreationResult() {
        if (this.hasErrors()) {
            return new PluginCreationFail(this.myProblems);
        }
        return new PluginCreationSuccess((Plugin)this.myPlugin, this.myProblems);
    }

    @NotNull
    public List<PluginProblem> getProblems() {
        return this.myProblems;
    }

    public void setOriginalFileAndExtractDir(@NotNull File originalFile, @NotNull File extractedDir) {
        if (this.myPlugin != null) {
            this.myPlugin.setOriginalPluginFile(originalFile);
            this.myPlugin.setExtractDirectory(extractedDir);
        }
    }

    private void validateId(@Nullable String id) {
        if (id != null) {
            if ("com.your.company.unique.plugin.id".equals(id)) {
                this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.myDescriptorPath, "id"));
            } else {
                this.validatePropertyLength("id", id, 255);
            }
        }
    }

    private void validateName(@Nullable String name) {
        if (StringUtil.isEmpty(name)) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("name", this.myDescriptorPath));
        } else if ("Plugin display name here".equals(name)) {
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.myDescriptorPath, "name"));
        } else if ("plugin".contains(name)) {
            this.registerProblem(new PluginWordInPluginName(this.myDescriptorPath));
        } else {
            this.validatePropertyLength("name", name, 255);
        }
    }

    private void validateDescription(@Nullable String htmlDescription) {
        if (StringUtil.isEmpty(htmlDescription)) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("description", this.myDescriptorPath));
            return;
        }
        this.validatePropertyLength("description", htmlDescription, 65535);
        String textDescription = Jsoup.parseBodyFragment((String)htmlDescription).text();
        if (textDescription.length() < 40) {
            this.registerProblem(new ShortDescription(this.myDescriptorPath));
            return;
        }
        if (textDescription.contains("Enter short description for your plugin here.") || textDescription.contains("most HTML tags may be used")) {
            this.registerProblem(new DefaultDescription(this.myDescriptorPath));
            return;
        }
        int latinSymbols = StringUtil.numberOfPatternMatches(textDescription, Pattern.compile("[A-Za-z]|\\s"));
        if (latinSymbols < 40) {
            this.registerProblem(new NonLatinDescription(this.myDescriptorPath));
        }
    }

    private void validateChangeNotes(@Nullable String changeNotes) {
        if (StringUtil.isEmptyOrSpaces(changeNotes)) {
            return;
        }
        if (changeNotes.length() < 40) {
            this.registerProblem(new ShortChangeNotes(this.myDescriptorPath));
            return;
        }
        if (changeNotes.contains("Add change notes here") || changeNotes.contains("most HTML tags may be used")) {
            this.registerProblem(new DefaultChangeNotes(this.myDescriptorPath));
        }
        this.validatePropertyLength("<change-notes>", changeNotes, 65535);
    }

    private void validatePropertyLength(@NotNull String propertyName, @NotNull String propertyValue, int maxLength) {
        if (propertyValue.length() > maxLength) {
            this.registerProblem((PluginProblem)new TooLongPropertyValue(this.myDescriptorPath, propertyName, propertyValue.length(), maxLength));
        }
    }

    private void validateVendor(PluginVendorBean vendorBean) {
        if (vendorBean == null) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("vendor", this.myDescriptorPath));
            return;
        }
        if (StringUtil.isEmptyOrSpaces(vendorBean.url) && StringUtil.isEmptyOrSpaces(vendorBean.email) && StringUtil.isEmptyOrSpaces(vendorBean.name)) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("vendor", this.myDescriptorPath));
            return;
        }
        if ("YourCompany".equals(vendorBean.name)) {
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.myDescriptorPath, "vendor"));
        }
        this.validatePropertyLength("vendor", vendorBean.name, 255);
        if ("http://www.yourcompany.com".equals(vendorBean.url)) {
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.myDescriptorPath, "vendor url"));
        }
        this.validatePropertyLength("vendor url", vendorBean.url, 255);
        if ("support@yourcompany.com".equals(vendorBean.email)) {
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.myDescriptorPath, "vendor email"));
        }
        this.validatePropertyLength("vendor email", vendorBean.email, 255);
    }

    private void validateIdeaVersion(IdeaVersionBean versionBean) {
        if (versionBean == null) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("idea-version", this.myDescriptorPath));
            return;
        }
        String sinceBuild = versionBean.sinceBuild;
        if (sinceBuild == null) {
            this.registerProblem((PluginProblem)new SinceBuildNotSpecified(this.myDescriptorPath));
        } else {
            try {
                IdeVersion sinceBuildParsed = IdeVersion.createIdeVersion(sinceBuild);
                if (sinceBuildParsed.getBaselineVersion() < 130 && sinceBuild.endsWith(".*")) {
                    this.registerProblem((PluginProblem)new InvalidSinceBuild(this.myDescriptorPath, sinceBuild));
                }
            }
            catch (Exception e) {
                this.registerProblem((PluginProblem)new InvalidSinceBuild(this.myDescriptorPath, sinceBuild));
            }
        }
        String untilBuild = versionBean.untilBuild;
        if (untilBuild != null && !IdeVersion.isValidIdeVersion(untilBuild)) {
            this.registerProblem((PluginProblem)new InvalidUntilBuild(this.myDescriptorPath, untilBuild));
        }
    }
}

