/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.logging.Logger;
import com.jetbrains.plugin.structure.base.logging.LoggerFactory;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.IncorrectPluginFile;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.problems.UnexpectedDescriptorElements;
import com.jetbrains.plugin.structure.base.utils.FileUtil;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.extractor.PluginExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginXmlXIncludePathResolver;
import com.jetbrains.plugin.structure.intellij.problems.MultiplePluginDescriptorsInLibDirectory;
import com.jetbrains.plugin.structure.intellij.problems.PluginLibDirectoryIsEmpty;
import com.jetbrains.plugin.structure.intellij.problems.UnableToReadJarFile;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import com.jetbrains.plugin.structure.intellij.utils.StringUtil;
import com.jetbrains.plugin.structure.intellij.utils.URLUtil;
import com.jetbrains.plugin.structure.intellij.utils.xincludes.DefaultXIncludePathResolver;
import com.jetbrains.plugin.structure.intellij.utils.xincludes.XIncludePathResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.input.JDOMParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdePluginManager
implements PluginManager<IdePlugin> {
    private static final String PLUGIN_XML = "plugin.xml";
    @NotNull
    private final XIncludePathResolver myPathResolver;
    @NotNull
    private final File myExtractDirectory;
    @NotNull
    private final Logger myLogger;

    private IdePluginManager(@NotNull XIncludePathResolver pathResolver, @NotNull File extractDirectory, @NotNull Logger logger) {
        this.myPathResolver = pathResolver;
        this.myExtractDirectory = extractDirectory;
        this.myLogger = logger;
    }

    @NotNull
    public static IdePluginManager createManager() {
        return IdePluginManager.createManager(new DefaultXIncludePathResolver());
    }

    @NotNull
    public static IdePluginManager createManager(@NotNull File extractDirectory) {
        return IdePluginManager.createManager(new DefaultXIncludePathResolver(), extractDirectory, IdePluginManager.createDefaultLogger());
    }

    @NotNull
    public static IdePluginManager createManager(@NotNull XIncludePathResolver pathResolver) {
        return IdePluginManager.createManager(pathResolver, Settings.EXTRACT_DIRECTORY.getAsFile(), IdePluginManager.createDefaultLogger());
    }

    @NotNull
    private static Logger createDefaultLogger() {
        return LoggerFactory.INSTANCE.createDefaultLogger(IdePluginManager.class);
    }

    @NotNull
    public static IdePluginManager createManager(@NotNull XIncludePathResolver pathResolver, @NotNull File extractDirectory, @NotNull Logger logger) {
        return new IdePluginManager(pathResolver, extractDirectory, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PluginCreator loadDescriptorFromJarFile(@NotNull File jarFile, @NotNull String descriptorPath, @NotNull XIncludePathResolver pathResolver, boolean validateDescriptor) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(jarFile);
        }
        catch (Exception e) {
            this.myLogger.info("Unable to read jar file " + jarFile, (Throwable)e);
            return new PluginCreator(descriptorPath, new UnableToReadJarFile(jarFile), jarFile);
        }
        try {
            ZipEntry entry = this.getEntry(zipFile, descriptorPath);
            if (entry != null) {
                PluginCreator pluginCreator;
                InputStream documentStream = null;
                try {
                    URL documentUrl = URLUtil.getJarEntryURL(jarFile, entry.getName());
                    documentStream = zipFile.getInputStream(entry);
                    Document document = JDOMUtil.loadDocument(documentStream);
                    pluginCreator = new PluginCreator(descriptorPath, validateDescriptor, document, documentUrl, pathResolver, jarFile, this.myLogger);
                }
                catch (Exception e) {
                    this.myLogger.info("Unable to read file " + descriptorPath);
                    PluginCreator pluginCreator2 = new PluginCreator(descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath), jarFile);
                    IOUtils.closeQuietly((InputStream)documentStream);
                    try {
                        zipFile.close();
                    }
                    catch (IOException e2) {
                        this.myLogger.error("Unable to close jar file " + jarFile, (Throwable)e2);
                    }
                    return pluginCreator2;
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(documentStream);
                            throw throwable;
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)documentStream);
                return pluginCreator;
            }
            PluginCreator pluginCreator = new PluginCreator(descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath), jarFile);
            return pluginCreator;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                this.myLogger.error("Unable to close jar file " + jarFile, (Throwable)e);
            }
        }
    }

    @Nullable
    private ZipEntry getEntry(@NotNull ZipFile zipFile, @NotNull String descriptorPath) {
        String zipEntryName = this.getZipEntryName(descriptorPath);
        ZipEntry entry = zipFile.getEntry(zipEntryName);
        return entry != null ? entry : zipFile.getEntry(zipEntryName.replace(File.separator, "/"));
    }

    @NotNull
    private String getZipEntryName(@NotNull String descriptorPath) {
        if (descriptorPath.startsWith("../")) {
            return StringUtil.trimStart(descriptorPath, "../");
        }
        return "META-INF" + File.separator + descriptorPath;
    }

    private PluginCreator loadDescriptorFromDir(@NotNull File pluginDirectory, @NotNull String filePath, boolean validateDescriptor) {
        File descriptorFile = new File(pluginDirectory, "META-INF" + File.separator + filePath);
        if (descriptorFile.exists()) {
            return this.loadDescriptorFromDescriptorFile(filePath, pluginDirectory, descriptorFile, validateDescriptor);
        }
        return this.loadDescriptorFromLibDirectory(pluginDirectory, filePath, validateDescriptor);
    }

    private PluginCreator loadDescriptorFromDescriptorFile(@NotNull String descriptorPath, @NotNull File pluginDirectory, @NotNull File descriptorFile, boolean validateDescriptor) {
        try {
            URL documentUrl = URLUtil.fileToUrl(descriptorFile);
            Document document = JDOMUtil.loadDocument(documentUrl);
            return new PluginCreator(descriptorPath, validateDescriptor, document, documentUrl, this.myPathResolver, pluginDirectory, this.myLogger);
        }
        catch (JDOMParseException e) {
            int lineNumber = e.getLineNumber();
            String message = lineNumber != -1 ? "unexpected element on line " + lineNumber : "unexpected elements";
            return new PluginCreator(descriptorPath, (PluginProblem)new UnexpectedDescriptorElements(message, descriptorPath), pluginDirectory);
        }
        catch (Exception e) {
            this.myLogger.info("Unable to read plugin descriptor " + descriptorPath + " of plugin " + descriptorFile, (Throwable)e);
            return new PluginCreator(descriptorPath, (PluginProblem)new UnableToReadDescriptor(descriptorPath), pluginDirectory);
        }
    }

    private PluginCreator loadDescriptorFromLibDirectory(@NotNull File root, @NotNull String descriptorPath, boolean validateDescriptor) {
        File libDir = new File(root, "lib");
        if (!libDir.isDirectory()) {
            return new PluginCreator(descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath), root);
        }
        File[] files = libDir.listFiles();
        if (files == null || files.length == 0) {
            return new PluginCreator(descriptorPath, new PluginLibDirectoryIsEmpty(libDir), root);
        }
        this.sortFilesWithRespectToRootDirectoryName(root, files);
        List<URL> metaInfUrls = this.getInLibMetaInfUrls(files);
        PluginXmlXIncludePathResolver pathResolver = new PluginXmlXIncludePathResolver(metaInfUrls);
        PluginCreator okOrPartiallyBrokenResult = null;
        for (File file : files) {
            PluginCreator innerCreator;
            if (FileUtil.INSTANCE.isJar(file) || FileUtil.INSTANCE.isZip(file)) {
                innerCreator = this.loadDescriptorFromJarFile(file, descriptorPath, pathResolver, validateDescriptor);
            } else {
                if (!file.isDirectory()) continue;
                innerCreator = this.loadDescriptorFromDir(file, descriptorPath, validateDescriptor);
            }
            if (!innerCreator.isSuccess() && !innerCreator.hasOnlyInvalidDescriptorErrors()) continue;
            if (okOrPartiallyBrokenResult == null) {
                okOrPartiallyBrokenResult = innerCreator;
                continue;
            }
            return this.getMultipleDescriptorsResult(root, descriptorPath, okOrPartiallyBrokenResult.getActualFile().getName(), innerCreator.getActualFile().getName());
        }
        if (okOrPartiallyBrokenResult != null) {
            return okOrPartiallyBrokenResult;
        }
        return new PluginCreator(descriptorPath, (PluginProblem)new PluginDescriptorIsNotFound(descriptorPath), root);
    }

    private PluginCreator getMultipleDescriptorsResult(File root, String descriptorPath, String firstDescriptor, String secondDescriptor) {
        if (firstDescriptor.compareTo(secondDescriptor) > 0) {
            String temp = firstDescriptor;
            firstDescriptor = secondDescriptor;
            secondDescriptor = temp;
        }
        return new PluginCreator(descriptorPath, new MultiplePluginDescriptorsInLibDirectory(firstDescriptor, secondDescriptor), root);
    }

    private void sortFilesWithRespectToRootDirectoryName(@NotNull File root, File[] files) {
        final String rootDirectoryName = root.getName();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(@NotNull File o1, @NotNull File o2) {
                if (o2.getName().startsWith(rootDirectoryName)) {
                    return Integer.MAX_VALUE;
                }
                if (o1.getName().startsWith(rootDirectoryName)) {
                    return -2147483647;
                }
                if (o2.getName().startsWith("resources")) {
                    return -2147483647;
                }
                if (o1.getName().startsWith("resources")) {
                    return Integer.MAX_VALUE;
                }
                return 0;
            }
        });
    }

    @NotNull
    private List<URL> getInLibMetaInfUrls(File[] files) {
        ArrayList<URL> inLibJarUrls = new ArrayList<URL>();
        for (File file : files) {
            if (!FileUtil.INSTANCE.isJar(file) && !FileUtil.INSTANCE.isZip(file)) continue;
            try {
                String metaInfUrl = URLUtil.getJarEntryURL(file, "META-INF").toExternalForm();
                inLibJarUrls.add(new URL(metaInfUrl));
            }
            catch (Exception e) {
                this.myLogger.warn("Unable to create URL for " + file + " META-INF root", (Throwable)e);
            }
        }
        return inLibJarUrls;
    }

    @NotNull
    private PluginCreator loadDescriptorFromJarOrDirectory(@NotNull File jarOrDirectory, @NotNull String descriptorPath, boolean validateDescriptor) {
        PluginCreator pluginCreator;
        descriptorPath = StringUtil.toSystemIndependentName(descriptorPath);
        if (jarOrDirectory.isDirectory()) {
            pluginCreator = this.loadDescriptorFromDir(jarOrDirectory, descriptorPath, validateDescriptor);
        } else if (FileUtil.INSTANCE.isJar(jarOrDirectory)) {
            pluginCreator = this.loadDescriptorFromJarFile(jarOrDirectory, descriptorPath, this.myPathResolver, validateDescriptor);
        } else {
            return new PluginCreator(descriptorPath, (PluginProblem)new IncorrectPluginFile(jarOrDirectory), jarOrDirectory);
        }
        return this.resolveOptionalDependencies(jarOrDirectory, pluginCreator);
    }

    private PluginCreator resolveOptionalDependencies(@NotNull File jarOrDirectory, @NotNull PluginCreator pluginCreator) {
        if (pluginCreator.isSuccess()) {
            Map<PluginDependency, String> optionalConfigurationFiles = pluginCreator.getOptionalDependenciesConfigurationFiles();
            return this.resolveOptionalDependencies(jarOrDirectory, optionalConfigurationFiles, pluginCreator);
        }
        return pluginCreator;
    }

    private PluginCreator resolveOptionalDependencies(File jarOrDirectory, Map<PluginDependency, String> optionalConfigurationFiles, PluginCreator pluginCreator) {
        for (Map.Entry<PluginDependency, String> entry : optionalConfigurationFiles.entrySet()) {
            PluginDependency pluginDependency = entry.getKey();
            String configurationFile = entry.getValue();
            PluginCreator optionalCreator = this.resolveOptionalConfigurationFile(jarOrDirectory, configurationFile);
            pluginCreator.addOptionalDescriptor(pluginDependency, configurationFile, optionalCreator);
        }
        return pluginCreator;
    }

    private PluginCreator resolveOptionalConfigurationFile(@NotNull File jarOrDirectory, @NotNull String configurationFile) {
        if (configurationFile.startsWith("/META-INF/")) {
            configurationFile = StringUtil.trimStart(configurationFile, "/META-INF/");
        }
        return this.loadDescriptorFromJarOrDirectory(jarOrDirectory, configurationFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PluginCreator extractZipAndCreatePlugin(@NotNull File zipPlugin, boolean validateDescriptor) {
        ExtractorResult extractorResult;
        try {
            extractorResult = PluginExtractor.INSTANCE.extractPlugin(zipPlugin, this.myExtractDirectory);
        }
        catch (Exception e) {
            this.myLogger.info("Unable to extract plugin zip " + zipPlugin, (Throwable)e);
            return new PluginCreator(PLUGIN_XML, (PluginProblem)new UnableToExtractZip(zipPlugin), zipPlugin);
        }
        if (extractorResult instanceof ExtractorResult.Success) {
            ExtractedPlugin extractedPlugin = ((ExtractorResult.Success)extractorResult).getExtractedPlugin();
            try {
                PluginCreator pluginCreator = this.loadDescriptorFromJarOrDirectory(extractedPlugin.getPluginFile(), PLUGIN_XML, validateDescriptor);
                return pluginCreator;
            }
            finally {
                extractedPlugin.close();
            }
        }
        return new PluginCreator(PLUGIN_XML, ((ExtractorResult.Fail)extractorResult).getPluginProblem(), zipPlugin);
    }

    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull File pluginFile) {
        return this.createPlugin(pluginFile, true);
    }

    @NotNull
    public PluginCreationResult<IdePlugin> createPlugin(@NotNull File pluginFile, boolean validateDescriptor) {
        PluginCreator pluginCreator = this.getPluginCreatorWithResult(pluginFile, validateDescriptor);
        pluginCreator.setOriginalFileAndExtractDir(pluginFile, this.myExtractDirectory);
        return pluginCreator.getPluginCreationResult();
    }

    @NotNull
    private PluginCreator getPluginCreatorWithResult(@NotNull File pluginFile, boolean validateDescriptor) {
        if (!pluginFile.exists()) {
            throw new IllegalArgumentException("Plugin file " + pluginFile + " does not exist");
        }
        PluginCreator pluginCreator = FileUtil.INSTANCE.isZip(pluginFile) ? this.extractZipAndCreatePlugin(pluginFile, validateDescriptor) : this.loadDescriptorFromJarOrDirectory(pluginFile, PLUGIN_XML, validateDescriptor);
        return pluginCreator;
    }
}

