/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.jetbrains.plugin.structure.intellij.beans.IdeaVersionBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependencyBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginVendorBean;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependencyImpl;
import com.jetbrains.plugin.structure.intellij.utils.StringUtil;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdePluginImpl
implements IdePlugin {
    private static final String INTELLIJ_MODULES_PREFIX = "com.intellij.modules.";
    private final Set<String> myDefinedModules = new HashSet<String>();
    private final List<PluginDependency> myDependencies = new ArrayList<PluginDependency>();
    private final Map<PluginDependency, String> myOptionalConfigFiles = new HashMap<PluginDependency, String>();
    private final Map<String, IdePlugin> myOptionalDescriptors = new HashMap<String, IdePlugin>();
    private Multimap<String, Element> myExtensions;
    private File myOriginalFile;
    private File myExtractDirectory;
    private Document myUnderlyingDocument;
    private String myPluginName;
    private String myPluginVersion;
    private String myPluginId;
    private String myPluginVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myDescription;
    private String myUrl;
    private String myNotes;
    private IdeVersion mySinceBuild;
    private IdeVersion myUntilBuild;

    IdePluginImpl(@NotNull Document underlyingDocument, @NotNull PluginBean bean) {
        this.myUnderlyingDocument = underlyingDocument;
        this.setInfoFromBean(bean);
    }

    @Override
    @NotNull
    public Multimap<String, Element> getExtensions() {
        return Multimaps.unmodifiableMultimap(this.myExtensions);
    }

    @Override
    @NotNull
    public List<PluginDependency> getDependencies() {
        return Collections.unmodifiableList(this.myDependencies);
    }

    @Override
    @Nullable
    public IdeVersion getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    @Nullable
    public IdeVersion getUntilBuild() {
        return this.myUntilBuild;
    }

    @Override
    public boolean isCompatibleWithIde(@NotNull IdeVersion ideVersion) {
        if (this.mySinceBuild == null) {
            return true;
        }
        return this.mySinceBuild.compareTo(ideVersion) <= 0 && (this.myUntilBuild == null || ideVersion.compareTo(this.myUntilBuild) <= 0);
    }

    @Nullable
    public String getPluginName() {
        return this.myPluginName;
    }

    @Nullable
    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    @Nullable
    public String getPluginId() {
        return this.myPluginId;
    }

    public String getVendor() {
        return this.myPluginVendor;
    }

    @Override
    @NotNull
    public Set<String> getDefinedModules() {
        return Collections.unmodifiableSet(this.myDefinedModules);
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public String getVendorEmail() {
        return this.myVendorEmail;
    }

    @Nullable
    public String getVendorUrl() {
        return this.myVendorUrl;
    }

    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    private void setInfoFromBean(PluginBean bean) {
        PluginVendorBean vendorBean;
        this.myPluginName = bean.name;
        this.myPluginId = bean.id != null ? bean.id : bean.name;
        this.myUrl = bean.url;
        this.myPluginVersion = bean.pluginVersion != null ? bean.pluginVersion.trim() : null;
        this.myDefinedModules.addAll(bean.modules);
        this.myExtensions = bean.extensions;
        IdeaVersionBean ideaVersionBean = bean.ideaVersion;
        if (ideaVersionBean != null) {
            this.mySinceBuild = ideaVersionBean.sinceBuild != null ? IdeVersion.createIdeVersion(ideaVersionBean.sinceBuild) : null;
            Object untilBuild = ideaVersionBean.untilBuild;
            if (!StringUtil.isEmpty((String)untilBuild)) {
                if (((String)untilBuild).endsWith(".*")) {
                    int idx = ((String)untilBuild).lastIndexOf(46);
                    untilBuild = ((String)untilBuild).substring(0, idx + 1) + Integer.MAX_VALUE;
                }
                this.myUntilBuild = IdeVersion.createIdeVersion((String)untilBuild);
            }
        }
        if (bean.dependencies != null) {
            for (PluginDependencyBean dependencyBean : bean.dependencies) {
                if (dependencyBean.pluginId == null) continue;
                boolean isModule = dependencyBean.pluginId.startsWith(INTELLIJ_MODULES_PREFIX);
                PluginDependencyImpl dependency = new PluginDependencyImpl(dependencyBean.pluginId, dependencyBean.optional, isModule);
                this.myDependencies.add(dependency);
                if (!dependency.isOptional() || dependencyBean.configFile == null) continue;
                this.myOptionalConfigFiles.put(dependency, dependencyBean.configFile);
            }
        }
        if ((vendorBean = bean.vendor) != null) {
            this.myPluginVendor = vendorBean.name != null ? vendorBean.name.trim() : null;
            this.myVendorUrl = vendorBean.url;
            this.myVendorEmail = vendorBean.email;
        }
        this.myNotes = bean.getChangeNotes();
        this.myDescription = bean.getDescription();
    }

    @Nullable
    public String getChangeNotes() {
        return this.myNotes;
    }

    @Override
    @NotNull
    public Map<String, IdePlugin> getOptionalDescriptors() {
        return Collections.unmodifiableMap(this.myOptionalDescriptors);
    }

    void addOptionalDescriptor(@NotNull String configurationFile, @NotNull IdePlugin optionalPlugin) {
        this.myOptionalDescriptors.put(configurationFile, optionalPlugin);
        this.myExtensions.putAll(optionalPlugin.getExtensions());
    }

    @Override
    @NotNull
    public Document getUnderlyingDocument() {
        return this.myUnderlyingDocument.clone();
    }

    @Override
    @Nullable
    public File getOriginalFile() {
        return this.myOriginalFile;
    }

    void setOriginalPluginFile(@NotNull File originalFile) {
        this.myOriginalFile = originalFile;
    }

    public File getExtractDirectory() {
        return this.myExtractDirectory;
    }

    void setExtractDirectory(File extractDirectory) {
        this.myExtractDirectory = extractDirectory;
    }

    @NotNull
    Map<PluginDependency, String> getOptionalDependenciesConfigFiles() {
        return Collections.unmodifiableMap(this.myOptionalConfigFiles);
    }

    public String toString() {
        String id = this.myPluginId;
        if (StringUtil.isEmpty(id)) {
            id = this.myPluginName;
        }
        if (StringUtil.isEmpty(id)) {
            id = this.myUrl;
        }
        return id + (this.getPluginVersion() != null ? ":" + this.getPluginVersion() : "");
    }
}

