/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.extractor;

import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtil;
import com.jetbrains.plugin.structure.base.utils.ZipUtil;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsMultipleFiles;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipContainsUnknownFile;
import com.jetbrains.plugin.structure.intellij.problems.PluginZipIsEmpty;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/extractor/PluginExtractor;", "", "()V", "extractPlugin", "Lcom/jetbrains/plugin/structure/intellij/extractor/ExtractorResult;", "pluginZip", "Ljava/io/File;", "extractDirectory", "fail", "problem", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "extractedPlugin", "getExtractorResult", "success", "actualFile", "fileToDelete", "structure-intellij_main"})
public final class PluginExtractor {
    public static final PluginExtractor INSTANCE;

    @NotNull
    public final ExtractorResult extractPlugin(@NotNull File pluginZip, @NotNull File extractDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)pluginZip, (String)"pluginZip");
        Intrinsics.checkParameterIsNotNull((Object)extractDirectory, (String)"extractDirectory");
        if (!FileUtil.INSTANCE.isZip(pluginZip)) {
            throw (Throwable)new IllegalArgumentException("Must be a zip archive: " + pluginZip);
        }
        File extractedPlugin = FileUtil.INSTANCE.createTempDir(extractDirectory, "plugin_");
        try {
            ZipUtil.INSTANCE.extractZip(pluginZip, extractedPlugin);
        }
        catch (Throwable e) {
            FileUtils.deleteQuietly((File)extractedPlugin);
            throw e;
        }
        return this.getExtractorResult(pluginZip, extractedPlugin);
    }

    private final ExtractorResult success(File actualFile, File fileToDelete) {
        return new ExtractorResult.Success(new ExtractedPlugin(actualFile, fileToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExtractorResult fail(PluginProblem problem, File extractedPlugin) {
        try {
            ExtractorResult extractorResult = new ExtractorResult.Fail(problem);
            return extractorResult;
        }
        finally {
            FileUtils.deleteQuietly((File)extractedPlugin);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ExtractorResult getExtractorResult(File pluginZip, File extractedPlugin) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        PluginZipContainsMultipleFiles pluginZipContainsMultipleFiles;
        Object[] singleFile;
        File[] fileArray = extractedPlugin.listFiles();
        if (fileArray == null) {
            return this.fail(new PluginZipIsEmpty(pluginZip), extractedPlugin);
        }
        File[] rootFiles = fileArray;
        Object[] objectArray = rootFiles;
        if (objectArray.length == 0) {
            return this.fail(new PluginZipIsEmpty(pluginZip), extractedPlugin);
        }
        if (((Object[])rootFiles).length == 1) {
            singleFile = rootFiles[0];
            if (StringsKt.endsWith$default((String)singleFile.getName(), (String)".jar", (boolean)false, (int)2, null)) {
                Intrinsics.checkExpressionValueIsNotNull((Object)singleFile, (String)"singleFile");
                return this.success((File)singleFile, extractedPlugin);
            }
            if (singleFile.isDirectory()) {
                if (Intrinsics.areEqual((Object)singleFile.getName(), (Object)"lib")) {
                    return this.success(extractedPlugin, extractedPlugin);
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)singleFile, (String)"singleFile");
                return this.success((File)singleFile, extractedPlugin);
            }
            String string = singleFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"singleFile.name");
            return this.fail(new PluginZipContainsUnknownFile(pluginZip, string), extractedPlugin);
        }
        singleFile = rootFiles;
        File file = pluginZip;
        PluginZipContainsMultipleFiles pluginZipContainsMultipleFiles2 = pluginZipContainsMultipleFiles;
        PluginZipContainsMultipleFiles pluginZipContainsMultipleFiles3 = pluginZipContainsMultipleFiles;
        PluginExtractor pluginExtractor = this;
        void var5_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            String string = it.getName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        pluginZipContainsMultipleFiles2(file, CollectionsKt.sorted((Iterable)collection));
        return pluginExtractor.fail(pluginZipContainsMultipleFiles3, extractedPlugin);
    }

    private PluginExtractor() {
        INSTANCE = this;
    }

    static {
        new PluginExtractor();
    }
}

