/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.beans;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.transform.JDOMSource;
import org.jetbrains.annotations.NotNull;

public class PluginBeanExtractor {
    @NotNull
    public static PluginBean extractPluginBean(Document document) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{PluginBean.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Element rootElement = document.getRootElement();
        PluginBean bean = (PluginBean)unmarshaller.unmarshal((Source)new JDOMSource(document));
        bean.extensions = PluginBeanExtractor.extractExtensions(rootElement);
        return bean;
    }

    private static Multimap<String, Element> extractExtensions(Element rootElement) {
        ArrayListMultimap extensions = ArrayListMultimap.create();
        for (Element extensionsRoot : rootElement.getChildren("extensions")) {
            for (Element element : extensionsRoot.getChildren()) {
                extensions.put((Object)PluginBeanExtractor.extractEPName(element), (Object)element);
            }
        }
        return extensions;
    }

    private static String extractEPName(Element extensionElement) {
        String epName = extensionElement.getAttributeValue("point");
        if (epName == null) {
            String ns;
            Element parentElement = extensionElement.getParentElement();
            String string = ns = parentElement != null ? parentElement.getAttributeValue("defaultExtensionNs") : null;
            if (ns != null) {
                epName = ns + '.' + extensionElement.getName();
            } else {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            }
        }
        return epName;
    }
}

