/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.AbstractIdeManager;
import com.jetbrains.plugin.structure.ide.IdeManager;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0004\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/ide/AbstractIdeManager;", "Lcom/jetbrains/plugin/structure/ide/IdeManager;", "()V", "createBundledPluginExceptionally", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "idePath", "Ljava/nio/file/Path;", "pluginFile", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "descriptorPath", "", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "readBuildNumber", "versionFile", "readIdeVersionFromBuildNumberFile", "resolveProductSpecificVersion", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nAbstractIdeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractIdeManager.kt\ncom/jetbrains/plugin/structure/ide/AbstractIdeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n766#2:66\n857#2,2:67\n*E\n*S KotlinDebug\n*F\n+ 1 AbstractIdeManager.kt\ncom/jetbrains/plugin/structure/ide/AbstractIdeManager\n*L\n62#1:66\n62#1,2:67\n*E\n"})
public abstract class AbstractIdeManager
extends IdeManager {
    @NotNull
    protected final IdeVersion readBuildNumber(@NotNull Path versionFile) {
        Intrinsics.checkNotNullParameter((Object)versionFile, (String)"versionFile");
        String buildNumberString = ((Object)StringsKt.trim((CharSequence)FileUtilKt.readText$default((Path)versionFile, null, (int)1, null))).toString();
        IdeVersion ideVersion = IdeVersion.createIdeVersion((String)buildNumberString);
        Intrinsics.checkNotNullExpressionValue((Object)ideVersion, (String)"createIdeVersion(buildNumberString)");
        return ideVersion;
    }

    @NotNull
    protected final IdeVersion resolveProductSpecificVersion(@NotNull Path idePath, @NotNull IdeVersion ideVersion) {
        IdeVersion ideVersion2;
        Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        if (((CharSequence)ideVersion.getProductCode()).length() > 0) {
            ideVersion2 = ideVersion;
        } else {
            ideVersion2 = this.readIdeVersionFromBuildNumberFile(idePath);
            if (ideVersion2 == null) {
                ideVersion2 = ideVersion;
            }
        }
        return ideVersion2;
    }

    @Nullable
    protected final IdeVersion readIdeVersionFromBuildNumberFile(@NotNull Path idePath) {
        Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
        Path buildNumberFile = idePath.resolve("build.number");
        Intrinsics.checkNotNullExpressionValue((Object)buildNumberFile, (String)"buildNumberFile");
        if (FileUtilKt.exists((Path)buildNumberFile)) {
            List lines = FileUtilKt.readLines$default((Path)buildNumberFile, null, (int)1, null);
            for (String line : lines) {
                if (!StringsKt.startsWith$default((String)line, (String)"build.number=", (boolean)false, (int)2, null)) continue;
                return IdeVersion.createIdeVersionIfValid((String)StringsKt.substringAfter$default((String)line, (String)"build.number=", null, (int)2, null));
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final IdePlugin createBundledPluginExceptionally(@NotNull Path idePath, @NotNull Path pluginFile, @NotNull ResourceResolver pathResolver, @NotNull String descriptorPath, @NotNull IdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        PluginCreationResult creationResult = IdePluginManager.createBundledPlugin$default((IdePluginManager)IdePluginManager.Companion.createManager(pathResolver), (Path)pluginFile, (IdeVersion)ideVersion, (String)descriptorPath, null, null, (int)24, null);
        if (!(creationResult instanceof PluginCreationSuccess)) {
            if (creationResult instanceof PluginCreationFail) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
                Path path = idePath.relativize(pluginFile);
                Path path2 = idePath;
                boolean $i$f$filter = false;
                void var9_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginProblem it = (PluginProblem)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                String string = "Plugin '" + path + "' is invalid: " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)createBundledPluginExceptionally.2.INSTANCE, (int)31, null);
                Path path3 = path2;
                throw new InvalidIdeException(path3, string);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (IdePlugin)((PluginCreationSuccess)creationResult).getPlugin();
    }
}

