package com.jetbrains.plugin.structure.base.plugin

import java.io.Serializable
import java.util.*

abstract class PluginProblem : Serializable {

  abstract val level: Level

  abstract val message: String

  enum class Level {
    ERROR,
    WARNING
  }

  final override fun toString() = message

  final override fun equals(other: Any?) = other is PluginProblem
      && level == other.level && message == other.message

  final override fun hashCode() = Objects.hash(message, level)

}