/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarArchiveException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u0004H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/plugin/structure/jar/UriJarFileSystemProvider;", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "pathToUri", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Ljava/net/URI;", "(Lkotlin/jvm/functions/Function1;)V", "log", "Lorg/slf4j/Logger;", "getFileSystem", "Ljava/nio/file/FileSystem;", "jarPath", "isZipOrJar", "", "structure-base"})
public final class UriJarFileSystemProvider
implements JarFileSystemProvider {
    @NotNull
    private final Function1<Path, URI> pathToUri;
    @NotNull
    private final Logger log;

    public UriJarFileSystemProvider(@NotNull Function1<? super Path, URI> pathToUri) {
        Intrinsics.checkNotNullParameter(pathToUri, (String)"pathToUri");
        this.pathToUri = pathToUri;
        Logger logger = LoggerFactory.getLogger(UriJarFileSystemProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(UriJarFileSystemProvider::class.java)");
        this.log = logger;
    }

    public /* synthetic */ UriJarFileSystemProvider(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super Path, URI>)function1);
    }

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull Path jarPath) throws JarArchiveCannotBeOpenException {
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        URI jarUri = (URI)this.pathToUri.invoke((Object)jarPath);
        try {
            FileSystem fileSystem2;
            if (!this.isZipOrJar(jarPath)) {
                throw new JarArchiveCannotBeOpenException(jarPath, "must end with '.zip' or '.jar'");
            }
            try {
                FileSystem it = fileSystem2 = FileSystems.getFileSystem(jarUri);
                boolean bl = false;
                this.log.debug("Reusing JAR filesystem from JVM cache <{}>", (Object)jarUri);
            }
            catch (FileSystemNotFoundException fileSystemNotFoundException) {
                FileSystem fileSystem3;
                try {
                    FileSystem it = fileSystem3 = FileSystems.newFileSystem(jarUri, MapsKt.emptyMap());
                    boolean bl = false;
                    this.log.debug("JAR filesystem not found. Creating a new one for <{}>", (Object)jarUri);
                }
                catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                    FileSystem fileSystem4;
                    FileSystem it = fileSystem4 = FileSystems.getFileSystem(jarUri);
                    boolean bl = false;
                    this.log.debug("Reusing JAR filesystem from JVM cache <{}> (2nd attempt)", (Object)jarUri);
                    fileSystem3 = fileSystem4;
                }
                fileSystem2 = fileSystem3;
            }
            FileSystem fileSystem5 = fileSystem2;
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem5, (String)"{\n      if (!jarPath.isZ\u2026}\n        }\n      }\n    }");
            fileSystem = fileSystem5;
        }
        catch (JarArchiveCannotBeOpenException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JarArchiveCannotBeOpenException(jarUri, e);
        }
        return fileSystem;
    }

    private final boolean isZipOrJar(Path $this$isZipOrJar) {
        Object[] objectArray = new String[]{"zip", "jar"};
        return CollectionsKt.listOf((Object[])objectArray).contains(FileUtilKt.getExtension($this$isZipOrJar));
    }

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull Path jarPath, @NotNull JarFileSystemProvider.Configuration configuration) throws JarArchiveException {
        return JarFileSystemProvider.DefaultImpls.getFileSystem(this, jarPath, configuration);
    }

    public UriJarFileSystemProvider() {
        this(null, 1, null);
    }
}

