/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.fs;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0013\u0010\u0010\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0000H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016JC\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\u0010 \u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\"\u0018\u00010!2\u0016\u0010#\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010$0!\"\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0018\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0016J\b\u0010,\u001a\u00020\u0000H\u0016J!\u0010-\u001a\u00020\u00002\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020/0!\"\u00020/H\u0016\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0004\u0018\u00010\u0000*\u0004\u0018\u00010\u0001H\u0002J\f\u00106\u001a\u00020\u0000*\u00020\u0001H\u0002R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00067"}, d2={"Lcom/jetbrains/plugin/structure/fs/FsHandlerPath;", "Ljava/nio/file/Path;", "fileSystem", "Ljava/nio/file/FileSystem;", "delegatePath", "(Ljava/nio/file/FileSystem;Ljava/nio/file/Path;)V", "getDelegatePath", "()Ljava/nio/file/Path;", "unwrapped", "getUnwrapped", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "compareTo", "", "other", "endsWith", "", "equals", "", "getFileName", "getFileSystem", "getName", "index", "getNameCount", "getParent", "getRoot", "hashCode", "isAbsolute", "normalize", "register", "Ljava/nio/file/WatchKey;", "watcher", "Ljava/nio/file/WatchService;", "events", "", "Ljava/nio/file/WatchEvent$Kind;", "modifiers", "Ljava/nio/file/WatchEvent$Modifier;", "(Ljava/nio/file/WatchService;[Ljava/nio/file/WatchEvent$Kind;[Ljava/nio/file/WatchEvent$Modifier;)Ljava/nio/file/WatchKey;", "relativize", "resolve", "startsWith", "subpath", "beginIndex", "endIndex", "toAbsolutePath", "toRealPath", "options", "Ljava/nio/file/LinkOption;", "([Ljava/nio/file/LinkOption;)Lcom/jetbrains/plugin/structure/fs/FsHandlerPath;", "toString", "", "toUri", "Ljava/net/URI;", "wrap", "wrapNotNull", "structure-base"})
public final class FsHandlerPath
implements Path {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path delegatePath;

    public FsHandlerPath(@NotNull FileSystem fileSystem, @NotNull Path delegatePath) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)delegatePath, (String)"delegatePath");
        this.fileSystem = fileSystem;
        this.delegatePath = delegatePath;
    }

    @NotNull
    public final Path getDelegatePath() {
        return this.delegatePath;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.delegatePath.isAbsolute();
    }

    @Override
    @Nullable
    public FsHandlerPath getRoot() {
        return this.wrap(this.delegatePath.getRoot());
    }

    @Override
    @Nullable
    public FsHandlerPath getFileName() {
        return this.wrap(this.delegatePath.getFileName());
    }

    @Override
    @Nullable
    public FsHandlerPath getParent() {
        return this.wrap(this.delegatePath.getParent());
    }

    @Override
    public int getNameCount() {
        return this.delegatePath.getNameCount();
    }

    @Override
    @NotNull
    public FsHandlerPath getName(int index) {
        Path path = this.delegatePath.getName(index);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"delegatePath.getName(index)");
        return this.wrapNotNull(path);
    }

    @Override
    @NotNull
    public FsHandlerPath subpath(int beginIndex, int endIndex) {
        Path path = this.delegatePath.subpath(beginIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"delegatePath.subpath(beginIndex, endIndex)");
        return this.wrapNotNull(path);
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.delegatePath.startsWith(this.getUnwrapped(other));
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.delegatePath.endsWith(this.getUnwrapped(other));
    }

    @Override
    @NotNull
    public FsHandlerPath normalize() {
        Path path = this.delegatePath.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"delegatePath.normalize()");
        return this.wrapNotNull(path);
    }

    @Override
    @NotNull
    public FsHandlerPath resolve(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = this.delegatePath.resolve(this.getUnwrapped(other));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"delegatePath.resolve(other.unwrapped)");
        return this.wrapNotNull(path);
    }

    @Override
    @NotNull
    public FsHandlerPath relativize(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = this.delegatePath.relativize(this.getUnwrapped(other));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"delegatePath.relativize(other.unwrapped)");
        return this.wrapNotNull(path);
    }

    @Override
    @NotNull
    public URI toUri() {
        URI uRI = this.delegatePath.toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"delegatePath.toUri()");
        return uRI;
    }

    @Override
    @NotNull
    public FsHandlerPath toAbsolutePath() {
        Path path = this.delegatePath.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"delegatePath.toAbsolutePath()");
        return this.wrapNotNull(path);
    }

    @Override
    @NotNull
    public FsHandlerPath toRealPath(LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Path path = this.delegatePath.toRealPath(Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"delegatePath.toRealPath(*options)");
        return this.wrapNotNull(path);
    }

    @Override
    @NotNull
    public WatchKey register(@NotNull WatchService watcher, @Nullable WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        WatchKey watchKey = this.delegatePath.register(watcher, events, Arrays.copyOf(modifiers, modifiers.length));
        Intrinsics.checkNotNullExpressionValue((Object)watchKey, (String)"delegatePath.register(watcher, events, *modifiers)");
        return watchKey;
    }

    @Override
    public int compareTo(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.delegatePath.compareTo(this.getUnwrapped(other));
    }

    private final FsHandlerPath wrapNotNull(Path $this$wrapNotNull) {
        return new FsHandlerPath(this.fileSystem, $this$wrapNotNull);
    }

    private final FsHandlerPath wrap(Path $this$wrap) {
        FsHandlerPath fsHandlerPath;
        Path path = $this$wrap;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            fsHandlerPath = new FsHandlerPath(this.fileSystem, it);
        } else {
            fsHandlerPath = null;
        }
        return fsHandlerPath;
    }

    private final Path getUnwrapped(Path $this$unwrapped) {
        Path path = $this$unwrapped instanceof FsHandlerPath ? (FsHandlerPath)$this$unwrapped : null;
        if (path == null || (path = path.delegatePath) == null) {
            path = $this$unwrapped;
        }
        return path;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.delegatePath).toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Path)) {
            return false;
        }
        Path unwrappedOther = this.getUnwrapped((Path)other);
        return Intrinsics.areEqual((Object)this.delegatePath, (Object)unwrappedOther);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegatePath).hashCode();
    }
}

