/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.zip;

import com.jetbrains.plugin.structure.base.zip.MalformedZipArchiveException;
import com.jetbrains.plugin.structure.base.zip.ZipArchiveException;
import com.jetbrains.plugin.structure.base.zip.ZipArchiveIOException;
import com.jetbrains.plugin.structure.base.zip.ZipHandler;
import com.jetbrains.plugin.structure.base.zip.ZipResource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J9\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J0\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0014\"\u0004\b\u0000\u0010\u000e2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u0010H\u0016J(\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u00160\u0018H\u0082\b\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/base/zip/ZipFileHandler;", "Lcom/jetbrains/plugin/structure/base/zip/ZipHandler;", "Lcom/jetbrains/plugin/structure/base/zip/ZipResource$ZipFileResource;", "zipPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "zipFile", "Ljava/io/File;", "(Ljava/io/File;)V", "containsEntry", "", "entryName", "", "handleEntry", "T", "handler", "Lkotlin/Function2;", "Ljava/util/zip/ZipEntry;", "(Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "iterate", "", "withZip", "R", "block", "Lkotlin/Function1;", "Ljava/util/zip/ZipFile;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "structure-base"})
@SourceDebugExtension(value={"SMAP\nZipFileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFileHandler.kt\ncom/jetbrains/plugin/structure/base/zip/ZipFileHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n46#1,2:55\n48#1,4:59\n46#1,2:63\n48#1,4:67\n46#1,2:71\n48#1,4:74\n1#2:57\n1#2:58\n1#2:65\n1#2:66\n1#2:73\n1#2:78\n*E\n*S KotlinDebug\n*F\n+ 1 ZipFileHandler.kt\ncom/jetbrains/plugin/structure/base/zip/ZipFileHandler\n*L\n20#1,2:55\n20#1,4:59\n34#1,2:63\n34#1,4:67\n41#1,2:71\n41#1,4:74\n20#1:57\n34#1:65\n41#1:73\n*E\n"})
public final class ZipFileHandler
implements ZipHandler<ZipResource.ZipFileResource> {
    @NotNull
    private final File zipFile;

    public ZipFileHandler(@NotNull File zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        this.zipFile = zipFile;
    }

    public ZipFileHandler(@NotNull Path zipPath) {
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        File file = zipPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"zipPath.toFile()");
        this(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> List<T> iterate(@NotNull Function2<? super ZipEntry, ? super ZipResource.ZipFileResource, ? extends T> handler) throws ZipArchiveException {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        List results = new ArrayList();
        ZipFileHandler this_$iv = this;
        boolean $i$f$withZip = false;
        try {
            Unit unit;
            Closeable closeable = new ZipFile(this_$iv.zipFile);
            Throwable throwable = null;
            try {
                ZipFile it$iv = (ZipFile)closeable;
                boolean bl = false;
                ZipFile zip = it$iv;
                boolean bl2 = false;
                Enumeration<? extends ZipEntry> entries = zip.entries();
                ZipResource.ZipFileResource zipResource = new ZipResource.ZipFileResource(zip);
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry == null) continue;
                    Object it = entry;
                    boolean bl3 = false;
                    Object object = handler.invoke((Object)entry, (Object)zipResource);
                    if (object == null) continue;
                    it = object;
                    boolean bl4 = false;
                    ((Collection)results).add(it);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = unit;
        }
        catch (ZipException e$iv) {
            throw new MalformedZipArchiveException(this_$iv.zipFile, (Throwable)e$iv);
        }
        catch (IOException e$iv) {
            throw new ZipArchiveIOException(this_$iv.zipFile, (Throwable)e$iv);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T handleEntry(@NotNull CharSequence entryName, @NotNull Function2<? super ZipEntry, ? super ZipResource.ZipFileResource, ? extends T> handler) throws ZipArchiveException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        ZipFileHandler this_$iv = this;
        boolean $i$f$withZip = false;
        try {
            Object object2;
            object = new ZipFile(this_$iv.zipFile);
            Throwable throwable = null;
            try {
                Object object3;
                ZipEntry entry;
                ZipFile it$iv = (ZipFile)object;
                boolean bl = false;
                ZipFile zip = it$iv;
                boolean bl2 = false;
                ZipResource.ZipFileResource zipResource = new ZipResource.ZipFileResource(zip);
                ZipEntry zipEntry = entry = zip.getEntry(((Object)entryName).toString());
                if (zipEntry != null) {
                    ZipEntry it = zipEntry;
                    boolean bl3 = false;
                    object3 = handler.invoke((Object)entry, (Object)zipResource);
                } else {
                    object3 = null;
                }
                object2 = object3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = object2;
        }
        catch (ZipException e$iv) {
            throw new MalformedZipArchiveException(this_$iv.zipFile, (Throwable)e$iv);
        }
        catch (IOException e$iv) {
            throw new ZipArchiveIOException(this_$iv.zipFile, (Throwable)e$iv);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsEntry(@NotNull CharSequence entryName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        ZipFileHandler this_$iv = this;
        boolean $i$f$withZip = false;
        try {
            boolean bl2;
            Closeable closeable = new ZipFile(this_$iv.zipFile);
            Throwable throwable = null;
            try {
                ZipFile it$iv = (ZipFile)closeable;
                boolean bl3 = false;
                ZipFile zip = it$iv;
                boolean bl4 = false;
                bl2 = zip.getEntry(((Object)entryName).toString()) != null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = bl2;
        }
        catch (ZipException e$iv) {
            throw new MalformedZipArchiveException(this_$iv.zipFile, (Throwable)e$iv);
        }
        catch (IOException e$iv) {
            throw new ZipArchiveIOException(this_$iv.zipFile, (Throwable)e$iv);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R withZip(Function1<? super ZipFile, ? extends R> block) {
        Object object;
        boolean $i$f$withZip = false;
        try {
            Object object2;
            object = new ZipFile(this.zipFile);
            Throwable throwable = null;
            try {
                ZipFile it = (ZipFile)object;
                boolean bl = false;
                object2 = block.invoke((Object)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (ZipException e) {
            throw new MalformedZipArchiveException(this.zipFile, (Throwable)e);
        }
        catch (IOException e) {
            throw new ZipArchiveIOException(this.zipFile, (Throwable)e);
        }
        return (R)object;
    }
}

