/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.telemetry;

import com.jetbrains.plugin.structure.base.telemetry.PluginTelemetry;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001J\u0019\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0017H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0001R,\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/base/telemetry/MutablePluginTelemetry;", "Lcom/jetbrains/plugin/structure/base/telemetry/PluginTelemetry;", "()V", "value", "", "Lcom/jetbrains/plugin/structure/base/utils/Bytes;", "archiveFileSize", "getArchiveFileSize", "()J", "setArchiveFileSize", "(J)V", "Ljava/time/Duration;", "parsingDuration", "getParsingDuration", "()Ljava/time/Duration;", "setParsingDuration", "(Ljava/time/Duration;)V", "merge", "", "telemetry", "set", "key", "", "", "toImmutable", "structure-base"})
public final class MutablePluginTelemetry
extends PluginTelemetry {
    public MutablePluginTelemetry() {
        super(new Pair[0]);
    }

    @Override
    public long getArchiveFileSize() {
        Object object = this.getData().getOrDefault("plugin.archive.file.size", -1L);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long{ com.jetbrains.plugin.structure.base.utils.FileUtilKt.Bytes }");
        return (Long)object;
    }

    public void setArchiveFileSize(long value) {
        Long l = value;
        this.getData().put("plugin.archive.file.size", l);
    }

    @Override
    @Nullable
    public Duration getParsingDuration() {
        Object parsingDurationVal = this.getData().get("plugin.parsing.duration");
        return parsingDurationVal instanceof Duration ? (Duration)parsingDurationVal : null;
    }

    public void setParsingDuration(@Nullable Duration value) {
        if (value != null) {
            this.getData().put("plugin.parsing.duration", value);
        } else {
            this.getData().remove("plugin.parsing.duration");
        }
    }

    public final void set(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getData().put(key, value);
    }

    public final void merge(@NotNull PluginTelemetry telemetry) {
        Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
        this.getData().putAll(telemetry.toMap());
    }

    @NotNull
    public final PluginTelemetry toImmutable() {
        return new PluginTelemetry(this.getData());
    }
}

