/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.problems;

import com.jetbrains.plugin.structure.base.problems.PluginFileError;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/base/problems/IncorrectJarOrDirectory;", "Lcom/jetbrains/plugin/structure/base/problems/PluginFileError;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "message", "", "getMessage", "()Ljava/lang/String;", "structure-base"})
public final class IncorrectJarOrDirectory
extends PluginFileError {
    @NotNull
    private final Path path;

    public IncorrectJarOrDirectory(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @Override
    @NotNull
    public String getMessage() {
        String type = FileUtilKt.isZip(this.path) ? "ZIP file" : (FileUtilKt.isDirectory(this.path) ? "directory" : "file");
        return "The plugin artifact path must be a .jar archive or a directory, but was a " + type + " at [" + this.path + "]";
    }
}

