/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.base.plugin.IconTheme;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependency;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependencyKt;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.jar.DefaultJarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJarKt;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\fJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/plugin/structure/jar/PluginJar;", "Ljava/lang/AutoCloseable;", "jarPath", "Ljava/nio/file/Path;", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "jarFileSystem", "Ljava/nio/file/FileSystem;", "close", "", "getIconFileName", "", "iconTheme", "Lcom/jetbrains/plugin/structure/base/plugin/IconTheme;", "getIcons", "", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "getPluginDescriptor", "Lcom/jetbrains/plugin/structure/jar/PluginDescriptorResult;", "descriptorPathValue", "getThirdPartyDependencies", "Lcom/jetbrains/plugin/structure/base/plugin/ThirdPartyDependency;", "resolveDescriptorPath", "descriptorPath", "toCanonicalPath", "structure-base"})
@SourceDebugExtension(value={"SMAP\nPluginJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginJar.kt\ncom/jetbrains/plugin/structure/jar/PluginJar\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n11653#2,9:68\n13579#2:77\n13580#2:79\n11662#2:80\n1#3:78\n*E\n*S KotlinDebug\n*F\n+ 1 PluginJar.kt\ncom/jetbrains/plugin/structure/jar/PluginJar\n*L\n41#1,9:68\n41#1:77\n41#1:79\n41#1:80\n41#1:78\n*E\n"})
public final class PluginJar
implements AutoCloseable {
    private final FileSystem jarFileSystem;
    private final Path jarPath;
    private final JarFileSystemProvider jarFileSystemProvider;

    @Nullable
    public final Path resolveDescriptorPath(@NotNull String descriptorPath) {
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Path descriptor = this.jarFileSystem.getPath(this.toCanonicalPath(descriptorPath), new String[0]);
        return Files.exists(descriptor, new LinkOption[0]) ? descriptor : null;
    }

    public static /* synthetic */ Path resolveDescriptorPath$default(PluginJar pluginJar, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = PluginJarKt.getPLUGIN_XML_RESOURCE_PATH();
        }
        return pluginJar.resolveDescriptorPath(string);
    }

    @NotNull
    public final PluginDescriptorResult getPluginDescriptor(@NotNull String descriptorPathValue) {
        Intrinsics.checkNotNullParameter((Object)descriptorPathValue, (String)"descriptorPathValue");
        Path path = this.resolveDescriptorPath(descriptorPathValue);
        if (path == null) {
            return PluginDescriptorResult.NotFound.INSTANCE;
        }
        Path descriptorPath = path;
        InputStream inputStream = FileUtilKt.inputStream(descriptorPath);
        int n = 8192;
        return new PluginDescriptorResult.Found(descriptorPath, inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n));
    }

    public static /* synthetic */ PluginDescriptorResult getPluginDescriptor$default(PluginJar pluginJar, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = PluginJarKt.getPLUGIN_XML_RESOURCE_PATH();
        }
        return pluginJar.getPluginDescriptor(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginIcon> getIcons() {
        void $this$mapNotNullTo$iv$iv;
        IconTheme[] $this$mapNotNull$iv = IconTheme.values();
        boolean $i$f$mapNotNull = false;
        IconTheme[] iconThemeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PluginIcon pluginIcon;
            Path iconPath;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void theme = element$iv$iv;
            boolean bl2 = false;
            String iconEntryName = "META-INF/" + this.getIconFileName((IconTheme)theme);
            Path path = iconPath = this.jarFileSystem.getPath("META-INF", this.getIconFileName((IconTheme)theme));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"iconPath");
            PluginIcon pluginIcon2 = FileUtilKt.exists(path) ? new PluginIcon((IconTheme)theme, FileUtilKt.readBytes(iconPath), iconEntryName) : null;
            if (pluginIcon2 == null) continue;
            PluginIcon it$iv$iv = pluginIcon = pluginIcon2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<ThirdPartyDependency> getThirdPartyDependencies() {
        Path path;
        Path path2 = path = this.jarFileSystem.getPath("META-INF", PluginJarKt.access$getTHIRD_PARTY_LIBRARIES_FILE_NAME$p());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        return ThirdPartyDependencyKt.parseThirdPartyDependenciesByPath(path2);
    }

    private final String toCanonicalPath(String descriptorPath) {
        return ((Object)Paths.get(FileUtilKt.toSystemIndependentName(descriptorPath), new String[0]).normalize()).toString();
    }

    private final String getIconFileName(IconTheme iconTheme) {
        return "pluginIcon" + iconTheme.getSuffix() + ".svg";
    }

    @Override
    public void close() {
        this.jarFileSystemProvider.close(this.jarPath);
    }

    public PluginJar(@NotNull Path jarPath, @NotNull JarFileSystemProvider jarFileSystemProvider) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Intrinsics.checkNotNullParameter((Object)jarFileSystemProvider, (String)"jarFileSystemProvider");
        this.jarPath = jarPath;
        this.jarFileSystemProvider = jarFileSystemProvider;
        this.jarFileSystem = this.jarFileSystemProvider.getFileSystem(this.jarPath);
    }

    public /* synthetic */ PluginJar(Path path, JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jarFileSystemProvider = new DefaultJarFileSystemProvider();
        }
        this(path, jarFileSystemProvider);
    }
}

