/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginJar;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/jar/DefaultJarFileSystemProvider;", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "()V", "close", "", "jarPath", "Ljava/nio/file/Path;", "getFileSystem", "Ljava/nio/file/FileSystem;", "structure-base"})
public final class DefaultJarFileSystemProvider
implements JarFileSystemProvider {
    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull Path jarPath) throws JarArchiveCannotBeOpenException {
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        try {
            FileSystem fileSystem2 = FileSystems.newFileSystem(jarPath, PluginJar.class.getClassLoader());
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"FileSystems.newFileSyste\u2026::class.java.classLoader)");
            fileSystem = fileSystem2;
        }
        catch (Throwable e) {
            throw (Throwable)new JarArchiveCannotBeOpenException(jarPath, e);
        }
        return fileSystem;
    }

    @Override
    public void close(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
    }
}

