/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.decompress;

import com.jetbrains.plugin.structure.base.decompress.Decompressor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/TarDecompressor;", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor;", "tarFile", "Ljava/nio/file/Path;", "sizeLimit", "", "(Ljava/nio/file/Path;Ljava/lang/Long;)V", "stream", "Lorg/apache/commons/compress/archivers/tar/TarArchiveInputStream;", "closeNextEntryStream", "", "entryStream", "Ljava/io/InputStream;", "closeStream", "nextEntry", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Entry;", "nextEntryStream", "openStream", "structure-base"})
public final class TarDecompressor
extends Decompressor {
    private TarArchiveInputStream stream;
    private final Path tarFile;

    /*
     * WARNING - void declaration
     */
    @Override
    public void openStream() {
        TarArchiveInputStream tarArchiveInputStream;
        TarDecompressor tarDecompressor = this;
        try {
            TarDecompressor tarDecompressor2 = tarDecompressor;
            InputStream inputStream = FileUtilKt.inputStream(this.tarFile);
            int n = 8192;
            CompressorInputStream compressorStream = new CompressorStreamFactory().createCompressorInputStream((InputStream)(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n)));
            tarArchiveInputStream = new TarArchiveInputStream((InputStream)compressorStream);
        }
        catch (CompressorException compressorException) {
            void e;
            TarDecompressor tarDecompressor3 = tarDecompressor;
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw cause;
            }
            throw (Throwable)e;
        }
        tarDecompressor2.stream = tarArchiveInputStream;
    }

    @Override
    @Nullable
    public Decompressor.Entry nextEntry() {
        TarArchiveEntry nextTarEntry;
        Decompressor.Type type;
        do {
            TarArchiveInputStream tarArchiveInputStream = this.stream;
            Intrinsics.checkNotNull((Object)tarArchiveInputStream);
            if (tarArchiveInputStream.getNextTarEntry() == null) {
                return null;
            }
            type = nextTarEntry.isFile() ? Decompressor.Type.FILE : (nextTarEntry.isDirectory() ? Decompressor.Type.DIR : (nextTarEntry.isSymbolicLink() ? Decompressor.Type.SYMLINK : null));
        } while (type == null);
        Decompressor.Type type2 = type;
        String string = nextTarEntry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextTarEntry.name");
        return new Decompressor.Entry(string, type2);
    }

    @Override
    @Nullable
    public InputStream nextEntryStream() {
        return (InputStream)this.stream;
    }

    @Override
    public void closeNextEntryStream(@NotNull InputStream entryStream) {
        Intrinsics.checkNotNullParameter((Object)entryStream, (String)"entryStream");
    }

    @Override
    public void closeStream() {
        TarArchiveInputStream tarArchiveInputStream = this.stream;
        if (tarArchiveInputStream != null) {
            tarArchiveInputStream.close();
        }
        this.stream = null;
    }

    public TarDecompressor(@NotNull Path tarFile, @Nullable Long sizeLimit) {
        Intrinsics.checkNotNullParameter((Object)tarFile, (String)"tarFile");
        super(sizeLimit, null);
        this.tarFile = tarFile;
    }
}

