/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\r\u001a\n\u0010\u0014\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0015\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0005\u001a\n\u0010\u0018\u001a\u00020\t*\u00020\u0005\u001a\n\u0010\u0019\u001a\u00020\t*\u00020\u0005\u001a\n\u0010\u001a\u001a\u00020\t*\u00020\u0005\u001a7\u0010\u001b\u001a\u00020\u0017*\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001d2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00170\u001f\u001a\n\u0010#\u001a\u00020\u0017*\u00020\u0005\u001a\n\u0010$\u001a\u00020\u0017*\u00020\u0005\u001a\u0012\u0010%\u001a\u00020\t*\u00020\u00052\u0006\u0010&\u001a\u00020\u0004\u001a\n\u0010'\u001a\u00020(*\u00020\u0005\u001a\n\u0010)\u001a\u00020\t*\u00020\u0005\u001a\n\u0010*\u001a\u00020\t*\u00020\u0005\u001a\u0010\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050,*\u00020\u0005\u001a \u0010-\u001a\u0010\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00050\u00050,*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010.\u001a\u00020/*\u00020\u0005\u001a\n\u00100\u001a\u000201*\u00020\u0005\u001a\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u00040,*\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\u0014\u00103\u001a\u00020\u0004*\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u001a\n\u00104\u001a\u00020\u0004*\u00020\u0004\u001a\n\u00105\u001a\u00020\u0004*\u00020\u0004\u001a\n\u00106\u001a\u00020\u0004*\u00020\u0004\u001a\u0012\u00107\u001a\u00020\u0004*\u00020\u00042\u0006\u00108\u001a\u00020\u0005\u001a\n\u00109\u001a\u00020\u0004*\u00020\u0004\u001a\u0012\u0010:\u001a\u00020\u0017*\u00020\u00052\u0006\u0010;\u001a\u000201\u001a\u001c\u0010<\u001a\u00020\u0017*\u00020\u00052\u0006\u0010=\u001a\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u001d\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u0015\u0010\u000b\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\"\u0015\u0010\f\u001a\u00020\r*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\"\u0015\u0010\u0012\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006>"}, d2={"LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "extension", "", "Ljava/nio/file/Path;", "getExtension", "(Ljava/nio/file/Path;)Ljava/lang/String;", "isDirectory", "", "(Ljava/nio/file/Path;)Z", "isFile", "length", "", "getLength", "(Ljava/nio/file/Path;)J", "nameWithoutExtension", "getNameWithoutExtension", "simpleName", "getSimpleName", "create", "createDir", "createParentDirs", "", "deleteLogged", "deleteQuietly", "exists", "forEachLine", "charset", "Ljava/nio/charset/Charset;", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "line", "forceDeleteIfExists", "forceRemoveDirectory", "hasExtension", "expected", "inputStream", "Ljava/io/InputStream;", "isJar", "isZip", "listFiles", "", "listRecursivelyAllFilesWithExtension", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readLines", "readText", "replaceInvalidFileNameCharacters", "toSystemDependentName", "toSystemIndependentName", "withPathSeparatorOf", "path", "withZipFsSeparator", "writeBytes", "bytes", "writeText", "text", "structure-base"})
public final class FileUtilKt {
    private static final Logger LOG = LoggerFactory.getLogger((String)"structure.FileUtil");

    public static final boolean isZip(@NotNull Path $this$isZip) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isZip, (String)"$this$isZip");
        return FileUtilKt.hasExtension($this$isZip, "zip");
    }

    public static final boolean isJar(@NotNull Path $this$isJar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isJar, (String)"$this$isJar");
        return FileUtilKt.hasExtension($this$isJar, "jar");
    }

    public static final boolean hasExtension(@NotNull Path $this$hasExtension, @NotNull String expected) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasExtension, (String)"$this$hasExtension");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return Files.isRegularFile($this$hasExtension, new LinkOption[0]) && Intrinsics.areEqual((Object)expected, (Object)FileUtilKt.getExtension($this$hasExtension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> listRecursivelyAllFilesWithExtension(@NotNull Path $this$listRecursivelyAllFilesWithExtension, @NotNull String extension) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$this$listRecursivelyAllFilesWithExtension, (String)"$this$listRecursivelyAllFilesWithExtension");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        AutoCloseable autoCloseable = Files.walk($this$listRecursivelyAllFilesWithExtension, FileVisitOption.FOLLOW_LINKS);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl2 = false;
            Stream stream2 = stream.filter((Predicate)new Predicate<Path>(extension){
                final /* synthetic */ String $extension$inlined;
                {
                    this.$extension$inlined = string;
                }

                public final boolean test(Path it) {
                    return StringsKt.endsWith$default((String)((Object)it).toString(), (String)('.' + this.$extension$inlined), (boolean)false, (int)2, null);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"stream.filter { it.toStr\u2026dsWith(\".${extension}\") }");
            list = StreamsKt.toList(stream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public static final String withPathSeparatorOf(@NotNull String $this$withPathSeparatorOf, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)$this$withPathSeparatorOf, (String)"$this$withPathSeparatorOf");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String string = StringsKt.replace$default((String)$this$withPathSeparatorOf, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        FileSystem fileSystem = path.getFileSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem, (String)"path.fileSystem");
        String string2 = fileSystem.getSeparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path.fileSystem.separator");
        return StringsKt.replace$default((String)string, (String)"/", (String)string2, (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String withZipFsSeparator(@NotNull String $this$withZipFsSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$this$withZipFsSeparator, (String)"$this$withZipFsSeparator");
        return StringsKt.replace$default((String)$this$withZipFsSeparator, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String toSystemIndependentName(@NotNull String $this$toSystemIndependentName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toSystemIndependentName, (String)"$this$toSystemIndependentName");
        return StringsKt.replace$default((String)$this$toSystemIndependentName, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String toSystemDependentName(@NotNull String $this$toSystemDependentName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toSystemDependentName, (String)"$this$toSystemDependentName");
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem, (String)"FileSystems.getDefault()");
        String string = fileSystem.getSeparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileSystems.getDefault().separator");
        return StringsKt.replace$default((String)$this$toSystemDependentName, (String)"/", (String)string, (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String replaceInvalidFileNameCharacters(@NotNull String $this$replaceInvalidFileNameCharacters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$replaceInvalidFileNameCharacters, (String)"$this$replaceInvalidFileNameCharacters");
        CharSequence charSequence = $this$replaceInvalidFileNameCharacters;
        Regex regex = new Regex("[^a-zA-Z0-9.#\\-() ]");
        String string = "_";
        boolean bl = false;
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final InputStream inputStream(@NotNull Path $this$inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)$this$inputStream, (String)"$this$inputStream");
        InputStream inputStream = Files.newInputStream($this$inputStream, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(this)");
        return inputStream;
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream) {
        Intrinsics.checkParameterIsNotNull((Object)$this$outputStream, (String)"$this$outputStream");
        OutputStream outputStream = Files.newOutputStream($this$outputStream, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(this)");
        return outputStream;
    }

    public static final void writeText(@NotNull Path $this$writeText, @NotNull String text, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeText, (String)"$this$writeText");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        String string = text;
        Path path = $this$writeText;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        FileUtilKt.writeBytes(path, byArray2);
    }

    public static /* synthetic */ void writeText$default(Path path, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FileUtilKt.writeText(path, string, charset);
    }

    @NotNull
    public static final String readText(@NotNull Path $this$readText, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readText, (String)"$this$readText");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        byte[] byArray = Files.readAllBytes($this$readText);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(this)");
        byte[] byArray2 = byArray;
        boolean bl = false;
        return new String(byArray2, charset);
    }

    public static /* synthetic */ String readText$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileUtilKt.readText(path, charset);
    }

    @NotNull
    public static final List<String> readLines(@NotNull Path $this$readLines, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readLines, (String)"$this$readLines");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        ArrayList result = new ArrayList();
        FileUtilKt.forEachLine($this$readLines, charset, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(result){
            final /* synthetic */ ArrayList $result;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$result.add(it);
            }
            {
                this.$result = arrayList;
                super(1);
            }
        }));
        return result;
    }

    public static /* synthetic */ List readLines$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileUtilKt.readLines(path, charset);
    }

    public static final void forEachLine(@NotNull Path $this$forEachLine, @NotNull Charset charset, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$forEachLine, (String)"$this$forEachLine");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        TextStreamsKt.forEachLine((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream($this$forEachLine, new OpenOption[0]), charset)), action);
    }

    public static /* synthetic */ void forEachLine$default(Path path, Charset charset, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        FileUtilKt.forEachLine(path, charset, (Function1<? super String, Unit>)function1);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Path $this$readBytes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readBytes, (String)"$this$readBytes");
        byte[] byArray = Files.readAllBytes($this$readBytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(this)");
        return byArray;
    }

    public static final void writeBytes(@NotNull Path $this$writeBytes, @NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeBytes, (String)"$this$writeBytes");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Files.write($this$writeBytes, bytes, new OpenOption[0]);
    }

    @NotNull
    public static final Path createDir(@NotNull Path $this$createDir) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createDir, (String)"$this$createDir");
        Files.createDirectories($this$createDir, new FileAttribute[0]);
        return $this$createDir;
    }

    @NotNull
    public static final Path create(@NotNull Path $this$create) {
        Intrinsics.checkParameterIsNotNull((Object)$this$create, (String)"$this$create");
        if ($this$create.getParent() != null) {
            Files.createDirectories($this$create.getParent(), new FileAttribute[0]);
        }
        Files.createFile($this$create, new FileAttribute[0]);
        return $this$create;
    }

    public static final void createParentDirs(@NotNull Path $this$createParentDirs) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$this$createParentDirs, (String)"$this$createParentDirs");
            Path path = $this$createParentDirs.getParent();
            if (path == null) break block0;
            FileUtilKt.createDir(path);
        }
    }

    public static final void forceDeleteIfExists(@NotNull Path $this$forceDeleteIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$forceDeleteIfExists, (String)"$this$forceDeleteIfExists");
        if (Files.exists($this$forceDeleteIfExists, new LinkOption[0])) {
            if (Files.isDirectory($this$forceDeleteIfExists, new LinkOption[0])) {
                FileUtilKt.forceRemoveDirectory($this$forceDeleteIfExists);
            } else {
                Files.delete($this$forceDeleteIfExists);
            }
        }
    }

    public static final boolean deleteLogged(@NotNull Path $this$deleteLogged) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$deleteLogged, (String)"$this$deleteLogged");
        try {
            FileUtilKt.forceDeleteIfExists($this$deleteLogged);
            bl = true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.info("Cannot delete file because of interruption:  " + $this$deleteLogged);
            bl = false;
        }
        catch (Exception e) {
            LOG.error("Unable to delete " + $this$deleteLogged, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public static final boolean exists(@NotNull Path $this$exists) {
        Intrinsics.checkParameterIsNotNull((Object)$this$exists, (String)"$this$exists");
        return Files.exists($this$exists, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> listFiles(@NotNull Path $this$listFiles) {
        List<Path> list;
        Intrinsics.checkParameterIsNotNull((Object)$this$listFiles, (String)"$this$listFiles");
        if (!FileUtilKt.isDirectory($this$listFiles)) {
            return CollectionsKt.emptyList();
        }
        AutoCloseable autoCloseable = Files.list($this$listFiles);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl2 = false;
            List<Path> list2 = it.collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.collect(Collectors.toList())");
            List<Path> list3 = list2;
            list = list3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Files.list(this).use { i\u2026ct(Collectors.toList()) }");
        return list;
    }

    public static final boolean deleteQuietly(@NotNull Path $this$deleteQuietly) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$deleteQuietly, (String)"$this$deleteQuietly");
        try {
            if (FileUtilKt.isDirectory($this$deleteQuietly)) {
                FileUtilKt.forceRemoveDirectory($this$deleteQuietly);
            } else {
                Files.delete($this$deleteQuietly);
            }
            bl = true;
        }
        catch (Exception ignored) {
            bl = false;
        }
        return bl;
    }

    public static final void forceRemoveDirectory(@NotNull Path $this$forceRemoveDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$forceRemoveDirectory, (String)"$this$forceRemoveDirectory");
        Files.walkFileTree($this$forceRemoveDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir2, @Nullable IOException exc) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)dir2, (String)"dir");
                Files.delete(dir2);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isDirectory, (String)"$this$isDirectory");
        return Files.isDirectory($this$isDirectory, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $this$isFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFile, (String)"$this$isFile");
        return Files.isRegularFile($this$isFile, new LinkOption[0]);
    }

    @NotNull
    public static final String getSimpleName(@NotNull Path $this$simpleName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$simpleName, (String)"$this$simpleName");
        Path path = $this$simpleName.getFileName();
        return (path != null ? (Comparable)path : (Comparable)((Object)"")).toString();
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull Path $this$nameWithoutExtension) {
        Intrinsics.checkParameterIsNotNull((Object)$this$nameWithoutExtension, (String)"$this$nameWithoutExtension");
        return StringsKt.substringBeforeLast$default((String)FileUtilKt.getSimpleName($this$nameWithoutExtension), (String)".", null, (int)2, null);
    }

    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        Intrinsics.checkParameterIsNotNull((Object)$this$extension, (String)"$this$extension");
        return StringsKt.substringAfterLast((String)FileUtilKt.getSimpleName($this$extension), (String)".", (String)"");
    }

    public static final long getLength(@NotNull Path $this$length) {
        Intrinsics.checkParameterIsNotNull((Object)$this$length, (String)"$this$length");
        return Files.size($this$length);
    }
}

