/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.contentBuilder;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ChildrenOwnerSpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.ContentSpec;
import com.jetbrains.plugin.structure.base.utils.contentBuilder.DirectorySpec;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ZipSpec;", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ChildrenOwnerSpec;", "()V", "directorySpec", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/DirectorySpec;", "addChild", "", "name", "", "spec", "Lcom/jetbrains/plugin/structure/base/utils/contentBuilder/ContentSpec;", "generate", "target", "Ljava/io/File;", "structure-base"})
public final class ZipSpec
implements ChildrenOwnerSpec {
    private final DirectorySpec directorySpec = new DirectorySpec();

    @Override
    public void addChild(@NotNull String name, @NotNull ContentSpec spec) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        this.directorySpec.addChild(name, spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@NotNull File target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        boolean bl = Intrinsics.areEqual((Object)FilesKt.getExtension((File)target), (Object)"jar") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)target), (Object)"zip") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)target), (Object)"nupkg");
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Must be a jar or zip archive: " + target;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File zipContentDir = FilesKt.createTempDir$default(null, null, null, (int)7, null);
        try {
            this.directorySpec.generate(zipContentDir);
            ZipUtilKt.archiveDirectoryTo(zipContentDir, target);
        }
        finally {
            FileUtilKt.forceDeleteIfExists(zipContentDir);
        }
    }
}

