/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.decompress;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J*\u0010\u0015\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/ZipCompressor;", "Ljava/io/Closeable;", "outputFile", "Ljava/io/File;", "(Ljava/io/File;)V", "outStream", "Ljava/util/zip/ZipOutputStream;", "addDirectory", "", "directory", "addFile", "entryName", "", "file", "addRecursively", "prefix", "close", "writeDirectoryEntry", "name", "timestamp", "", "writeFileEntry", "source", "Ljava/io/InputStream;", "length", "structure-base"})
public final class ZipCompressor
implements Closeable {
    private final ZipOutputStream outStream;

    public final void addDirectory(@NotNull File directory) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        File[] children = directory.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File child;
                File file = child = fileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"child");
                String name = file.getName();
                if (child.isDirectory()) {
                    String string = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    this.addRecursively(string, child);
                    continue;
                }
                String string = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                this.addFile(string, child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFile(String entryName, File file) {
        Closeable closeable = new FileInputStream(file);
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileInputStream source = (FileInputStream)closeable;
            boolean bl2 = false;
            this.writeFileEntry(entryName, source, file.length(), file.lastModified());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void addRecursively(String prefix, File directory) {
        File[] children;
        CharSequence charSequence = prefix;
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.writeDirectoryEntry(prefix, directory.lastModified());
        }
        if ((children = directory.listFiles()) != null) {
            for (File child : children) {
                String name;
                String string;
                CharSequence charSequence2 = prefix;
                boolean bl2 = false;
                if (charSequence2.length() == 0) {
                    File file = child;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"child");
                    string = file.getName();
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append(prefix).append('/');
                    File file = child;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"child");
                    string = name = stringBuilder.append(file.getName()).toString();
                }
                if (child.isDirectory()) {
                    String string2 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                    this.addRecursively(string2, child);
                    continue;
                }
                String string3 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                this.addFile(string3, child);
            }
        }
    }

    private final void writeDirectoryEntry(String name, long timestamp) {
        ZipEntry e = new ZipEntry(name + '/');
        e.setMethod(0);
        e.setSize(0L);
        e.setCrc(0L);
        e.setTime(timestamp);
        this.outStream.putNextEntry(e);
        this.outStream.closeEntry();
    }

    private final void writeFileEntry(String name, InputStream source, long length, long timestamp) {
        ZipEntry e = new ZipEntry(name);
        if (length == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        e.setTime(timestamp);
        this.outStream.putNextEntry(e);
        ByteStreamsKt.copyTo((InputStream)source, (OutputStream)this.outStream, (int)4096);
        this.outStream.closeEntry();
    }

    @Override
    public void close() {
        this.outStream.close();
    }

    public ZipCompressor(@NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        this.outStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
    }
}

