/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryException;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a-\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00010\b\"\u0004\b\u0000\u0010\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0000\u001a:\u0010\n\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\b0\u000b\"\u0004\b\u0000\u0010\u00012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0000\u00a8\u0006\u0014"}, d2={"executeAndParseBody", "T", "callable", "Lretrofit2/Call;", "nullFor404", "", "(Lretrofit2/Call;Z)Ljava/lang/Object;", "executeExceptionally", "Lretrofit2/Response;", "call", "executeExceptionallyBatch", "", "calls", "", "toMultipartBody", "Lokhttp3/MultipartBody$Part;", "Ljava/io/File;", "toRequestBody", "Lokhttp3/RequestBody;", "", "rest"})
public final class RequestHelperKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T executeAndParseBody(@NotNull Call<T> callable, boolean nullFor404) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
        Response<T> response = RequestHelperKt.executeExceptionally(callable);
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        if (response.code() == 404 && nullFor404) {
            return null;
        }
        Object[] objectArray = new String[4];
        ResponseBody responseBody = response.errorBody();
        objectArray[0] = responseBody != null ? responseBody.string() : null;
        objectArray[1] = response.message();
        objectArray[2] = response.raw().message();
        objectArray[3] = Messages.INSTANCE.getMessage("failed.request.status.code", response.code());
        Iterable $this$filterNot$iv = CollectionsKt.distinct((Iterable)CollectionsKt.listOf((Object[])objectArray));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            boolean bl3 = false;
            if (charSequence == null || charSequence.length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String message = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        throw (Throwable)new PluginRepositoryException(message);
    }

    public static /* synthetic */ Object executeAndParseBody$default(Call call, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return RequestHelperKt.executeAndParseBody(call, bl);
    }

    @NotNull
    public static final <T> Map<Call<T>, Response<T>> executeExceptionallyBatch(@NotNull List<? extends Call<T>> calls) {
        Intrinsics.checkParameterIsNotNull(calls, (String)"calls");
        ConcurrentHashMap responses = new ConcurrentHashMap();
        ConcurrentHashMap errors = new ConcurrentHashMap();
        AtomicInteger finished = new AtomicInteger();
        for (Call<T> call : calls) {
            call.enqueue(new Callback<T>(responses, finished, errors){
                final /* synthetic */ ConcurrentHashMap $responses;
                final /* synthetic */ AtomicInteger $finished;
                final /* synthetic */ ConcurrentHashMap $errors;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull(response, (String)"response");
                    try {
                        ((Map)this.$responses).put(call, response);
                    }
                    finally {
                        this.$finished.incrementAndGet();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(@NotNull Call<T> call, @NotNull Throwable error) {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    try {
                        ((Map)this.$errors).put(call, error);
                    }
                    finally {
                        this.$finished.incrementAndGet();
                    }
                }
                {
                    this.$responses = $captured_local_variable$0;
                    this.$finished = $captured_local_variable$1;
                    this.$errors = $captured_local_variable$2;
                }
            });
        }
        while (finished.get() != calls.size()) {
            if (Thread.interrupted()) {
                for (Call<T> call : calls) {
                    call.cancel();
                }
                throw (Throwable)new InterruptedException();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                for (Call<T> call : calls) {
                    call.cancel();
                }
                throw (Throwable)ie;
            }
        }
        if (Thread.interrupted()) {
            throw (Throwable)new InterruptedException();
        }
        Map ie = errors;
        boolean call = false;
        if (!ie.isEmpty()) {
            Exception exception = new Exception();
            for (Throwable error : errors.values()) {
                exception.addSuppressed(error);
            }
            throw (Throwable)exception;
        }
        return responses;
    }

    @NotNull
    public static final <T> Response<T> executeExceptionally(@NotNull Call<T> call) {
        Intrinsics.checkParameterIsNotNull(call, (String)"call");
        return (Response)CollectionsKt.first((Iterable)RequestHelperKt.executeExceptionallyBatch(CollectionsKt.listOf(call)).values());
    }

    @NotNull
    public static final MultipartBody.Part toMultipartBody(@NotNull File $this$toMultipartBody) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toMultipartBody, (String)"$this$toMultipartBody");
        RequestBody body = RequestBody.Companion.create($this$toMultipartBody, MediaType.Companion.get("application/octet-stream"));
        return MultipartBody.Part.Companion.createFormData("file", $this$toMultipartBody.getName(), body);
    }

    @NotNull
    public static final RequestBody toRequestBody(@NotNull String $this$toRequestBody) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toRequestBody, (String)"$this$toRequestBody");
        return RequestBody.Companion.create($this$toRequestBody, MediaType.Companion.get("text/plain"));
    }
}

