/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.instances;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginDownloader;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryInstanceKt;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.internal.utils.DownloadPluginHelperKt;
import retrofit2.Call;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J,\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00062\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\n\u001a\u00020\u0006H\u0016J,\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/instances/PluginDownloaderInstance;", "Lorg/jetbrains/intellij/pluginRepository/PluginDownloader;", "service", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "(Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;)V", "doDownloadPlugin", "Ljava/io/File;", "callable", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "targetPath", "download", "xmlId", "", "version", "channel", "id", "", "Lorg/jetbrains/intellij/pluginRepository/model/UpdateId;", "downloadLatestCompatiblePlugin", "ideBuild", "rest"})
public final class PluginDownloaderInstance
implements PluginDownloader {
    private final PluginRepositoryService service;

    @Override
    @Nullable
    public File download(@NotNull String xmlId, @NotNull String version, @NotNull File targetPath, @Nullable String channel) {
        Intrinsics.checkParameterIsNotNull((Object)xmlId, (String)"xmlId");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        PluginRepositoryInstanceKt.getLOG().info("Downloading " + xmlId + ':' + version);
        return this.doDownloadPlugin(this.service.download(xmlId, version, channel), targetPath);
    }

    @Override
    @Nullable
    public File download(int id, @NotNull File targetPath) {
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        PluginRepositoryInstanceKt.getLOG().info("Downloading update of plugin for " + id + "...");
        return this.doDownloadPlugin(this.service.download(id), targetPath);
    }

    @Override
    @Nullable
    public File downloadLatestCompatiblePlugin(@NotNull String xmlId, @NotNull String ideBuild, @NotNull File targetPath, @Nullable String channel) {
        Intrinsics.checkParameterIsNotNull((Object)xmlId, (String)"xmlId");
        Intrinsics.checkParameterIsNotNull((Object)ideBuild, (String)"ideBuild");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        PluginRepositoryInstanceKt.getLOG().info("Downloading " + xmlId + " for " + ideBuild + " build");
        return this.doDownloadPlugin(this.service.downloadCompatiblePlugin(xmlId, ideBuild, channel), targetPath);
    }

    private final File doDownloadPlugin(Call<ResponseBody> callable, File targetPath) {
        File file = DownloadPluginHelperKt.downloadPlugin(callable, targetPath);
        PluginRepositoryInstanceKt.getLOG().info("Downloaded successfully to " + targetPath);
        return file;
    }

    public PluginDownloaderInstance(@NotNull PluginRepositoryService service) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        this.service = service;
    }
}

