/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginDownloader;
import org.jetbrains.intellij.pluginRepository.PluginManager;
import org.jetbrains.intellij.pluginRepository.PluginRepository;
import org.jetbrains.intellij.pluginRepository.PluginUpdateManager;
import org.jetbrains.intellij.pluginRepository.PluginUploader;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.internal.instances.PluginDownloaderInstance;
import org.jetbrains.intellij.pluginRepository.internal.instances.PluginManagerInstance;
import org.jetbrains.intellij.pluginRepository.internal.instances.PluginUpdateManagerInstance;
import org.jetbrains.intellij.pluginRepository.internal.instances.PluginUploaderInstance;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.converter.jaxb.JaxbConverterFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001#B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n \u000e*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryInstance;", "Lorg/jetbrains/intellij/pluginRepository/PluginRepository;", "siteUrl", "", "token", "(Ljava/lang/String;Ljava/lang/String;)V", "dispatcher", "Lokhttp3/Dispatcher;", "downloader", "Lorg/jetbrains/intellij/pluginRepository/PluginDownloader;", "getDownloader", "()Lorg/jetbrains/intellij/pluginRepository/PluginDownloader;", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "maxParallelConnection", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "pluginManager", "Lorg/jetbrains/intellij/pluginRepository/PluginManager;", "getPluginManager", "()Lorg/jetbrains/intellij/pluginRepository/PluginManager;", "pluginUpdateManager", "Lorg/jetbrains/intellij/pluginRepository/PluginUpdateManager;", "getPluginUpdateManager", "()Lorg/jetbrains/intellij/pluginRepository/PluginUpdateManager;", "service", "Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryService;", "uploader", "Lorg/jetbrains/intellij/pluginRepository/PluginUploader;", "getUploader", "()Lorg/jetbrains/intellij/pluginRepository/PluginUploader;", "ensureCredentialsAreSet", "", "DaemonThreadFactory", "rest"})
public final class PluginRepositoryInstance
implements PluginRepository {
    private final int maxParallelConnection;
    private final ExecutorService executorService;
    private final Dispatcher dispatcher;
    private final OkHttpClient okHttpClient;
    private final PluginRepositoryService service;
    @NotNull
    private final PluginDownloader downloader;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final PluginUpdateManager pluginUpdateManager;
    private final String token;

    @Override
    @NotNull
    public PluginDownloader getDownloader() {
        return this.downloader;
    }

    @Override
    @NotNull
    public PluginUploader getUploader() {
        this.ensureCredentialsAreSet();
        PluginRepositoryService pluginRepositoryService = this.service;
        Intrinsics.checkNotNullExpressionValue((Object)pluginRepositoryService, (String)"service");
        return new PluginUploaderInstance(pluginRepositoryService);
    }

    @Override
    @NotNull
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    @NotNull
    public PluginUpdateManager getPluginUpdateManager() {
        return this.pluginUpdateManager;
    }

    private final void ensureCredentialsAreSet() {
        if (this.token == null) {
            throw (Throwable)new RuntimeException(Messages.INSTANCE.getMessage("missing.token", new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    public PluginRepositoryInstance(@NotNull String siteUrl, @Nullable String token) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)siteUrl, (String)"siteUrl");
        this.token = token;
        String string = System.getProperty("MARKETPLACE_MAX_PARALLEL_CONNECTIONS", "16");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"MARK\u2026ALLEL_CONNECTIONS\", \"16\")");
        String string2 = string;
        boolean bl = false;
        this.maxParallelConnection = Integer.parseInt(string2);
        ExecutorService executorService = this.executorService = Executors.newFixedThreadPool(this.maxParallelConnection, new DaemonThreadFactory("retrofit-thread"));
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executorService");
        string2 = new Dispatcher(executorService);
        bl = false;
        boolean bl2 = false;
        String string3 = string2;
        PluginRepositoryInstance pluginRepositoryInstance = this;
        boolean bl3 = false;
        $this$apply.setMaxRequestsPerHost(this.maxParallelConnection);
        $this$apply.setMaxRequests(this.maxParallelConnection);
        Unit unit = Unit.INSTANCE;
        pluginRepositoryInstance.dispatcher = string2;
        this.okHttpClient = new OkHttpClient().newBuilder().dispatcher(this.dispatcher).connectTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).addInterceptor(new Interceptor(this){
            final /* synthetic */ PluginRepositoryInstance this$0;

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Request request = PluginRepositoryInstance.access$getToken$p(this.this$0) != null ? chain.request().newBuilder().addHeader("Authorization", "Bearer " + PluginRepositoryInstance.access$getToken$p(this.this$0)).build() : chain.request();
                return chain.proceed(request);
            }
            {
                this.this$0 = this$0;
            }
        }).build();
        this.service = (PluginRepositoryService)new Retrofit.Builder().baseUrl(siteUrl).client(this.okHttpClient).addConverterFactory((Converter.Factory)JaxbConverterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)ExtensionsKt.jacksonObjectMapper())).build().create(PluginRepositoryService.class);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public final void run() {
                block0: {
                    dispatcher.executorService().shutdownNow();
                    okHttpClient.connectionPool().evictAll();
                    Cache cache = okHttpClient.cache();
                    if (cache == null) break block0;
                    cache.close();
                }
            }
        }));
        PluginRepositoryService pluginRepositoryService = this.service;
        Intrinsics.checkNotNullExpressionValue((Object)pluginRepositoryService, (String)"service");
        this.downloader = new PluginDownloaderInstance(pluginRepositoryService);
        PluginRepositoryService pluginRepositoryService2 = this.service;
        Intrinsics.checkNotNullExpressionValue((Object)pluginRepositoryService2, (String)"service");
        this.pluginManager = new PluginManagerInstance(pluginRepositoryService2);
        PluginRepositoryService pluginRepositoryService3 = this.service;
        Intrinsics.checkNotNullExpressionValue((Object)pluginRepositoryService3, (String)"service");
        this.pluginUpdateManager = new PluginUpdateManagerInstance(pluginRepositoryService3);
    }

    public /* synthetic */ PluginRepositoryInstance(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    public static final /* synthetic */ String access$getToken$p(PluginRepositoryInstance $this) {
        return $this.token;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/intellij/pluginRepository/internal/api/PluginRepositoryInstance$DaemonThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "threadNamePrefix", "", "(Ljava/lang/String;)V", "defaultThreadFactory", "kotlin.jvm.PlatformType", "nameCount", "Ljava/util/concurrent/atomic/AtomicLong;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "rest"})
    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultThreadFactory;
        private final AtomicLong nameCount;
        private final String threadNamePrefix;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Thread thread = this.defaultThreadFactory.newThread(r);
            boolean bl = false;
            boolean bl2 = false;
            Thread $this$apply = thread;
            boolean bl3 = false;
            $this$apply.setName(this.threadNamePrefix + '-' + this.nameCount.getAndIncrement());
            $this$apply.setDaemon(true);
            Thread thread2 = thread;
            Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"defaultThreadFactory.new\u2026    isDaemon = true\n    }");
            return thread2;
        }

        public DaemonThreadFactory(@NotNull String threadNamePrefix) {
            Intrinsics.checkNotNullParameter((Object)threadNamePrefix, (String)"threadNamePrefix");
            this.threadNamePrefix = threadNamePrefix;
            this.defaultThreadFactory = Executors.defaultThreadFactory();
            this.nameCount = new AtomicLong();
        }
    }
}

