/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import com.jetbrains.plugin.blockmap.core.ChunkMerger;
import com.jetbrains.plugin.blockmap.core.FileHash;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryException;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.api.BlockMapService;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryInstanceKt;
import org.jetbrains.intellij.pluginRepository.internal.blockmap.PluginChunkDataSource;
import org.jetbrains.intellij.pluginRepository.internal.utils.DownloadPluginHelperKt;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import org.slf4j.Logger;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a \u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u001a(\u0010\u0012\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001a \u0010\u0018\u001a\u0004\u0018\u00010\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010\u0011\u001a\u00020\rH\u0000\u001a(\u0010\u001b\u001a\u0004\u0018\u00010\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0000\u001a\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0016\u0010\u001f\u001a\u00020\u00012\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u001a&\u0010!\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\"\u001a\u00020\u0001H\u0002\u001a\u0018\u0010#\u001a\u00020\u00012\u0006\u0010 \u001a\u00020$2\u0006\u0010\"\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006%"}, d2={"BLOCKMAP_FILENAME", "", "BLOCKMAP_ZIP_SUFFIX", "HASH_FILENAME_SUFFIX", "MAXIMUM_DOWNLOAD_PERCENT", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "downloadFile", "Ljava/io/File;", "executed", "Lretrofit2/Response;", "Lokhttp3/ResponseBody;", "targetPath", "downloadFileViaBlockMap", "oldFile", "downloadPercent", "oldBlockMap", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "newBlockMap", "downloadPlugin", "callable", "Lretrofit2/Call;", "downloadPluginViaBlockMap", "getBlockMapFromZip", "input", "Ljava/io/InputStream;", "getResponseErrorMessage", "response", "getTargetFile", "url", "guessFileName", "Lokhttp3/Response;", "rest"})
public final class DownloadPluginHelperKt {
    private static final Lazy objectMapper$delegate = LazyKt.lazy((Function0)objectMapper.2.INSTANCE);
    @NotNull
    public static final String BLOCKMAP_ZIP_SUFFIX = ".blockmap.zip";
    @NotNull
    public static final String BLOCKMAP_FILENAME = "blockmap.json";
    @NotNull
    public static final String HASH_FILENAME_SUFFIX = ".hash.json";
    private static final double MAXIMUM_DOWNLOAD_PERCENT = 0.65;

    private static final ObjectMapper getObjectMapper() {
        Lazy lazy = objectMapper$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    @Nullable
    public static final File downloadPlugin(@NotNull Call<ResponseBody> callable, @NotNull File targetPath) {
        Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        retrofit2.Response<ResponseBody> response = RequestHelperKt.executeExceptionally(callable);
        if (response.isSuccessful()) {
            File file;
            try {
                file = DownloadPluginHelperKt.downloadFile(response, targetPath);
            }
            catch (Exception e) {
                throw (Throwable)new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", response.code()), e);
            }
            return file;
        }
        if (response.code() == 404) {
            return null;
        }
        throw (Throwable)new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", response.code()) + DownloadPluginHelperKt.getResponseErrorMessage(response));
    }

    @Nullable
    public static final File downloadPluginViaBlockMap(@NotNull Call<ResponseBody> callable, @NotNull File targetPath, @NotNull File oldFile) {
        Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        Intrinsics.checkParameterIsNotNull((Object)oldFile, (String)"oldFile");
        retrofit2.Response<ResponseBody> response = RequestHelperKt.executeExceptionally(callable);
        if (response.isSuccessful()) {
            File file;
            try {
                file = DownloadPluginHelperKt.downloadFileViaBlockMap(response, targetPath, oldFile);
            }
            catch (Exception e) {
                throw (Throwable)new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", response.code()), e);
            }
            return file;
        }
        if (response.code() == 404) {
            return null;
        }
        throw (Throwable)new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", response.code()) + DownloadPluginHelperKt.getResponseErrorMessage(response));
    }

    private static final File downloadFile(retrofit2.Response<ResponseBody> executed, File targetPath) {
        String mimeType;
        String url = executed.raw().request().url().url().toExternalForm();
        ResponseBody responseBody = (ResponseBody)executed.body();
        if (responseBody == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBody, (String)"executed.body() ?: return null");
        ResponseBody response = responseBody;
        MediaType mediaType = response.contentType();
        String string = mimeType = mediaType != null ? mediaType.toString() : null;
        if (Intrinsics.areEqual((Object)mimeType, (Object)"application/zip") ^ true && Intrinsics.areEqual((Object)mimeType, (Object)"application/java-archive") ^ true) {
            return null;
        }
        String string2 = url;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url");
        File targetFile = DownloadPluginHelperKt.getTargetFile(targetPath, executed, string2);
        Files.copy(response.byteStream(), targetFile.toPath(), new CopyOption[0]);
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File downloadFileViaBlockMap(retrofit2.Response<ResponseBody> executed, File targetPath, File oldFile) {
        String url;
        if (!oldFile.exists()) {
            Logger logger = PluginRepositoryInstanceKt.getLOG();
            Object[] objectArray = new Object[1];
            String string = oldFile.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldFile.toString()");
            objectArray[0] = string;
            logger.info(Messages.INSTANCE.getMessage("file.not.found", objectArray));
            return DownloadPluginHelperKt.downloadFile(executed, targetPath);
        }
        String string = url = executed.raw().request().url().url().toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
        String fileName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)StringsKt.replaceAfterLast$default((String)url, (String)"/", (String)"", null, (int)4, null)), (CharSequence)StringsKt.replaceBefore$default((String)url, (String)"?", (String)"", null, (int)4, null));
        String baseUrl = StringsKt.replaceAfterLast$default((String)url, (String)"/", (String)"", null, (int)4, null);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        BlockMapService service = (BlockMapService)retrofit.create(BlockMapService.class);
        String blockMapFileName = fileName + BLOCKMAP_ZIP_SUFFIX;
        String hashFileName = fileName + HASH_FILENAME_SUFFIX;
        try {
            FileHash fileHash;
            Object object;
            boolean $i$a$-use-DownloadPluginHelperKt$downloadFileViaBlockMap$oldBlockMap$22;
            Object[] input2;
            ResponseBody responseBody = (ResponseBody)RequestHelperKt.executeExceptionally(service.getBlockMapZip(blockMapFileName)).body();
            if (responseBody == null) {
                throw (Throwable)new IOException(Messages.INSTANCE.getMessage("block.map.file.doesnt.exist", new Object[0]));
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)responseBody, (String)"executeExceptionally(ser\u2026.map.file.doesnt.exist\"))");
            ResponseBody blockMapZip = responseBody;
            BlockMap newBlockMap = DownloadPluginHelperKt.getBlockMapFromZip(blockMapZip.byteStream());
            FileHash fileHash2 = (FileHash)RequestHelperKt.executeExceptionally(service.getHash(hashFileName)).body();
            if (fileHash2 == null) {
                throw (Throwable)new IOException(Messages.INSTANCE.getMessage("hash.file.does.not.exist", new Object[0]));
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)fileHash2, (String)"executeExceptionally(ser\u2026sh.file.does.not.exist\"))");
            FileHash newPluginHash = fileHash2;
            Closeable closeable = new FileInputStream(oldFile);
            boolean bl = false;
            Object object2 = null;
            try {
                input2 = (Object[])closeable;
                $i$a$-use-DownloadPluginHelperKt$downloadFileViaBlockMap$oldBlockMap$22 = false;
                input2 = new BlockMap((InputStream)input2, newBlockMap.getAlgorithm(), newBlockMap.getMinSize(), newBlockMap.getMaxSize(), newBlockMap.getNormalSize());
            }
            catch (Throwable input2) {
                object2 = input2;
                throw input2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            Object[] oldBlockMap = input2;
            double downloadPercent = DownloadPluginHelperKt.downloadPercent((BlockMap)oldBlockMap, newBlockMap);
            object2 = "Plugin's download percent is = %.2f";
            input2 = new Object[]{downloadPercent * (double)100};
            Logger logger = PluginRepositoryInstanceKt.getLOG();
            $i$a$-use-DownloadPluginHelperKt$downloadFileViaBlockMap$oldBlockMap$22 = false;
            String string2 = String.format((String)object2, Arrays.copyOf(input2, input2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            String string3 = string2;
            logger.info(string3);
            if (downloadPercent > 0.65) {
                throw (Throwable)new IOException(Messages.INSTANCE.getMessage("too.large.download.size", new Object[0]));
            }
            ChunkMerger merger = new ChunkMerger(oldFile, (BlockMap)oldBlockMap, newBlockMap, 0, 8, null);
            File targetFile = DownloadPluginHelperKt.getTargetFile(targetPath, executed, url);
            Closeable $i$a$-use-DownloadPluginHelperKt$downloadFileViaBlockMap$oldBlockMap$22 = new FileOutputStream(targetFile);
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream output = (FileOutputStream)$i$a$-use-DownloadPluginHelperKt$downloadFileViaBlockMap$oldBlockMap$22;
                boolean bl3 = false;
                OutputStream outputStream = output;
                BlockMapService blockMapService = service;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockMapService, (String)"service");
                merger.merge(outputStream, (Iterator)new PluginChunkDataSource((BlockMap)oldBlockMap, newBlockMap, blockMapService, fileName));
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$a$-use-DownloadPluginHelperKt$downloadFileViaBlockMap$oldBlockMap$22, (Throwable)throwable);
            }
            Closeable closeable2 = new FileInputStream(targetFile);
            boolean bl4 = false;
            object = null;
            try {
                FileInputStream input3 = (FileInputStream)closeable2;
                boolean bl5 = false;
                fileHash = new FileHash((InputStream)input3, newPluginHash.getAlgorithm());
            }
            catch (Throwable throwable3) {
                object = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            FileHash curFileHash = fileHash;
            if (Intrinsics.areEqual((Object)curFileHash, (Object)newPluginHash) ^ true) {
                throw (Throwable)new IOException(Messages.INSTANCE.getMessage("hashes.doesnt.match", new Object[0]));
            }
            return targetFile;
        }
        catch (Exception e) {
            PluginRepositoryInstanceKt.getLOG().info("Unable to download plugin via blockmap: " + e.getMessage());
            return DownloadPluginHelperKt.downloadPlugin(service.getPluginFile(fileName, ""), targetPath);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final double downloadPercent(BlockMap oldBlockMap, BlockMap newBlockMap) {
        int n;
        Chunk chunk;
        void $this$filterTo$iv$iv;
        Set oldSet = CollectionsKt.toSet((Iterable)oldBlockMap.getChunks());
        Iterable $this$filter$iv = newBlockMap.getChunks();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Chunk chunk2 = (Chunk)element$iv$iv;
            boolean bl = false;
            if (!(!oldSet.contains(chunk2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newChunks = (List)destination$iv$iv;
        Iterable $this$sumBy$iv = newChunks;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            Chunk chunk3 = (Chunk)element$iv;
            int n2 = sum$iv;
            boolean bl = false;
            int n3 = chunk.getLength();
            sum$iv = n2 + n3;
        }
        $this$sumBy$iv = newBlockMap.getChunks();
        double d = sum$iv;
        $i$f$sumBy = false;
        sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            chunk = (Chunk)element$iv;
            n = sum$iv;
            boolean bl = false;
            int n4 = chunk.getLength();
            sum$iv = n + n4;
        }
        n = sum$iv;
        return d / (double)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BlockMap getBlockMapFromZip(InputStream input) {
        BlockMap blockMap;
        Closeable closeable = input;
        int n = 8192;
        boolean bl = false;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        n = 0;
        Throwable throwable = null;
        try {
            BlockMap blockMap2;
            BufferedInputStream source = (BufferedInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new ZipInputStream(source);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                ZipInputStream zip = (ZipInputStream)closeable2;
                boolean bl4 = false;
                ZipEntry entry = zip.getNextEntry();
                while (true) {
                    ZipEntry zipEntry = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                    if (!(Intrinsics.areEqual((Object)zipEntry.getName(), (Object)BLOCKMAP_FILENAME) ^ true) || entry.getName() == null) break;
                    entry = zip.getNextEntry();
                }
                if (!Intrinsics.areEqual((Object)entry.getName(), (Object)BLOCKMAP_FILENAME)) {
                    throw (Throwable)new IOException(Messages.INSTANCE.getMessage("block.map.file.doesnt.exist", new Object[0]));
                }
                Object object = DownloadPluginHelperKt.getObjectMapper().readValue(ByteStreamsKt.readBytes((InputStream)zip), BlockMap.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(z\u2026(), BlockMap::class.java)");
                blockMap2 = (BlockMap)object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            blockMap = blockMap2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return blockMap;
    }

    private static final File getTargetFile(File targetPath, retrofit2.Response<ResponseBody> executed, String url) {
        File targetFile = targetPath;
        if (targetFile.isDirectory()) {
            Response response = executed.raw();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"executed.raw()");
            String guessFileName = DownloadPluginHelperKt.guessFileName(response, url);
            if (StringsKt.contains$default((CharSequence)guessFileName, (char)File.separatorChar, (boolean)false, (int)2, null)) {
                throw (Throwable)new IOException(Messages.INSTANCE.getMessage("invalid.filename", new Object[0]));
            }
            File file = new File(targetFile, guessFileName);
            if (Intrinsics.areEqual((Object)file.getParentFile(), (Object)targetFile) ^ true) {
                throw (Throwable)new IOException(Messages.INSTANCE.getMessage("invalid.filename", new Object[0]));
            }
            targetFile = file;
        }
        return targetFile;
    }

    private static final String getResponseErrorMessage(retrofit2.Response<ResponseBody> response) {
        Object object;
        Object object2 = response.errorBody();
        if (object2 == null || (object2 = object2.string()) == null) {
            object2 = object = response.message();
        }
        if (object2 == null) {
            object = "";
        }
        Object object3 = object;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object3;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)it;
        boolean bl4 = false;
        return charSequence.length() > 0 ? ": " + (String)it : "";
    }

    private static final String guessFileName(Response response, String url) {
        String contentDispositionHeader;
        String string;
        String contentDisposition;
        Object v0;
        boolean bl;
        String filenameMarker;
        block4: {
            filenameMarker = "filename=";
            Iterable iterable = response.headers().names();
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            bl = false;
            for (Object t : iterable2) {
                String it = (String)t;
                boolean bl3 = false;
                if (!StringsKt.equals((String)it, (String)"Content-Disposition", (boolean)true)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        String string2 = contentDisposition = (String)v0;
        if (string2 != null) {
            String string3 = string2;
            boolean bl4 = false;
            bl = false;
            String it = string3;
            boolean bl5 = false;
            string = response.headers().get(contentDisposition);
        } else {
            string = contentDispositionHeader = null;
        }
        if (contentDispositionHeader == null || !StringsKt.contains$default((CharSequence)contentDispositionHeader, (CharSequence)filenameMarker, (boolean)false, (int)2, null)) {
            String fileName = StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null);
            CharSequence charSequence = fileName;
            bl = false;
            return charSequence.length() > 0 ? fileName : url;
        }
        return StringsKt.removeSurrounding((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)contentDispositionHeader, (String)filenameMarker, (String)""), (char)';', null, (int)2, null), (CharSequence)"\"");
    }
}

