/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginBean;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryInstance;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryRestKt;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.RestCategoryBean;
import org.jetbrains.intellij.pluginRepository.RestPluginBean;
import org.jetbrains.intellij.pluginRepository.RestPluginRepositoryBean;
import org.jetbrains.intellij.pluginRepository.exceptions.UploadFailedException;
import org.slf4j.Logger;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Response;
import retrofit.converter.Converter;
import retrofit.converter.SimpleXMLConverter;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedString;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bB-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J,\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0003J,\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0003H\u0002J(\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001d\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010%\u001a\u0004\u0018\u00010\u0003J \u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0002J\"\u0010+\u001a\u00020!2\u0006\u0010%\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00172\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0003J\"\u0010+\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00172\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0003J9\u0010.\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00172\n\b\u0002\u0010%\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010/R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/intellij/pluginRepository/PluginRepositoryInstance;", "", "siteUrl", "", "username", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "token", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lretrofit/mime/TypedString;", "service", "Lorg/jetbrains/intellij/pluginRepository/PluginRepositoryService;", "kotlin.jvm.PlatformType", "convertCategory", "", "Lorg/jetbrains/intellij/pluginRepository/PluginBean;", "response", "Lorg/jetbrains/intellij/pluginRepository/RestCategoryBean;", "convertPlugin", "Lorg/jetbrains/intellij/pluginRepository/RestPluginBean;", "category", "download", "Ljava/io/File;", "pluginXmlId", "version", "channel", "targetPath", "downloadCompatiblePlugin", "ideBuild", "downloadFile", "Lretrofit/client/Response;", "ensureCredentialsAreSet", "", "guessFileName", "url", "listPlugins", "pluginId", "processRetofitError", "e", "Lretrofit/RetrofitError;", "notFoundErrorMessage", "baseErrorMessage", "uploadPlugin", "", "file", "uploadPluginInternal", "(Ljava/io/File;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)V", "rest"})
public final class PluginRepositoryInstance {
    private final TypedString username;
    private final TypedString password;
    private final PluginRepositoryService service;
    private final String siteUrl;
    private final String token;

    public final void uploadPlugin(int pluginId, @NotNull File file, @Nullable String channel) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PluginRepositoryInstance.uploadPluginInternal$default(this, file, pluginId, null, channel, 4, null);
    }

    public static /* bridge */ /* synthetic */ void uploadPlugin$default(PluginRepositoryInstance pluginRepositoryInstance, int n, File file, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        pluginRepositoryInstance.uploadPlugin(n, file, string);
    }

    public final void uploadPlugin(@NotNull String pluginXmlId, @NotNull File file, @Nullable String channel) {
        Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PluginRepositoryInstance.uploadPluginInternal$default(this, file, null, pluginXmlId, channel, 2, null);
    }

    public static /* bridge */ /* synthetic */ void uploadPlugin$default(PluginRepositoryInstance pluginRepositoryInstance, String string, File file, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        pluginRepositoryInstance.uploadPlugin(string, file, string2);
    }

    private final void uploadPluginInternal(File file, Integer pluginId, String pluginXmlId, String channel) {
        this.ensureCredentialsAreSet();
        try {
            Response response;
            TypedString typedString;
            String it;
            PluginRepositoryService pluginRepositoryService;
            TypedString typedString2;
            TypedString typedString3;
            TypedString typedString4;
            String string;
            Logger logger = PluginRepositoryRestKt.access$getLOG$p();
            StringBuilder stringBuilder = new StringBuilder().append("Uploading plugin ");
            Object object = pluginXmlId;
            if (object == null) {
                object = pluginId;
            }
            logger.info(stringBuilder.append(object).append(" from ").append(file.getAbsolutePath()).append(" to ").append(this.siteUrl).toString());
            if (pluginXmlId != null) {
                TypedString typedString5;
                PluginRepositoryService pluginRepositoryService2 = this.service;
                TypedString typedString6 = this.username;
                TypedString typedString7 = this.password;
                TypedString typedString8 = new TypedString(pluginXmlId);
                String string2 = channel;
                if (string2 != null) {
                    string = string2;
                    typedString4 = typedString8;
                    typedString3 = typedString7;
                    typedString2 = typedString6;
                    pluginRepositoryService = pluginRepositoryService2;
                    it = string;
                    typedString = new TypedString(it);
                    pluginRepositoryService2 = pluginRepositoryService;
                    typedString6 = typedString2;
                    typedString7 = typedString3;
                    typedString8 = typedString4;
                    typedString5 = typedString;
                } else {
                    typedString5 = null;
                }
                response = pluginRepositoryService2.uploadByXmlId(typedString6, typedString7, typedString8, typedString5, new TypedFile("application/octet-stream", file));
            } else {
                TypedString typedString9;
                PluginRepositoryService pluginRepositoryService3 = this.service;
                TypedString typedString10 = this.username;
                TypedString typedString11 = this.password;
                TypedString typedString12 = new TypedString(String.valueOf(pluginId));
                String string3 = channel;
                if (string3 != null) {
                    string = string3;
                    typedString4 = typedString12;
                    typedString3 = typedString11;
                    typedString2 = typedString10;
                    pluginRepositoryService = pluginRepositoryService3;
                    it = string;
                    typedString = new TypedString(it);
                    pluginRepositoryService3 = pluginRepositoryService;
                    typedString10 = typedString2;
                    typedString11 = typedString3;
                    typedString12 = typedString4;
                    typedString9 = typedString;
                } else {
                    typedString9 = null;
                }
                response = pluginRepositoryService3.upload(typedString10, typedString11, typedString12, typedString9, new TypedFile("application/octet-stream", file));
            }
            Response response2 = response;
            PluginRepositoryRestKt.access$getLOG$p().info("Done: " + PluginRepositoryRestKt.getText(response2));
        }
        catch (RetrofitError e) {
            String notFoundErrorMessage = "Cannot find " + pluginXmlId + ". " + "Note that you need to upload the plugin to the repository at least once manually " + "(to specify options like the license, repository URL etc.) before uploads through the client can be used.";
            String errorMessage = this.processRetofitError(e, notFoundErrorMessage, "Failed to upload plugin");
            throw (Throwable)new UploadFailedException(errorMessage, e);
        }
    }

    static /* bridge */ /* synthetic */ void uploadPluginInternal$default(PluginRepositoryInstance pluginRepositoryInstance, File file, Integer n, String string, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        pluginRepositoryInstance.uploadPluginInternal(file, n, string, string2);
    }

    private final void ensureCredentialsAreSet() {
        if (this.token != null) {
            return;
        }
        if (this.username == null) {
            throw (Throwable)new RuntimeException("Username must be set for uploading");
        }
        if (this.password == null) {
            throw (Throwable)new RuntimeException("Password must be set for uploading");
        }
    }

    @Nullable
    public final File download(@NotNull String pluginXmlId, @NotNull String version, @Nullable String channel, @NotNull String targetPath) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        PluginRepositoryRestKt.access$getLOG$p().info("Downloading " + pluginXmlId + ':' + version);
        try {
            file = this.downloadFile(this.service.download(pluginXmlId, version, channel), targetPath);
        }
        catch (RetrofitError e) {
            this.processRetofitError(e, "Cannot find " + pluginXmlId + ':' + version, "Can't download plugin");
            file = null;
        }
        return file;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ File download$default(PluginRepositoryInstance pluginRepositoryInstance, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return pluginRepositoryInstance.download(string, string2, string3, string4);
    }

    @Nullable
    public final File downloadCompatiblePlugin(@NotNull String pluginXmlId, @NotNull String ideBuild, @Nullable String channel, @NotNull String targetPath) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
        Intrinsics.checkParameterIsNotNull((Object)ideBuild, (String)"ideBuild");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        PluginRepositoryRestKt.access$getLOG$p().info("Downloading " + pluginXmlId + " for " + ideBuild + " build");
        try {
            file = this.downloadFile(this.service.downloadCompatiblePlugin(pluginXmlId, ideBuild, channel), targetPath);
        }
        catch (RetrofitError e) {
            this.processRetofitError(e, "Cannot find " + pluginXmlId + " compatible with " + ideBuild + " build", "Can't download plugin");
            file = null;
        }
        return file;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ File downloadCompatiblePlugin$default(PluginRepositoryInstance pluginRepositoryInstance, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return pluginRepositoryInstance.downloadCompatiblePlugin(string, string2, string3, string4);
    }

    private final String processRetofitError(RetrofitError e, String notFoundErrorMessage, String baseErrorMessage) {
        if (Intrinsics.areEqual((Object)e.getKind(), (Object)RetrofitError.Kind.UNEXPECTED)) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            throw throwable;
        }
        Response response = e.getResponse();
        String errorMessage = response != null ? (response.getStatus() == 404 ? notFoundErrorMessage : "" + baseErrorMessage + ". Response from server: " + response.getStatus()) : "" + baseErrorMessage + ": " + e.getMessage();
        PluginRepositoryRestKt.access$getLOG$p().error(errorMessage, (Throwable)e);
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File downloadFile(Response response, String targetPath) {
        String mimeType = response.getBody().mimeType();
        if (Intrinsics.areEqual((Object)mimeType, (Object)"application/zip") ^ true && Intrinsics.areEqual((Object)mimeType, (Object)"application/java-archive") ^ true) {
            return null;
        }
        File targetFile = new File(targetPath);
        if (targetFile.isDirectory()) {
            String string = response.getUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.url");
            String guessFileName = this.guessFileName(response, string);
            if (StringsKt.contains$default((CharSequence)guessFileName, (char)File.separatorChar, (boolean)false, (int)2, null)) {
                throw (Throwable)new IOException("Invalid filename returned by a server");
            }
            File file = new File(targetFile, guessFileName);
            if (Intrinsics.areEqual((Object)file.getParentFile(), (Object)targetFile) ^ true) {
                throw (Throwable)new IOException("Invalid filename returned by a server");
            }
            targetFile = file;
        }
        if (!targetFile.createNewFile()) {
            throw (Throwable)new RuntimeException("Cannot create " + targetFile.getAbsolutePath());
        }
        Object object = targetFile;
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)object;
            InputStream inputStream = response.getBody().in();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"response.body.`in`()");
            long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        PluginRepositoryRestKt.access$getLOG$p().info("Downloaded successfully to " + targetFile.getAbsolutePath());
        return targetFile;
    }

    private final String guessFileName(Response response, String url) {
        Header contentDispositionHeader;
        String filenameMarker;
        block5: {
            String fileName;
            Object object;
            block4: {
                Object v2;
                block3: {
                    filenameMarker = "filename=";
                    List list = response.getHeaders();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"response.headers");
                    Iterable iterable = list;
                    object = iterable;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Header it;
                        Object t = iterator.next();
                        Header header = it = (Header)t;
                        Intrinsics.checkExpressionValueIsNotNull((Object)header, (String)"it");
                        if (!StringsKt.equals((String)header.getName(), (String)"Content-Disposition", (boolean)true)) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                contentDispositionHeader = v2;
                if (contentDispositionHeader == null) break block4;
                String string = contentDispositionHeader.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contentDispositionHeader.value");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)filenameMarker, (boolean)false, (int)2, null)) break block5;
            }
            return (object = (CharSequence)(fileName = StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null))).length() > 0 ? fileName : url;
        }
        String string = contentDispositionHeader.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contentDispositionHeader.value");
        return StringsKt.removeSurrounding((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)string, (String)filenameMarker, (String)""), (char)';', null, (int)2, null), (CharSequence)"\"");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginBean> listPlugins(@NotNull String ideBuild, @Nullable String channel, @Nullable String pluginId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ideBuild, (String)"ideBuild");
        RestPluginRepositoryBean response = this.service.listPlugins(ideBuild, channel, pluginId);
        List<RestCategoryBean> list2 = response.getCategories();
        if (list2 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                RestCategoryBean it = (RestCategoryBean)element$iv$iv;
                Iterable list$iv$iv = this.convertCategory(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginBean> convertCategory(RestCategoryBean response) {
        List list;
        List<RestPluginBean> list2 = response.getPlugins();
        if (list2 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                RestPluginBean restPluginBean = (RestPluginBean)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = response.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                PluginBean pluginBean = this.convertPlugin((RestPluginBean)it, string);
                collection.add(pluginBean);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final PluginBean convertPlugin(RestPluginBean response, String category) {
        String string = response.getName();
        String string2 = response.getId();
        String string3 = response.getVersion();
        String string4 = response.getIdeaVersion().getSinceBuild();
        String string5 = response.getIdeaVersion().getUntilBuild();
        List list = response.getDepends();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return new PluginBean(string, string2, string3, category, string4, string5, list);
    }

    private PluginRepositoryInstance(String siteUrl, String token, String username, String password) {
        this.siteUrl = siteUrl;
        this.token = token;
        this.username = username != null ? new TypedString(username) : null;
        this.password = password != null ? new TypedString(password) : null;
        this.service = (PluginRepositoryService)new RestAdapter.Builder().setEndpoint(this.siteUrl).setClient((Client.Provider)service.1.INSTANCE).setRequestInterceptor(new RequestInterceptor(this){
            final /* synthetic */ PluginRepositoryInstance this$0;

            public final void intercept(RequestInterceptor.RequestFacade request) {
                if (PluginRepositoryInstance.access$getToken$p(this.this$0) != null) {
                    request.addHeader("Authorization", "Bearer " + PluginRepositoryInstance.access$getToken$p(this.this$0));
                }
            }
            {
                this.this$0 = pluginRepositoryInstance;
            }
        }).setLog((RestAdapter.Log)service.3.INSTANCE).setLogLevel(RestAdapter.LogLevel.BASIC).setConverter((Converter)new SimpleXMLConverter()).build().create(PluginRepositoryService.class);
    }

    @Deprecated(message="Use hub permanent tokens to authorize your requests")
    public PluginRepositoryInstance(@NotNull String siteUrl, @Nullable String username, @Nullable String password) {
        Intrinsics.checkParameterIsNotNull((Object)siteUrl, (String)"siteUrl");
        this(siteUrl, null, username, password);
    }

    public PluginRepositoryInstance(@NotNull String siteUrl, @Nullable String token) {
        Intrinsics.checkParameterIsNotNull((Object)siteUrl, (String)"siteUrl");
        this(siteUrl, token, null, null);
    }

    public /* synthetic */ PluginRepositoryInstance(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Nullable
    public static final /* synthetic */ String access$getToken$p(PluginRepositoryInstance $this) {
        return $this.token;
    }
}

