/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginBean;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryInstance;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryRestKt;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.RestCategoryBean;
import org.jetbrains.intellij.pluginRepository.RestPluginBean;
import org.jetbrains.intellij.pluginRepository.RestPluginRepositoryBean;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.client.UrlConnectionClient;
import retrofit.converter.Converter;
import retrofit.converter.SimpleXMLConverter;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedString;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J,\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0003J,\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0002J(\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001b\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010&\u001a\u0004\u0018\u00010\u0003J\"\u0010'\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00152\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\"\u0010'\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00152\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/intellij/pluginRepository/PluginRepositoryInstance;", "", "siteUrl", "", "username", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "service", "Lorg/jetbrains/intellij/pluginRepository/PluginRepositoryService;", "kotlin.jvm.PlatformType", "getSiteUrl", "()Ljava/lang/String;", "convertCategory", "", "Lorg/jetbrains/intellij/pluginRepository/PluginBean;", "response", "Lorg/jetbrains/intellij/pluginRepository/RestCategoryBean;", "convertPlugin", "Lorg/jetbrains/intellij/pluginRepository/RestPluginBean;", "category", "download", "Ljava/io/File;", "pluginXmlId", "version", "channel", "targetPath", "downloadCompatiblePlugin", "ideBuild", "downloadFile", "Lretrofit/client/Response;", "ensureCredentialsAreSet", "", "guessFileName", "url", "handleUploadResponse", "e", "Lretrofit/RetrofitError;", "listPlugins", "pluginId", "uploadPlugin", "", "file", "rest_main"})
public final class PluginRepositoryInstance {
    private final PluginRepositoryService service;
    @NotNull
    private final String siteUrl;
    private final String username;
    private final String password;

    public final void uploadPlugin(int pluginId, @NotNull File file, @Nullable String channel) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.ensureCredentialsAreSet();
        try {
            TypedString typedString;
            PluginRepositoryRestKt.access$getLOG$p().info("Uploading plugin " + pluginId + " from " + file.getAbsolutePath() + " to " + this.siteUrl);
            PluginRepositoryService pluginRepositoryService = this.service;
            TypedString typedString2 = new TypedString(this.username);
            TypedString typedString3 = new TypedString(this.password);
            TypedString typedString4 = new TypedString(String.valueOf(pluginId));
            String string = channel;
            if (string != null) {
                String string2 = string;
                TypedString typedString5 = typedString4;
                TypedString typedString6 = typedString3;
                TypedString typedString7 = typedString2;
                PluginRepositoryService pluginRepositoryService2 = pluginRepositoryService;
                String it = string2;
                TypedString typedString8 = new TypedString(it);
                pluginRepositoryService = pluginRepositoryService2;
                typedString2 = typedString7;
                typedString3 = typedString6;
                typedString4 = typedString5;
                typedString = typedString8;
            } else {
                typedString = null;
            }
            pluginRepositoryService.upload(typedString2, typedString3, typedString4, typedString, new TypedFile("application/octet-stream", file));
        }
        catch (RetrofitError e) {
            this.handleUploadResponse(e);
        }
    }

    public static /* bridge */ /* synthetic */ void uploadPlugin$default(PluginRepositoryInstance pluginRepositoryInstance, int n, File file, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        pluginRepositoryInstance.uploadPlugin(n, file, string);
    }

    public final void uploadPlugin(@NotNull String pluginXmlId, @NotNull File file, @Nullable String channel) {
        Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.ensureCredentialsAreSet();
        try {
            TypedString typedString;
            PluginRepositoryRestKt.access$getLOG$p().info("Uploading plugin " + pluginXmlId + " from " + file.getAbsolutePath() + " to " + this.siteUrl);
            PluginRepositoryService pluginRepositoryService = this.service;
            TypedString typedString2 = new TypedString(this.username);
            TypedString typedString3 = new TypedString(this.password);
            TypedString typedString4 = new TypedString(pluginXmlId);
            String string = channel;
            if (string != null) {
                String string2 = string;
                TypedString typedString5 = typedString4;
                TypedString typedString6 = typedString3;
                TypedString typedString7 = typedString2;
                PluginRepositoryService pluginRepositoryService2 = pluginRepositoryService;
                String it = string2;
                TypedString typedString8 = new TypedString(it);
                pluginRepositoryService = pluginRepositoryService2;
                typedString2 = typedString7;
                typedString3 = typedString6;
                typedString4 = typedString5;
                typedString = typedString8;
            } else {
                typedString = null;
            }
            pluginRepositoryService.uploadByXmlId(typedString2, typedString3, typedString4, typedString, new TypedFile("application/octet-stream", file));
        }
        catch (RetrofitError e) {
            this.handleUploadResponse(e);
        }
    }

    public static /* bridge */ /* synthetic */ void uploadPlugin$default(PluginRepositoryInstance pluginRepositoryInstance, String string, File file, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        pluginRepositoryInstance.uploadPlugin(string, file, string2);
    }

    private final void handleUploadResponse(RetrofitError e) {
        Response response = e.getResponse();
        if (Intrinsics.areEqual((Object)(response != null ? Integer.valueOf(response.getStatus()) : null), (Object)302)) {
            PluginRepositoryRestKt.access$getLOG$p().info("Uploaded successfully");
            return;
        }
        throw (Throwable)e;
    }

    private final void ensureCredentialsAreSet() {
        if (this.username == null) {
            throw (Throwable)new RuntimeException("Username must be set for uploading");
        }
        if (this.password == null) {
            throw (Throwable)new RuntimeException("Password must be set for uploading");
        }
    }

    @Nullable
    public final File download(@NotNull String pluginXmlId, @NotNull String version, @Nullable String channel, @NotNull String targetPath) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
            PluginRepositoryRestKt.access$getLOG$p().info("Downloading " + pluginXmlId + ":" + version);
            try {
                this.service.download(pluginXmlId, version, channel);
            }
            catch (RetrofitError e) {
                Response response = e.getResponse();
                if (!Intrinsics.areEqual((Object)(response != null ? Integer.valueOf(response.getStatus()) : null), (Object)302)) break block2;
                Response response2 = e.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"e.response");
                File file = this.downloadFile(response2, targetPath);
                if (file == null) break block2;
                return file;
            }
        }
        PluginRepositoryRestKt.access$getLOG$p().error("Cannot find " + pluginXmlId + ":" + version);
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ File download$default(PluginRepositoryInstance pluginRepositoryInstance, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return pluginRepositoryInstance.download(string, string2, string3, string4);
    }

    @Nullable
    public final File downloadCompatiblePlugin(@NotNull String pluginXmlId, @NotNull String ideBuild, @Nullable String channel, @NotNull String targetPath) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
            Intrinsics.checkParameterIsNotNull((Object)ideBuild, (String)"ideBuild");
            Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
            PluginRepositoryRestKt.access$getLOG$p().info("Downloading " + pluginXmlId + " for " + ideBuild + " build");
            try {
                this.service.downloadCompatiblePlugin(pluginXmlId, ideBuild, channel);
            }
            catch (RetrofitError e) {
                Response response = e.getResponse();
                if (!Intrinsics.areEqual((Object)(response != null ? Integer.valueOf(response.getStatus()) : null), (Object)302)) break block2;
                Response response2 = e.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"e.response");
                File file = this.downloadFile(response2, targetPath);
                if (file == null) break block2;
                return file;
            }
        }
        PluginRepositoryRestKt.access$getLOG$p().error("Cannot find " + pluginXmlId + " compatible with " + ideBuild + " build");
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ File downloadCompatiblePlugin$default(PluginRepositoryInstance pluginRepositoryInstance, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return pluginRepositoryInstance.downloadCompatiblePlugin(string, string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File downloadFile(Response response, String targetPath) {
        for (Header header : response.getHeaders()) {
            String mimeType;
            Request request;
            String fileLocation;
            CharSequence charSequence;
            if (!StringsKt.equals((String)header.getName(), (String)"location", (boolean)true) || (charSequence = (CharSequence)(fileLocation = header.getValue())) == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            String string = fileLocation;
            String string2 = "GET";
            Request request2 = request;
            Request request3 = request;
            UrlConnectionClient urlConnectionClient = new UrlConnectionClient();
            List list = CollectionsKt.emptyList();
            request2(string2, string, list, null);
            Response downloadResponse = urlConnectionClient.execute(request3);
            if (downloadResponse.getStatus() != 200 || !Intrinsics.areEqual((Object)(mimeType = downloadResponse.getBody().mimeType()), (Object)"application/zip") && !Intrinsics.areEqual((Object)mimeType, (Object)"application/java-archive")) continue;
            File targetFile = new File(targetPath);
            if (targetFile.isDirectory()) {
                Response response2 = downloadResponse;
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"downloadResponse");
                String string3 = fileLocation;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fileLocation");
                String guessFileName = this.guessFileName(response2, string3);
                if (StringsKt.contains$default((CharSequence)guessFileName, (char)File.separatorChar, (boolean)false, (int)2, null)) {
                    throw (Throwable)new IOException("Invalid filename returned by a server");
                }
                File file = new File(targetFile, guessFileName);
                if (Intrinsics.areEqual((Object)file.getParentFile(), (Object)targetFile) ^ true) {
                    throw (Throwable)new IOException("Invalid filename returned by a server");
                }
                targetFile = file;
            }
            if (!targetFile.createNewFile()) {
                throw (Throwable)new RuntimeException("Cannot create " + targetFile.getAbsolutePath());
            }
            Object object = targetFile;
            object = new FileOutputStream((File)object);
            boolean bl = false;
            try {
                FileOutputStream it = (FileOutputStream)object;
                long l = ByteStreamsKt.copyTo$default((InputStream)downloadResponse.getBody().in(), (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Exception exception) {
                bl = true;
                try {
                    object.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    object.close();
                }
            }
            PluginRepositoryRestKt.access$getLOG$p().info("Downloaded successfully to " + targetFile.getAbsolutePath());
            return targetFile;
        }
        return null;
    }

    private final String guessFileName(Response response, String url) {
        String fileName;
        Object object = response.getHeaders().iterator();
        while (object.hasNext()) {
            Header header = (Header)object.next();
            String filenameMarker = "filename=";
            if (!StringsKt.equals((String)header.getName(), (String)"Content-Disposition", (boolean)true)) continue;
            if (!StringsKt.contains$default((CharSequence)header.getValue(), (CharSequence)filenameMarker, (boolean)false, (int)2, null)) break;
            return StringsKt.removeSurrounding((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)header.getValue(), (String)filenameMarker, (String)""), (char)';', null, (int)2, null), (CharSequence)"\"");
        }
        return (object = (CharSequence)(fileName = StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null))).length() > 0 ? fileName : url;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginBean> listPlugins(@NotNull String ideBuild, @Nullable String channel, @Nullable String pluginId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ideBuild, (String)"ideBuild");
        RestPluginRepositoryBean response = this.service.listPlugins(ideBuild, channel, pluginId);
        List<RestCategoryBean> list2 = response.getCategories();
        if (list2 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                RestCategoryBean it = (RestCategoryBean)element$iv$iv;
                Iterable list$iv$iv = this.convertCategory(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginBean> convertCategory(RestCategoryBean response) {
        List list;
        List<RestPluginBean> list2 = response.getPlugins();
        if (list2 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                RestPluginBean restPluginBean = (RestPluginBean)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = response.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                PluginBean pluginBean = this.convertPlugin((RestPluginBean)it, string);
                collection.add(pluginBean);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final PluginBean convertPlugin(RestPluginBean response, String category) {
        String string = response.getName();
        String string2 = response.getId();
        String string3 = response.getVersion();
        String string4 = response.getIdeaVersion().getSinceBuild();
        String string5 = response.getIdeaVersion().getUntilBuild();
        List list = response.getDepends();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return new PluginBean(string, string2, string3, category, string4, string5, list);
    }

    @NotNull
    public final String getSiteUrl() {
        return this.siteUrl;
    }

    public PluginRepositoryInstance(@NotNull String siteUrl, @Nullable String username, @Nullable String password) {
        Intrinsics.checkParameterIsNotNull((Object)siteUrl, (String)"siteUrl");
        this.siteUrl = siteUrl;
        this.username = username;
        this.password = password;
        this.service = (PluginRepositoryService)new RestAdapter.Builder().setEndpoint(this.siteUrl).setClient((Client.Provider)service.1.INSTANCE).setLog((RestAdapter.Log)service.2.INSTANCE).setLogLevel(RestAdapter.LogLevel.BASIC).setConverter((Converter)new SimpleXMLConverter()).build().create(PluginRepositoryService.class);
    }
}

