/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.java-time;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.java-time.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
public final class JavaLocalDateColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    private static final JavaLocalDateColumnType INSTANCE;
    public static final Companion Companion;

    @NotNull
    public String sqlType() {
        return "DATE";
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof LocalDate) {
            instant = Instant.from(((LocalDate)value).atStartOfDay(ZoneId.systemDefault()));
        } else if (object instanceof Date) {
            instant = ((Date)value).toInstant();
        } else if (object instanceof Timestamp) {
            instant = ((Timestamp)value).toInstant();
        } else {
            String string = "Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Instant instant2 = instant;
        return '\'' + JavaDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER$p().format(instant2) + '\'';
    }

    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        DatabaseDialect databaseDialect;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object = value;
        Object object2 = object instanceof LocalDate ? value : (object instanceof Date ? ((Date)value).toLocalDate() : (object instanceof Timestamp ? ((Timestamp)value).toLocalDateTime().toLocalDate() : (object instanceof Integer ? Instant.ofEpochMilli(((Number)value).intValue()).atZone(ZoneId.systemDefault()).toLocalDate() : (object instanceof Long ? Instant.ofEpochMilli(((Number)value).longValue()).atZone(ZoneId.systemDefault()).toLocalDate() : (object instanceof String ? ((databaseDialect = DefaultKt.getCurrentDialect()) instanceof SQLiteDialect ? LocalDate.parse((CharSequence)value) : value) : LocalDate.parse(value.toString()))))));
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"when(value) {\n        is\u2026e(value.toString())\n    }");
        return object2;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return value instanceof LocalDate ? new Date(JavaDateColumnTypeKt.access$getMillis$p((LocalDate)value)) : value;
    }

    public JavaLocalDateColumnType() {
        super(false, 1, null);
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new JavaLocalDateColumnType();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateColumnType;", "exposed-java-time"})
    public static final class Companion {
        @NotNull
        public final JavaLocalDateColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

