/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.java-time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.java-time.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.java-time.JavaInstantColumnType;
import org.jetbrains.exposed.sql.java-time.JavaLocalDateColumnType;
import org.jetbrains.exposed.sql.java-time.JavaLocalDateTimeColumnType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017\u001a\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017\u001a\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017\"#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"#\u0010\u0007\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\b\u0010\u0004\"#\u0010\n\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\u0006\u001a\u0004\b\u000b\u0010\u0004\"\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"DEFAULT_DATE_STRING_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDEFAULT_DATE_STRING_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "DEFAULT_DATE_STRING_FORMATTER$delegate", "Lkotlin/Lazy;", "DEFAULT_DATE_TIME_STRING_FORMATTER", "getDEFAULT_DATE_TIME_STRING_FORMATTER", "DEFAULT_DATE_TIME_STRING_FORMATTER$delegate", "SQLITE_DATE_TIME_STRING_FORMATTER", "getSQLITE_DATE_TIME_STRING_FORMATTER", "SQLITE_DATE_TIME_STRING_FORMATTER$delegate", "millis", "", "Ljava/time/LocalDate;", "getMillis", "(Ljava/time/LocalDate;)J", "dateTimeWithFractionFormat", "fraction", "", "formatterForDateString", "date", "", "Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/sql/Table;", "name", "datetime", "Ljava/time/LocalDateTime;", "timestamp", "Ljava/time/Instant;", "exposed-java-time"})
public final class JavaDateColumnTypeKt {
    private static final Lazy DEFAULT_DATE_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_DATE_STRING_FORMATTER.2.INSTANCE);
    private static final Lazy DEFAULT_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_DATE_TIME_STRING_FORMATTER.2.INSTANCE);
    private static final Lazy SQLITE_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)SQLITE_DATE_TIME_STRING_FORMATTER.2.INSTANCE);

    private static final DateTimeFormatter getDEFAULT_DATE_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_STRING_FORMATTER$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_TIME_STRING_FORMATTER$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getSQLITE_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = SQLITE_DATE_TIME_STRING_FORMATTER$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter formatterForDateString(String date) {
        return JavaDateColumnTypeKt.dateTimeWithFractionFormat(StringsKt.substringAfterLast((String)date, (char)'.', (String)"").length());
    }

    private static final DateTimeFormatter dateTimeWithFractionFormat(int fraction) {
        String string;
        String baseFormat = "yyyy-MM-d HH:mm:ss";
        int n = fraction;
        if (1 <= n && 9 >= n) {
            n = 1;
            Function1 function1 = dateTimeWithFractionFormat.newFormat.1.INSTANCE;
            CharSequence charSequence = null;
            int n2 = 0;
            CharSequence charSequence2 = null;
            CharSequence charSequence3 = "";
            CharSequence charSequence4 = baseFormat + '.';
            string = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(n, fraction)), (CharSequence)charSequence3, (CharSequence)charSequence4, charSequence2, (int)n2, charSequence, (Function1)function1, (int)28, null);
        } else {
            string = baseFormat;
        }
        String newFormat2 = string;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(newFormat2).withLocale(Locale.ROOT).withZone(ZoneId.systemDefault());
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPatt\u2026e(ZoneId.systemDefault())");
        return dateTimeFormatter;
    }

    private static final long getMillis(@NotNull LocalDate $this$millis) {
        return $this$millis.atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * (long)1000;
    }

    @NotNull
    public static final Column<LocalDate> date(@NotNull Table $this$date, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$date, (String)"$this$date");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return $this$date.registerColumn(name, (IColumnType)new JavaLocalDateColumnType());
    }

    @NotNull
    public static final Column<LocalDateTime> datetime(@NotNull Table $this$datetime, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$datetime, (String)"$this$datetime");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return $this$datetime.registerColumn(name, (IColumnType)new JavaLocalDateTimeColumnType());
    }

    @NotNull
    public static final Column<Instant> timestamp(@NotNull Table $this$timestamp, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$timestamp, (String)"$this$timestamp");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return $this$timestamp.registerColumn(name, (IColumnType)new JavaInstantColumnType());
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_STRING_FORMATTER$p() {
        return JavaDateColumnTypeKt.getDEFAULT_DATE_STRING_FORMATTER();
    }

    public static final /* synthetic */ long access$getMillis$p(LocalDate $this$access_u24millis_u24p) {
        return JavaDateColumnTypeKt.getMillis($this$access_u24millis_u24p);
    }

    public static final /* synthetic */ DateTimeFormatter access$getSQLITE_DATE_TIME_STRING_FORMATTER$p() {
        return JavaDateColumnTypeKt.getSQLITE_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_TIME_STRING_FORMATTER$p() {
        return JavaDateColumnTypeKt.getDEFAULT_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$formatterForDateString(String date) {
        return JavaDateColumnTypeKt.formatterForDateString(date);
    }
}

