/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.entity.mime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ContentType;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;

public class FileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;

    public FileBody(File file2) {
        this(file2, ContentType.DEFAULT_BINARY, file2 != null ? file2.getName() : null);
    }

    public FileBody(File file2, ContentType contentType, String filename) {
        super(contentType);
        Args.notNull(file2, "File");
        this.file = file2;
        this.filename = filename == null ? file2.getName() : filename;
    }

    public FileBody(File file2, ContentType contentType) {
        this(file2, contentType, file2 != null ? file2.getName() : null);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull(out, "Output stream");
        try (FileInputStream in = new FileInputStream(this.file);){
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)in).read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        }
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

