/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0080\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/compose/internal/Version;", "", "major", "", "minor", "patch", "meta", "", "(IIILjava/lang/String;)V", "getMajor", "()I", "getMeta", "()Ljava/lang/String;", "getMinor", "getPatch", "compareTo", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "Companion", "compose"})
public final class Version
implements Comparable<Version> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final String meta;
    @NotNull
    private static final Regex SEMVER_REGEXP = new Regex("^(\\d+)(?:\\.(\\d*))?(?:\\.(\\d*))?(?:-(.*))?$");

    public Version(int major, int minor, int patch, @NotNull String meta) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.meta = meta;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public final String getMeta() {
        return this.meta;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.major != other.major) {
            n = this.major - other.major;
        } else if (this.minor != other.minor) {
            n = this.minor - other.minor;
        } else if (this.patch != other.patch) {
            n = this.patch - other.patch;
        } else if (((CharSequence)this.meta).length() == 0) {
            n = 1;
        } else if (((CharSequence)other.meta).length() == 0) {
            n = -1;
        } else {
            String[] stringArray = new String[]{"-"};
            List metaParts = StringsKt.split$default((CharSequence)this.meta, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String[] stringArray2 = new String[]{"-"};
            List otherMetaParts = StringsKt.split$default((CharSequence)other.meta, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            int result2 = 0;
            int n2 = Math.min(metaParts.size(), otherMetaParts.size());
            for (int i2 = 0; i2 < n2; ++i2) {
                String otherMetaPart;
                String metaPart = (String)metaParts.get(i2);
                if (Intrinsics.areEqual((Object)metaPart, (Object)(otherMetaPart = (String)otherMetaParts.get(i2)))) continue;
                result2 = metaPart.compareTo(otherMetaPart);
                break;
            }
            n = result2 != 0 ? result2 : (metaParts.size() < otherMetaParts.size() ? 1 : (metaParts.size() > otherMetaParts.size() ? -1 : 0));
        }
        return n;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final String component4() {
        return this.meta;
    }

    @NotNull
    public final Version copy(int major, int minor, int patch, @NotNull String meta) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        return new Version(major, minor, patch, meta);
    }

    public static /* synthetic */ Version copy$default(Version version, int n, int n2, int n3, String string, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = version.major;
        }
        if ((n4 & 2) != 0) {
            n2 = version.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = version.patch;
        }
        if ((n4 & 8) != 0) {
            string = version.meta;
        }
        return version.copy(n, n2, n3, string);
    }

    @NotNull
    public String toString() {
        return "Version(major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ", meta=" + this.meta + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.major);
        result2 = result2 * 31 + Integer.hashCode(this.minor);
        result2 = result2 * 31 + Integer.hashCode(this.patch);
        result2 = result2 * 31 + this.meta.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version version = (Version)other;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.patch != version.patch) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.meta, (Object)version.meta);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/compose/internal/Version$Companion;", "", "()V", "SEMVER_REGEXP", "Lkotlin/text/Regex;", "fromString", "Lorg/jetbrains/compose/internal/Version;", "versionString", "", "compose"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version fromString(@NotNull String versionString) {
            int patch;
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            MatchResult matchResult = SEMVER_REGEXP.matchEntire((CharSequence)versionString);
            if (matchResult == null) {
                return new Version(0, 0, 0, "");
            }
            MatchResult matchResult2 = matchResult;
            Object object = matchResult2.getGroups().get(1);
            int major = object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : 0;
            Object object2 = matchResult2.getGroups().get(2);
            int minor = object2 != null && (object2 = object2.getValue()) != null ? Integer.parseInt((String)object2) : 0;
            Object object3 = matchResult2.getGroups().get(3);
            int n = patch = object3 != null && (object3 = object3.getValue()) != null ? Integer.parseInt((String)object3) : 0;
            Object object4 = matchResult2.getGroups().get(4);
            if (object4 == null || (object4 = object4.getValue()) == null) {
                object4 = "";
            }
            Object meta = object4;
            return new Version(major, minor, patch, (String)meta);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

