/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.ui.tooling.preview.rpc;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\u001a\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001f\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u0014H\u0000\u00a2\u0006\u0002\u0010\u0015\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"localhost", "Ljava/net/InetAddress;", "getLocalhost", "()Ljava/net/InetAddress;", "stackTraceString", "", "", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "getLocalSocketOrNull", "Ljava/net/Socket;", "port", "", "trials", "trialDelay", "", "newServerSocket", "Ljava/net/ServerSocket;", "nextOrNull", "T", "", "(Ljava/util/Iterator;)Ljava/lang/Object;", "preview-rpc"})
public final class UtilsKt {
    @Nullable
    public static final Socket getLocalSocketOrNull(int port, int trials, long trialDelay) {
        int n = 0;
        if (n <= trials) {
            while (true) {
                int i2 = n++;
                try {
                    return new Socket(UtilsKt.getLocalhost(), port);
                }
                catch (IOException e) {
                    Thread.sleep(trialDelay);
                    if (i2 != trials) continue;
                }
                break;
            }
        }
        return null;
    }

    @NotNull
    public static final InetAddress getLocalhost() {
        InetAddress inetAddress = InetAddress.getLoopbackAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLoopbackAddress()");
        return inetAddress;
    }

    @NotNull
    public static final ServerSocket newServerSocket() {
        ServerSocket serverSocket = new ServerSocket(0, 0, UtilsKt.getLocalhost());
        boolean bl = false;
        boolean bl2 = false;
        ServerSocket $this$newServerSocket_u24lambda_u2d0 = serverSocket;
        boolean bl3 = false;
        $this$newServerSocket_u24lambda_u2d0.setReuseAddress(true);
        $this$newServerSocket_u24lambda_u2d0.setSoTimeout(1000);
        return serverSocket;
    }

    @Nullable
    public static final <T> T nextOrNull(@NotNull Iterator<? extends T> $this$nextOrNull) {
        Intrinsics.checkNotNullParameter($this$nextOrNull, (String)"<this>");
        return $this$nextOrNull.hasNext() ? (T)$this$nextOrNull.next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String getStackTraceString(@NotNull Throwable $this$stackTraceString) {
        Intrinsics.checkNotNullParameter((Object)$this$stackTraceString, (String)"<this>");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Object object = new PrintStream(output);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PrintStream it = (PrintStream)object;
            boolean bl3 = false;
            $this$stackTraceString.printStackTrace(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = output.toString(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"output.toString(Charsets.UTF_8)");
        return object;
    }
}

