/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.TargetFormat;
import org.jetbrains.compose.desktop.application.internal.Arch;
import org.jetbrains.compose.desktop.application.internal.OS;
import org.jetbrains.compose.desktop.application.internal.OsUtilsKt;
import org.jetbrains.compose.desktop.application.internal.Target;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0000\u001a\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u001a\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0000\u001a\u001e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fH\u0000\u001a\f\u0010 \u001a\u00020\u0012*\u00020\u0012H\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00078@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\"\u001b\u0010\u000b\u001a\u00020\f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0005\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013\u00a8\u0006!"}, d2={"currentArch", "Lorg/jetbrains/compose/desktop/application/internal/Arch;", "getCurrentArch", "()Lorg/jetbrains/compose/desktop/application/internal/Arch;", "currentArch$delegate", "Lkotlin/Lazy;", "currentOS", "Lorg/jetbrains/compose/desktop/application/internal/OS;", "getCurrentOS", "()Lorg/jetbrains/compose/desktop/application/internal/OS;", "currentOS$delegate", "currentTarget", "Lorg/jetbrains/compose/desktop/application/internal/Target;", "getCurrentTarget", "()Lorg/jetbrains/compose/desktop/application/internal/Target;", "currentTarget$delegate", "isJarFile", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "executableName", "", "nameWithoutExtension", "findOutputFileOrDir", "dir", "targetFormat", "Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;", "javaExecutable", "javaHome", "jvmToolFile", "toolName", "Lorg/gradle/api/provider/Provider;", "checkExistingFile", "compose"})
public final class OsUtilsKt {
    @NotNull
    private static final Lazy currentTarget$delegate = LazyKt.lazy((Function0)currentTarget.2.INSTANCE);
    @NotNull
    private static final Lazy currentArch$delegate = LazyKt.lazy((Function0)currentArch.2.INSTANCE);
    @NotNull
    private static final Lazy currentOS$delegate = LazyKt.lazy((Function0)currentOS.2.INSTANCE);

    @NotNull
    public static final Target getCurrentTarget() {
        Lazy lazy = currentTarget$delegate;
        Object var1_1 = null;
        boolean bl = false;
        return (Target)lazy.getValue();
    }

    @NotNull
    public static final Arch getCurrentArch() {
        Lazy lazy = currentArch$delegate;
        Object var1_1 = null;
        boolean bl = false;
        return (Arch)((Object)lazy.getValue());
    }

    @NotNull
    public static final OS getCurrentOS() {
        Lazy lazy = currentOS$delegate;
        Object var1_1 = null;
        boolean bl = false;
        return (OS)((Object)lazy.getValue());
    }

    @NotNull
    public static final String executableName(@NotNull String nameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)nameWithoutExtension, (String)"nameWithoutExtension");
        return OsUtilsKt.getCurrentOS() == OS.Windows ? Intrinsics.stringPlus((String)nameWithoutExtension, (Object)".exe") : nameWithoutExtension;
    }

    @NotNull
    public static final String javaExecutable(@NotNull String javaHome) {
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        String string = FilesKt.resolve((File)new File(javaHome), (String)Intrinsics.stringPlus((String)"bin/", (Object)OsUtilsKt.executableName("java"))).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(javaHome).resolve(\"bin/${executableName(\"java\")}\").absolutePath");
        return string;
    }

    @NotNull
    public static final File jvmToolFile(@NotNull String toolName, @NotNull Provider<String> javaHome) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter(javaHome, (String)"javaHome");
        File jtool = FilesKt.resolve((File)new File((String)javaHome.get()), (String)Intrinsics.stringPlus((String)"bin/", (Object)OsUtilsKt.executableName(toolName)));
        boolean bl = jtool.isFile();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid JDK: " + jtool + " is not a file! \nEnsure JAVA_HOME or buildSettings.javaHome is set to JDK 15 or newer";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return jtool;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Internal
    @NotNull
    public static final File findOutputFileOrDir(@NotNull File dir, @NotNull TargetFormat targetFormat) {
        Object element$iv;
        boolean bl;
        File file;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)targetFormat), (String)"targetFormat");
        TargetFormat targetFormat2 = targetFormat;
        int n = WhenMappings.$EnumSwitchMapping$0[targetFormat2.ordinal()];
        if (n == 1) {
            file = dir;
            return file;
        }
        Sequence $this$first$iv = (Sequence)FilesKt.walk$default((File)dir, null, (int)1, null);
        boolean $i$f$first = false;
        Iterator iterator2 = $this$first$iv.iterator();
        do {
            if (!iterator2.hasNext()) throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            element$iv = iterator2.next();
            File it = (File)element$iv;
            boolean bl2 = false;
            if (it.isFile()) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (StringsKt.endsWith$default((String)string, (String)targetFormat.getFileExt(), (boolean)false, (int)2, null)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        file = (File)element$iv;
        return file;
    }

    @NotNull
    public static final File checkExistingFile(@NotNull File $this$checkExistingFile) {
        Intrinsics.checkNotNullParameter((Object)$this$checkExistingFile, (String)"<this>");
        File file = $this$checkExistingFile;
        boolean bl = false;
        boolean bl2 = false;
        File $this$checkExistingFile_u24lambda_u2d3 = file;
        boolean bl3 = false;
        boolean bl4 = $this$checkExistingFile_u24lambda_u2d3.isFile();
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = '\'' + $this$checkExistingFile_u24lambda_u2d3.getAbsolutePath() + "' does not exist";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return file;
    }

    public static final boolean isJarFile(@NotNull File $this$isJarFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJarFile, (String)"<this>");
        String string = $this$isJarFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return StringsKt.endsWith((String)string, (String)".jar", (boolean)true) && $this$isJarFile.isFile();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetFormat.values().length];
            nArray[TargetFormat.AppImage.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

