/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.viktor;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.bio.viktor.LoaderKt;
import org.jetbrains.bio.viktor.ResourceLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bio/viktor/Loader;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "arch", "", "getArch", "()Ljava/lang/String;", "architectureSupported", "", "<set-?>", "nativeLibraryLoaded", "getNativeLibraryLoaded$viktor", "()Z", "optimizationSupported", "ensureLoaded", "", "warnNoOptimization", "viktor"})
public final class Loader {
    private static final Logger LOG;
    private static boolean nativeLibraryLoaded;
    private static boolean optimizationSupported;
    private static boolean architectureSupported;
    public static final Loader INSTANCE;

    public final boolean getNativeLibraryLoaded$viktor() {
        return nativeLibraryLoaded;
    }

    public final void ensureLoaded() {
    }

    private final String getArch() {
        String string = System.getProperty("os.arch");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.arch\")");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String arch = string4;
        if (!Intrinsics.areEqual((Object)arch, (Object)"amd64") && !Intrinsics.areEqual((Object)arch, (Object)"x86_64")) {
            string2 = "unsupported architecture: " + arch;
            bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return "x86_64";
    }

    private final void warnNoOptimization() {
        if (!architectureSupported) {
            LOG.info("SIMD optimization is not available for your architecture, enable debug output for more details.");
            LOG.debug("Currently supported architectures: x86_64, amd64.\nFallback Kotlin implementation will be used.\nBuild viktor for your system from source as described in https://github.com/JetBrains-Research/viktor");
        } else if (!nativeLibraryLoaded) {
            LOG.info("Couldn't load native SIMD library, enable debug output for more details.");
            LOG.debug("Native SIMD library couldn't be loaded.\nCurrently supported operational systems: Linux, Windows, MacOS.\nFallback Kotlin implementation will be used.\nBuild viktor for your system from source as described in https://github.com/JetBrains-Research/viktor");
        } else if (!optimizationSupported) {
            LOG.info("SIMD optimization is not available for your system, enable debug output for more details.");
            LOG.debug("No supported SIMD instruction sets were detected on your system.\nCurrently supported SIMD instruction sets: SSE2, AVX.\nFallback Kotlin implementation will be used.\nBuild viktor for your system from source as described in https://github.com/JetBrains-Research/viktor");
        }
    }

    private Loader() {
    }

    static {
        Loader loader;
        INSTANCE = loader = new Loader();
        LOG = LoggerFactory.getLogger(Loader.class);
        try {
            String string = loader.getArch();
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            architectureSupported = true;
            new ResourceLibrary("simd." + loader.getArch()).install();
            nativeLibraryLoaded = true;
            if (LoaderKt.isAvxSupported()) {
                new ResourceLibrary("simd.avx." + loader.getArch()).install();
                optimizationSupported = true;
            } else if (LoaderKt.isSse2Supported()) {
                new ResourceLibrary("simd.sse2." + loader.getArch()).install();
                optimizationSupported = true;
            } else {
                loader.warnNoOptimization();
            }
        }
        catch (Throwable e) {
            LOG.info(e.getMessage());
            loader.warnNoOptimization();
        }
    }
}

