/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.npy;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ConstantsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.npy.NpyArray;
import org.jetbrains.bio.npy.NpyFile;
import org.jetbrains.bio.npy.NpzEntry;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/bio/npy/NpzFile;", "", "()V", "read", "Lorg/jetbrains/bio/npy/NpzFile$Reader;", "path", "Ljava/nio/file/Path;", "write", "Lorg/jetbrains/bio/npy/NpzFile$Writer;", "compressed", "", "Reader", "Writer", "npy-compileKotlin"})
public final class NpzFile {
    public static final NpzFile INSTANCE;

    @JvmStatic
    @NotNull
    public static final Reader read(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new Reader(path);
    }

    @JvmStatic
    @NotNull
    public static final Writer write(@NotNull Path path, boolean compressed) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new Writer(path, compressed);
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ Writer write$default(Path path, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return NpzFile.write(path, bl);
    }

    private NpzFile() {
        INSTANCE = this;
    }

    static {
        new NpzFile();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/bio/npy/NpzFile$Reader;", "Ljava/io/Closeable;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "zf", "Ljava/util/zip/ZipFile;", "close", "", "component1", "copy", "get", "Lorg/jetbrains/bio/npy/NpyArray;", "name", "", "step", "", "introspect", "", "Lorg/jetbrains/bio/npy/NpzEntry;", "getBuffers", "Lkotlin/sequences/Sequence;", "Ljava/nio/ByteBuffer;", "entry", "Ljava/util/zip/ZipEntry;", "npy-compileKotlin"})
    public static final class Reader
    implements Closeable,
    AutoCloseable {
        private final ZipFile zf;
        @NotNull
        private final Path path;

        @NotNull
        public final List<NpzEntry> introspect() {
            Enumeration<? extends ZipEntry> enumeration = this.zf.entries();
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<ZipEntry, NpzEntry>(this){
                final /* synthetic */ Reader this$0;

                @NotNull
                public final NpzEntry invoke(ZipEntry it) {
                    Class<Object> clazz;
                    ZipFile zipFile = Reader.access$getZf$p(this.this$0);
                    ZipEntry zipEntry = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"it");
                    NpyFile.Header header = NpyFile.Header.Companion.read((ByteBuffer)SequencesKt.first((Sequence)Reader.access$getBuffers(this.this$0, zipFile, zipEntry, Integer.MAX_VALUE)));
                    block0 : switch (header.getType()) {
                        case 'b': {
                            clazz = Boolean.TYPE;
                            break;
                        }
                        case 'i': 
                        case 'u': {
                            switch (header.getBytes()) {
                                case 1: {
                                    clazz = Byte.TYPE;
                                    break block0;
                                }
                                case 2: {
                                    clazz = Short.TYPE;
                                    break block0;
                                }
                                case 4: {
                                    clazz = Integer.TYPE;
                                    break block0;
                                }
                                case 8: {
                                    clazz = Long.TYPE;
                                    break block0;
                                }
                            }
                            throw (Throwable)new IllegalStateException();
                        }
                        case 'f': {
                            switch (header.getBytes()) {
                                case 4: {
                                    clazz = Float.TYPE;
                                    break block0;
                                }
                                case 8: {
                                    clazz = Double.TYPE;
                                    break block0;
                                }
                            }
                            throw (Throwable)new IllegalStateException();
                        }
                        case 'S': {
                            clazz = String.class;
                            break;
                        }
                        default: {
                            throw (Throwable)new IllegalStateException();
                        }
                    }
                    Class<Object> type = clazz;
                    return new NpzEntry(StringsKt.substringBeforeLast$default((String)it.getName(), (char)'.', null, (int)2, null), type, header.getShape());
                }
                {
                    this.this$0 = reader;
                    super(1);
                }
            })));
        }

        @NotNull
        public final NpyArray get(@NotNull String name, int step) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            ZipEntry zipEntry = this.zf.getEntry(name + ".npy");
            Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"zf.getEntry(name + \".npy\")");
            return NpyFile.INSTANCE.read$npy_compileKotlin(this.getBuffers(this.zf, zipEntry, step));
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NpyArray get$default(Reader reader, String string, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
            }
            if ((n2 & 2) != 0) {
                n = 262144;
            }
            return reader.get(string, n);
        }

        /*
         * WARNING - void declaration
         */
        private final Sequence<ByteBuffer> getBuffers(@NotNull ZipFile $receiver, ZipEntry entry, int step) {
            void chunk;
            InputStream is = $receiver.getInputStream(entry);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = ByteBuffer.allocate(0);
            return SequencesKt.generateSequence((Function0)((Function0)new Function0<ByteBuffer>(is, (Ref.ObjectRef)chunk, step){
                final /* synthetic */ InputStream $is;
                final /* synthetic */ Ref.ObjectRef $chunk;
                final /* synthetic */ int $step;

                @Nullable
                public final ByteBuffer invoke() {
                    ByteBuffer byteBuffer;
                    int remaining = this.$is.available() + ((ByteBuffer)this.$chunk.element).remaining();
                    if (remaining > 0) {
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(Math.min(remaining, this.$step));
                        Ref.ObjectRef objectRef = this.$chunk;
                        ByteBuffer $receiver = byteBuffer2;
                        $receiver.put((ByteBuffer)this.$chunk.element);
                        Channels.newChannel(this.$is).read($receiver);
                        $receiver.rewind();
                        ByteBuffer byteBuffer3 = byteBuffer2;
                        objectRef.element = byteBuffer3.asReadOnlyBuffer();
                        byteBuffer = (ByteBuffer)this.$chunk.element;
                    } else {
                        this.$is.close();
                        byteBuffer = null;
                    }
                    return byteBuffer;
                }
                {
                    this.$is = inputStream;
                    this.$chunk = objectRef;
                    this.$step = n;
                    super(0);
                }
            }));
        }

        @Override
        public void close() {
            this.zf.close();
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public Reader(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            this.path = path;
            this.zf = new ZipFile(this.path.toFile(), 1, Charsets.US_ASCII);
        }

        @NotNull
        public static final /* synthetic */ Sequence access$getBuffers(Reader $this, @NotNull ZipFile $receiver, @NotNull ZipEntry entry, int step) {
            return $this.getBuffers($receiver, entry, step);
        }

        @NotNull
        public static final /* synthetic */ ZipFile access$getZf$p(Reader $this) {
            return $this.zf;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        @NotNull
        public final Reader copy(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return new Reader(path);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Reader copy$default(Reader reader, Path path, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                path = reader.path;
            }
            return reader.copy(path);
        }

        public String toString() {
            return "Reader(path=" + this.path + ")";
        }

        public int hashCode() {
            Path path = this.path;
            return path != null ? ((Object)path).hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Reader)) break block3;
                    Reader reader = (Reader)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)reader.path)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\u0010\u0012\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0016\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J-\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001b2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\"\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001c2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J,\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001d2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J,\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020 2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J,\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00192\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J,\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020!2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J,\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\"2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007J\u001e\u0010#\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/bio/npy/NpzFile$Writer;", "Ljava/io/Closeable;", "Ljava/lang/AutoCloseable;", "path", "Ljava/nio/file/Path;", "compressed", "", "(Ljava/nio/file/Path;Z)V", "getCompressed", "()Z", "getPath", "()Ljava/nio/file/Path;", "zos", "Ljava/util/zip/ZipOutputStream;", "close", "", "component1", "component2", "copy", "write", "name", "", "data", "", "shape", "", "(Ljava/lang/String;[Ljava/lang/String;[I)V", "", "", "", "order", "Ljava/nio/ByteOrder;", "", "", "", "writeEntry", "chunks", "Lkotlin/sequences/Sequence;", "Ljava/nio/ByteBuffer;", "npy-compileKotlin"})
    public static final class Writer
    implements Closeable,
    AutoCloseable {
        private final ZipOutputStream zos;
        @NotNull
        private final Path path;
        private final boolean compressed;

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull boolean[] data, @NotNull int[] shape) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_compileKotlin(data, shape));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, boolean[] blArray, int[] nArray, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n & 4) != 0) {
                nArray = new int[]{blArray.length};
            }
            writer.write(string, blArray, nArray);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull boolean[] data) {
            Writer.write$default(this, name, data, null, 4, null);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull byte[] data, @NotNull int[] shape) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_compileKotlin(data, shape));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, byte[] byArray, int[] nArray, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n & 4) != 0) {
                nArray = new int[]{byArray.length};
            }
            writer.write(string, byArray, nArray);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull byte[] data) {
            Writer.write$default(this, name, data, null, 4, null);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull short[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            Intrinsics.checkParameterIsNotNull((Object)order, (String)"order");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_compileKotlin(data, shape, order));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, short[] sArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n & 4) != 0) {
                nArray = new int[]{sArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, sArray, nArray, byteOrder);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull short[] data, @NotNull int[] shape) {
            Writer.write$default(this, name, data, shape, null, 8, null);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull short[] data) {
            Writer.write$default(this, name, data, null, null, 12, null);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull int[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            Intrinsics.checkParameterIsNotNull((Object)order, (String)"order");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_compileKotlin(data, shape, order));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, int[] nArray, int[] nArray2, ByteOrder byteOrder, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n & 4) != 0) {
                nArray2 = new int[]{nArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, nArray, nArray2, byteOrder);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull int[] data, @NotNull int[] shape) {
            Writer.write$default(this, name, data, shape, null, 8, null);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull int[] data) {
            Writer.write$default(this, name, data, null, null, 12, null);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull long[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            Intrinsics.checkParameterIsNotNull((Object)order, (String)"order");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_compileKotlin(data, shape, order));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, long[] lArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n & 4) != 0) {
                nArray = new int[]{lArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, lArray, nArray, byteOrder);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull long[] data, @NotNull int[] shape) {
            Writer.write$default(this, name, data, shape, null, 8, null);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull long[] data) {
            Writer.write$default(this, name, data, null, null, 12, null);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull float[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            Intrinsics.checkParameterIsNotNull((Object)order, (String)"order");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_compileKotlin(data, shape, order));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, float[] fArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n & 4) != 0) {
                nArray = new int[]{fArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, fArray, nArray, byteOrder);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull float[] data, @NotNull int[] shape) {
            Writer.write$default(this, name, data, shape, null, 8, null);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull float[] data) {
            Writer.write$default(this, name, data, null, null, 12, null);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull double[] data, @NotNull int[] shape, @NotNull ByteOrder order) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            Intrinsics.checkParameterIsNotNull((Object)order, (String)"order");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_compileKotlin(data, shape, order));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, double[] dArray, int[] nArray, ByteOrder byteOrder, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n & 4) != 0) {
                nArray = new int[]{dArray.length};
            }
            if ((n & 8) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            writer.write(string, dArray, nArray, byteOrder);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull double[] data, @NotNull int[] shape) {
            Writer.write$default(this, name, data, shape, null, 8, null);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull double[] data) {
            Writer.write$default(this, name, data, null, null, 12, null);
        }

        @JvmOverloads
        public final void write(@NotNull String name, @NotNull String[] data, @NotNull int[] shape) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            this.writeEntry(name, NpyFile.INSTANCE.allocate$npy_compileKotlin(data, shape));
        }

        @JvmOverloads
        public static /* bridge */ /* synthetic */ void write$default(Writer writer, String string, String[] stringArray, int[] nArray, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
            }
            if ((n & 4) != 0) {
                nArray = new int[]{((Object[])stringArray).length};
            }
            writer.write(string, stringArray, nArray);
        }

        @JvmOverloads
        public void write(@NotNull String name, @NotNull String[] data) {
            Writer.write$default(this, name, data, null, 4, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeEntry(String name, Sequence<? extends ByteBuffer> chunks) {
            ZipEntry zipEntry = new ZipEntry(name + ".npy");
            ZipEntry $receiver = zipEntry;
            if (this.compressed) {
                $receiver.setMethod(8);
            } else {
                $receiver.setMethod(0);
                CRC32 crcAcc = new CRC32();
                long sizeAcc = 0L;
                for (ByteBuffer chunk : chunks) {
                    sizeAcc += (long)chunk.capacity();
                    crcAcc.update(chunk);
                    chunk.rewind();
                }
                $receiver.setSize(sizeAcc);
                $receiver.setCrc(crcAcc.getValue());
            }
            ZipEntry entry = zipEntry;
            this.zos.putNextEntry(entry);
            try {
                WritableByteChannel fc = Channels.newChannel(this.zos);
                for (ByteBuffer chunk : chunks) {
                    while (chunk.hasRemaining()) {
                        fc.write(chunk);
                    }
                }
            }
            finally {
                this.zos.closeEntry();
            }
        }

        @Override
        public void close() {
            this.zos.close();
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean getCompressed() {
            return this.compressed;
        }

        public Writer(@NotNull Path path, boolean compressed) {
            ZipOutputStream zipOutputStream;
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            this.path = path;
            this.compressed = compressed;
            OutputStream outputStream = Files.newOutputStream(this.path, new OpenOption[0]);
            int n = 0;
            boolean bl = true;
            Object var6_6 = null;
            ZipOutputStream zipOutputStream2 = zipOutputStream;
            ZipOutputStream zipOutputStream3 = zipOutputStream;
            Writer writer = this;
            if (var6_6 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
            }
            if (bl & true) {
                n = ConstantsKt.DEFAULT_BUFFER_SIZE;
            }
            BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n);
            zipOutputStream2((OutputStream)bufferedOutputStream, Charsets.US_ASCII);
            writer.zos = zipOutputStream3;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.compressed;
        }

        @NotNull
        public final Writer copy(@NotNull Path path, boolean compressed) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return new Writer(path, compressed);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Writer copy$default(Writer writer, Path path, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                path = writer.path;
            }
            if ((n & 2) != 0) {
                bl = writer.compressed;
            }
            return writer.copy(path, bl);
        }

        public String toString() {
            return "Writer(path=" + this.path + ", compressed=" + this.compressed + ")";
        }

        public int hashCode() {
            Path path = this.path;
            int n = (path != null ? ((Object)path).hashCode() : 0) * 31;
            int n2 = this.compressed ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Writer)) break block3;
                    Writer writer = (Writer)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)writer.path) || !(this.compressed == writer.compressed)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

