/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.anko.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.AnkoException;
import org.jetbrains.anko.db.DatabaseKt;
import org.jetbrains.anko.db.MapRowParser;
import org.jetbrains.anko.db.RowParser;
import org.jetbrains.anko.db.SqlOrderDirection;
import org.jetbrains.anko.db.SqlParsersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0005J\u001f\u0010\u0007\u001a\u00020\u00002\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u000b\u001a\u00020\u0000J*\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H\u001f0!\u00a2\u0006\u0002\b#\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\"H\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J?\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00052*\u0010'\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(0\u0012\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(\u00a2\u0006\u0002\u0010)J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+J\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020.J$\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001f00\"\b\b\u0000\u0010\u001f*\u00020\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001f02J$\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001f00\"\b\b\u0000\u0010\u001f*\u00020\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001f03J%\u00104\u001a\u0004\u0018\u0001H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001f02\u00a2\u0006\u0002\u00105J%\u00104\u001a\u0004\u0018\u0001H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001f03\u00a2\u0006\u0002\u00106J#\u00107\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001f02\u00a2\u0006\u0002\u00105J#\u00107\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00012\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001f03\u00a2\u0006\u0002\u00106J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0005J?\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u00052*\u0010'\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(0\u0012\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010(\u00a2\u0006\u0002\u0010)J'\u0010:\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u00052\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005\u00a2\u0006\u0002\u0010;J)\u0010<\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u00052\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010;R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/anko/db/SelectQueryBuilder;", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "tableName", "", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;)V", "columns", "Ljava/util/ArrayList;", "getDb", "()Landroid/database/sqlite/SQLiteDatabase;", "distinct", "", "groupBy", "having", "havingApplied", "limit", "nativeSelectionArgs", "", "[Ljava/lang/String;", "orderBy", "selection", "selectionApplied", "getTableName", "()Ljava/lang/String;", "useNativeSelection", "column", "name", "names", "([Ljava/lang/String;)Lorg/jetbrains/anko/db/SelectQueryBuilder;", "exec", "T", "f", "Lkotlin/Function1;", "Landroid/database/Cursor;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "execInternal", "value", "args", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Lorg/jetbrains/anko/db/SelectQueryBuilder;", "count", "", "offset", "direction", "Lorg/jetbrains/anko/db/SqlOrderDirection;", "parseList", "", "parser", "Lorg/jetbrains/anko/db/MapRowParser;", "Lorg/jetbrains/anko/db/RowParser;", "parseOpt", "(Lorg/jetbrains/anko/db/MapRowParser;)Ljava/lang/Object;", "(Lorg/jetbrains/anko/db/RowParser;)Ljava/lang/Object;", "parseSingle", "where", "select", "whereSimple", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/anko/db/SelectQueryBuilder;", "whereSupport", "sqlite-compileReleaseKotlin"})
public final class SelectQueryBuilder {
    private final ArrayList<String> columns;
    private final ArrayList<String> groupBy;
    private final ArrayList<String> orderBy;
    private boolean distinct;
    private boolean havingApplied;
    private String having;
    private String limit;
    private boolean selectionApplied;
    private boolean useNativeSelection;
    private String selection;
    private String[] nativeSelectionArgs;
    @NotNull
    private final SQLiteDatabase db;
    @NotNull
    private final String tableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T exec(@NotNull Function1<? super Cursor, ? extends T> f) {
        Object object;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Cursor cursor = this.execInternal();
        try {
            Cursor it = cursor;
            object = f.invoke((Object)cursor);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e$iv) {}
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T parseSingle(@NotNull RowParser<T> parser) {
        T t;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor$iv = this.execInternal();
        try {
            Cursor it = cursor$iv;
            t = SqlParsersKt.parseSingle(it, parser);
        }
        finally {
            try {
                cursor$iv.close();
            }
            catch (Exception e$iv) {}
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T parseOpt(@NotNull RowParser<T> parser) {
        T t;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor$iv = this.execInternal();
        try {
            Cursor it = cursor$iv;
            t = SqlParsersKt.parseOpt(it, parser);
        }
        finally {
            try {
                cursor$iv.close();
            }
            catch (Exception e$iv) {}
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> List<T> parseList(@NotNull RowParser<T> parser) {
        List<T> list;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor$iv = this.execInternal();
        try {
            Cursor it = cursor$iv;
            list = SqlParsersKt.parseList(it, parser);
        }
        finally {
            try {
                cursor$iv.close();
            }
            catch (Exception e$iv) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T parseSingle(@NotNull MapRowParser<T> parser) {
        T t;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor$iv = this.execInternal();
        try {
            Cursor it = cursor$iv;
            t = SqlParsersKt.parseSingle(it, parser);
        }
        finally {
            try {
                cursor$iv.close();
            }
            catch (Exception e$iv) {}
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T parseOpt(@NotNull MapRowParser<T> parser) {
        T t;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor$iv = this.execInternal();
        try {
            Cursor it = cursor$iv;
            t = SqlParsersKt.parseOpt(it, parser);
        }
        finally {
            try {
                cursor$iv.close();
            }
            catch (Exception e$iv) {}
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> List<T> parseList(@NotNull MapRowParser<T> parser) {
        List<T> list;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor$iv = this.execInternal();
        try {
            Cursor it = cursor$iv;
            list = SqlParsersKt.parseList(it, parser);
        }
        finally {
            try {
                cursor$iv.close();
            }
            catch (Exception e$iv) {}
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Cursor execInternal() {
        void $receiver$iv;
        String finalSelection = this.selectionApplied ? this.selection : (String)null;
        String[] finalSelectionArgs = this.selectionApplied && this.useNativeSelection ? this.nativeSelectionArgs : (String[])null;
        Collection collection = this.columns;
        String string = this.tableName;
        boolean bl = this.distinct;
        SQLiteDatabase sQLiteDatabase = this.db;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v0;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = stringArray;
        Cursor cursor = sQLiteDatabase.query(bl, string, (String[])objectArray, finalSelection, finalSelectionArgs, CollectionsKt.joinToString$default((Iterable)this.groupBy, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), this.having, CollectionsKt.joinToString$default((Iterable)this.orderBy, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), this.limit);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"db.query(distinct, table\u2026oinToString(\", \"), limit)");
        return cursor;
    }

    @NotNull
    public final SelectQueryBuilder distinct() {
        this.distinct = true;
        return this;
    }

    @NotNull
    public final SelectQueryBuilder column(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.columns.add(name);
        return this;
    }

    @NotNull
    public final SelectQueryBuilder groupBy(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.groupBy.add(value);
        return this;
    }

    @NotNull
    public final SelectQueryBuilder orderBy(@NotNull String value, @NotNull SqlOrderDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        if (Intrinsics.areEqual((Object)((Object)direction), (Object)((Object)SqlOrderDirection.DESC))) {
            this.orderBy.add(value + " DESC");
        } else {
            this.orderBy.add(value);
        }
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SelectQueryBuilder orderBy$default(SelectQueryBuilder selectQueryBuilder, String string, SqlOrderDirection sqlOrderDirection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: orderBy");
        }
        if ((n & 2) != 0) {
            sqlOrderDirection = SqlOrderDirection.ASC;
        }
        return selectQueryBuilder.orderBy(string, sqlOrderDirection);
    }

    @NotNull
    public final SelectQueryBuilder limit(int count) {
        this.limit = String.valueOf(count);
        return this;
    }

    @NotNull
    public final SelectQueryBuilder limit(int offset, int count) {
        this.limit = offset + ", " + count;
        return this;
    }

    @NotNull
    public final SelectQueryBuilder columns(String ... names) {
        Intrinsics.checkParameterIsNotNull((Object)names, (String)"names");
        CollectionsKt.addAll((Collection)this.columns, (Object[])names);
        return this;
    }

    @NotNull
    public final SelectQueryBuilder having(@NotNull String having) {
        Intrinsics.checkParameterIsNotNull((Object)having, (String)"having");
        if (this.havingApplied) {
            throw (Throwable)new AnkoException("Query having was already applied.");
        }
        this.havingApplied = true;
        this.having = having;
        return this;
    }

    @NotNull
    public final SelectQueryBuilder having(@NotNull String having, Pair<String, ? extends Object> ... args) {
        Intrinsics.checkParameterIsNotNull((Object)having, (String)"having");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        if (this.selectionApplied) {
            throw (Throwable)new AnkoException("Query having was already applied.");
        }
        this.havingApplied = true;
        this.having = DatabaseKt.applyArguments(having, Arrays.copyOf(args, args.length));
        return this;
    }

    @NotNull
    public final SelectQueryBuilder where(@NotNull String select, Pair<String, ? extends Object> ... args) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        if (this.selectionApplied) {
            throw (Throwable)new AnkoException("Query selection was already applied.");
        }
        this.selectionApplied = true;
        this.useNativeSelection = false;
        this.selection = DatabaseKt.applyArguments(select, Arrays.copyOf(args, args.length));
        return this;
    }

    @NotNull
    public final SelectQueryBuilder where(@NotNull String select) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        if (this.selectionApplied) {
            throw (Throwable)new AnkoException("Query selection was already applied.");
        }
        this.selectionApplied = true;
        this.useNativeSelection = false;
        this.selection = select;
        return this;
    }

    @NotNull
    public final SelectQueryBuilder whereSimple(@NotNull String select, String ... args) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (this.selectionApplied) {
            throw (Throwable)new AnkoException("Query selection was already applied.");
        }
        this.selectionApplied = true;
        this.useNativeSelection = true;
        this.selection = select;
        this.nativeSelectionArgs = args;
        return this;
    }

    @Deprecated(message="Use whereSimple() instead", replaceWith=@ReplaceWith(imports={}, expression="whereSimple(select, *args)"))
    @NotNull
    public final SelectQueryBuilder whereSupport(@NotNull String select, String ... args) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return this.whereSimple(select, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public final SQLiteDatabase getDb() {
        return this.db;
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    public SelectQueryBuilder(@NotNull SQLiteDatabase db, @NotNull String tableName) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        this.db = db;
        this.tableName = tableName;
        this.columns = CollectionsKt.arrayListOf((Object[])new String[0]);
        this.groupBy = CollectionsKt.arrayListOf((Object[])new String[0]);
        this.orderBy = CollectionsKt.arrayListOf((Object[])new String[0]);
    }
}

