/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.anko.db;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.anko.db.SelectQueryBuilder;
import org.jetbrains.anko.db.SqlType;
import org.jetbrains.anko.db.TransactionAbortException;
import org.jetbrains.anko.db.UpdateQueryBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aA\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\u0010\t\u001a$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\nH\u0000\u001aM\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00102*\u0010\u0011\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0007\u00a2\u0006\u0002\u0010\u0013\u001aM\u0010\u0014\u001a\u00020\u0015*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u0016\u001a\u001c\u0010\u0017\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0010\u001aC\u0010\u0019\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032*\u0010\u001b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u001c\u001aC\u0010\u001d\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032*\u0010\u001b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u001c\u001aC\u0010\u001e\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032*\u0010\u001b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u001c\u001aC\u0010\u001f\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032*\u0010\u001b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u001c\u001a\u0012\u0010 \u001a\u00020!*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003\u001a+\u0010 \u001a\u00020!*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\"\u00020\u0003\u00a2\u0006\u0002\u0010\"\u001a%\u0010#\u001a\u00020$*\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006H\u0000\u00a2\u0006\u0002\u0010%\u001a#\u0010&\u001a\u00020\f*\u00020\r2\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\f0(\u00a2\u0006\u0002\b)\u001aC\u0010*\u001a\u00020+*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032*\u0010\u001b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010,\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"ARG_PATTERN", "Ljava/util/regex/Pattern;", "applyArguments", "", "whereClause", "args", "", "Lkotlin/Pair;", "", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "", "createTable", "", "Landroid/database/sqlite/SQLiteDatabase;", "tableName", "ifNotExists", "", "columns", "Lorg/jetbrains/anko/db/SqlType;", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Z[Lkotlin/Pair;)V", "delete", "", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;Ljava/lang/String;[Lkotlin/Pair;)I", "dropTable", "ifExists", "insert", "", "values", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;[Lkotlin/Pair;)J", "insertOrThrow", "replace", "replaceOrThrow", "select", "Lorg/jetbrains/anko/db/SelectQueryBuilder;", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/anko/db/SelectQueryBuilder;", "toContentValues", "Landroid/content/ContentValues;", "([Lkotlin/Pair;)Landroid/content/ContentValues;", "transaction", "code", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "update", "Lorg/jetbrains/anko/db/UpdateQueryBuilder;", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;[Lkotlin/Pair;)Lorg/jetbrains/anko/db/UpdateQueryBuilder;", "sqlite-compileReleaseKotlin"})
public final class DatabaseKt {
    private static final Pattern ARG_PATTERN;

    public static final long insert(SQLiteDatabase $receiver, @NotNull String tableName, Pair<String, ? extends Object> ... values) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return $receiver.insert(tableName, (String)null, DatabaseKt.toContentValues(values));
    }

    public static final long insertOrThrow(SQLiteDatabase $receiver, @NotNull String tableName, Pair<String, ? extends Object> ... values) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return $receiver.insertOrThrow(tableName, (String)null, DatabaseKt.toContentValues(values));
    }

    public static final long replace(SQLiteDatabase $receiver, @NotNull String tableName, Pair<String, ? extends Object> ... values) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return $receiver.replace(tableName, (String)null, DatabaseKt.toContentValues(values));
    }

    public static final long replaceOrThrow(SQLiteDatabase $receiver, @NotNull String tableName, Pair<String, ? extends Object> ... values) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return $receiver.replaceOrThrow(tableName, (String)null, DatabaseKt.toContentValues(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transaction(SQLiteDatabase $receiver, @NotNull Function1<? super SQLiteDatabase, Unit> code) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(code, (String)"code");
        try {
            $receiver.beginTransaction();
            code.invoke((Object)$receiver);
            $receiver.setTransactionSuccessful();
        }
        catch (TransactionAbortException transactionAbortException) {
        }
        finally {
            $receiver.endTransaction();
        }
    }

    @NotNull
    public static final SelectQueryBuilder select(SQLiteDatabase $receiver, @NotNull String tableName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        return new SelectQueryBuilder($receiver, tableName);
    }

    @NotNull
    public static final SelectQueryBuilder select(SQLiteDatabase $receiver, @NotNull String tableName, String ... columns) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull((Object)columns, (String)"columns");
        SelectQueryBuilder builder = new SelectQueryBuilder($receiver, tableName);
        builder.columns(Arrays.copyOf(columns, columns.length));
        return builder;
    }

    @NotNull
    public static final UpdateQueryBuilder update(SQLiteDatabase $receiver, @NotNull String tableName, Pair<String, ? extends Object> ... values) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        return new UpdateQueryBuilder($receiver, tableName, values);
    }

    public static final int delete(SQLiteDatabase $receiver, @NotNull String tableName, @NotNull String whereClause, Pair<String, ? extends Object> ... args) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull((Object)whereClause, (String)"whereClause");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        return $receiver.delete(tableName, DatabaseKt.applyArguments(whereClause, Arrays.copyOf(args, args.length)), (String[])null);
    }

    public static /* bridge */ /* synthetic */ int delete$default(SQLiteDatabase sQLiteDatabase, String string, String string2, Pair[] pairArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: delete");
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        return DatabaseKt.delete(sQLiteDatabase, string, string2, pairArray);
    }

    /*
     * WARNING - void declaration
     */
    public static final void createTable(SQLiteDatabase $receiver, @NotNull String tableName, boolean ifNotExists, Pair<String, ? extends SqlType> ... columns) {
        List list;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        String escapedTableName = StringsKt.replace$default((String)tableName, (String)"`", (String)"``", (boolean)false, (int)4, null);
        String ifNotExistsText = ifNotExists ? "IF NOT EXISTS" : "";
        Object[] objectArray = columns;
        SQLiteDatabase sQLiteDatabase = $receiver;
        void var7_8 = $receiver$iv;
        Collection collection = new ArrayList(((void)$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void col;
            void item$iv$iv = $receiver$iv$iv[i];
            Pair pair = (Pair)item$iv$iv;
            list = destination$iv$iv;
            String string = (String)col.getFirst() + " " + (SqlType)col.getSecond();
            list.add(string);
        }
        list = (List)destination$iv$iv;
        sQLiteDatabase.execSQL(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", (CharSequence)("CREATE TABLE " + ifNotExistsText + " `" + escapedTableName + "`("), (CharSequence)");", (int)0, null, null, (int)56, null));
    }

    public static /* bridge */ /* synthetic */ void createTable$default(SQLiteDatabase sQLiteDatabase, String string, boolean bl, Pair[] pairArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTable");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        DatabaseKt.createTable(sQLiteDatabase, string, bl, pairArray);
    }

    public static final void dropTable(SQLiteDatabase $receiver, @NotNull String tableName, boolean ifExists) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        String escapedTableName = StringsKt.replace$default((String)tableName, (String)"`", (String)"``", (boolean)false, (int)4, null);
        String ifExistsText = ifExists ? "IF EXISTS" : "";
        $receiver.execSQL("DROP TABLE " + ifExistsText + " `" + escapedTableName + "`;");
    }

    public static /* bridge */ /* synthetic */ void dropTable$default(SQLiteDatabase sQLiteDatabase, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dropTable");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        DatabaseKt.dropTable(sQLiteDatabase, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String applyArguments(@NotNull String whereClause, Pair<String, ? extends Object> ... args) {
        void $receiver$iv;
        void initial$iv;
        Intrinsics.checkParameterIsNotNull((Object)whereClause, (String)"whereClause");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Object[] objectArray = args;
        HashMap hashMap = MapsKt.hashMapOf((Pair[])new Pair[0]);
        HashMap accumulator$iv = initial$iv;
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            void arg;
            void element$iv = $receiver$iv[i];
            Pair pair = (Pair)element$iv;
            HashMap map = accumulator$iv;
            map.put(arg.getFirst(), arg.getSecond());
            accumulator$iv = map;
        }
        HashMap argsMap = accumulator$iv;
        return DatabaseKt.applyArguments(whereClause, argsMap);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String applyArguments(@NotNull String whereClause, @NotNull Map<String, ? extends Object> args) {
        Intrinsics.checkParameterIsNotNull((Object)whereClause, (String)"whereClause");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Matcher matcher = ARG_PATTERN.matcher(whereClause);
        StringBuffer buffer = new StringBuffer(whereClause.length());
        while (matcher.find()) {
            String string;
            Object value;
            String key = matcher.group(2);
            if (args.get(key) == null) {
                throw (Throwable)new IllegalStateException("Can't find a value for key " + key);
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Byte || value instanceof Short) {
                string = value.toString();
            } else if (value instanceof Boolean) {
                string = ((Boolean)value).booleanValue() ? "1" : "0";
            } else if (value instanceof Float || value instanceof Double) {
                string = value.toString();
            } else {
                void other$iv;
                void $receiver$iv;
                int n = 39;
                String string2 = StringsKt.replace$default((String)value.toString(), (String)"'", (String)"''", (boolean)false, (int)4, null);
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = String.valueOf((char)$receiver$iv) + (String)other$iv;
                string = stringBuilder.append(string3).append('\'').toString();
            }
            String valueString = string;
            matcher.appendReplacement(buffer, matcher.group(1) + valueString);
        }
        matcher.appendTail(buffer);
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public static final ContentValues toContentValues(Pair<String, ? extends Object>[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ContentValues values = new ContentValues();
        for (int i = 0; i < $receiver.length; ++i) {
            Pair<String, ? extends Object> pair = $receiver[i];
            String key = (String)pair.component1();
            Object value = pair.component2();
            Object object = value;
            if (object instanceof Boolean) {
                values.put(key, (Boolean)value);
                continue;
            }
            if (object instanceof Byte) {
                values.put(key, (Byte)value);
                continue;
            }
            if (object instanceof byte[]) {
                values.put(key, (byte[])value);
                continue;
            }
            if (object instanceof Double) {
                values.put(key, (Double)value);
                continue;
            }
            if (object instanceof Float) {
                values.put(key, (Float)value);
                continue;
            }
            if (object instanceof Integer) {
                values.put(key, (Integer)value);
                continue;
            }
            if (object instanceof Long) {
                values.put(key, (Long)value);
                continue;
            }
            if (object instanceof Short) {
                values.put(key, (Short)value);
                continue;
            }
            if (object instanceof String) {
                values.put(key, (String)value);
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Non-supported value type: " + value.getClass().getName());
        }
        return values;
    }

    static {
        Pattern pattern = Pattern.compile("([^\\\\])\\{([^\\{}]+)\\}");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"([^\\\\\\\\])\\\\{([^\\\\{}]+)\\\\}\")");
        ARG_PATTERN = pattern;
    }
}

