/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.anko.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Deprecated;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.anko.AnkoException;
import org.jetbrains.anko.db.DatabaseKt;
import org.jetbrains.anko.db.MapRowParser;
import org.jetbrains.anko.db.RowParser;
import org.jetbrains.anko.db.SqlOrderDirection;
import org.jetbrains.anko.db.SqlParsersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"i\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0017)\u0011\u0001\"\u0002\u0006\u0003!EQ!\u0001\u0003\b\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0005\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001C\u0005\u0019\u0001I\u0012\u0001'\u0001\"\u0016%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015:\u0001\"D\u0007\u00021\u0001I2\u0001c\u0007\u000e\u0003a\u0015Qu\u0004E\u0004\u001b\u0005A\u0002!G\u0005\t\u001d5)\u0011b\u0001C\u0001\u0013\u0005A*\u0001G\u0005\u0012\u0003a\u0015\u0011kA\u0001\t\u001e\u0015\u001a\u00012B\u0007\u00021\u0001)S\u0003C\b\u000e\u0003\u0011~\u0011C\u0001\u0003\u0001\u0011?I:\u0002\u0003\t\u000e\u0014%\u0011\u0011\"\u0001\r\u0012\u0013\tI\u0011\u0001j\b\u0019\"E\u001b\u0011\u0001b\tR\u0007\u0005A!#\n\u0003\u0005\u0003!\u0015R\"\u0001\r\u0012K\u001dAi!D\u0001\u0019\u0001e\u0019\u0001bE\u0007\u00021\u000b)s\u0001C\u0004\u000e\u0003a\u0001\u0011d\u0001\u0005\b\u001b\u0005A*!j\u0010\t\u000f5\t\u0001\u0004A\r\u0004\u0011\u001di\u0011\u0001'\u0002\u001a+!\u001dRbC\u0005\n\t\u0003Iq!\u0003\u0002\n\u0003a\u0015\u0011BA\u0005\u00021\u0003AB\u0003G\u0005\u0012\u000f%\u0011\u0011\"\u0001M\u0003\u0013\tI\u0011\u0001'\u0001\u0019)E\u001b\u0011\u0001#\u000b&\u000f!AQ\"\u0001\r\u00013\rAQ#D\u0001\u0019,\u0015Z\u0001\u0002C\u0007\u00021\u0001I2\u0001\u0003\f\u000e\u0003a-\u0012d\u0001\u0005\u0016\u001b\u0005AZ#\n\u0007\t\u00155\t\u0001\u0004A\r\u0004\u0011Mi\u0011\u0001'\u0002\u001a\t\u0011\t\u0001RF\u0007\u00021])#\u0003c\f\u000e\t%\u0011\u0011\"\u0001S\u00101a\tB\u0001\u0002\u0001\t U\t\u0001\u0014A\r\u0007\u0011ciA!\u0003\u0002\n\u0003\u0011~\u0001$G\u0013\u0013\u0011_iA!\u0003\u0002\n\u0003\u0011~\u0001\u0004G\t\u0005\t\u0001Ay\"F\u0001\u0019\u0002e1\u0001\u0012G\u0007\u0005\u0013\tI\u0011\u0001j\b\u00194\u0015\u0016\u0002BG\u0007\u0003\u0019\u0003!{\"\u0005\u0003\u0005\u0001!}Q#\u0001M\u00013\u0019A\t$\u0004\u0003\n\u0005%\tAu\u0004\r\u001a#\u000e\t\u0001RGS\u0013\u0011ii!\u0001$\u0001% E!A\u0001\u0001E\u0010+\u0005A\n!\u0007\u0004\t25!\u0011BA\u0005\u0002I?A\u001a$U\u0002\u0002\u0011m)\u001b\u0003c\u000e\u000e\u0003\u0011~\u0011\u0003\u0002\u0003\u0001\u0011?)\u0012\u0001'\u0001\u001a\r!ER\u0002B\u0005\u0003\u0013\u0005!{\u0002G\rR\u0007\u0005A)$j\t\t85\tAuD\t\u0005\t\u0001Ay\"F\u0001\u0019\u0002e1\u0001\u0012G\u0007\u0005\u0013\tI\u0011\u0001j\b\u00194E\u001b\u0011\u0001C\u000e&\u000f!aR\"\u0001\r\u00013\rAI$D\u0001\u0019\u0006\u0015~\u0002\u0002H\u0007\u00021\u0001I2\u0001#\u000f\u000e\u0003a\u0015\u0011$\u0006E\u0014\u001b-I\u0011\u0002\"\u0001\n\u000f%\u0011\u0011\"\u0001M\u0003\u0013\tI\u0011\u0001'\u0001\u0019)aI\u0011cB\u0005\u0003\u0013\u0005A*!\u0003\u0002\n\u0003a\u0005\u0001\u0004F)\u0004\u0003!%Ru\u0005\u0005\u001e\u001b\u0005A\u0002!G\u0002\t:5\t\u0001TA\r\n\u0011OiQ!C\u0002\u0005\u0002%\t\u0001T\u0001\r\n#\u0005A*!U\u0002\u0002\u0011w)K\u0003b\u0002\t=5\t\u0001\u0004A\r\u0004\u0011si\u0011\u0001'\u0002\u001a\u0013!\u001dR\"B\u0005\u0004\t\u0003I\u0011\u0001'\u0002\u0019\u0013E\t\u0001TA)\u0004\u0003!m\u0012F\u0003\u0003B\u0011!\u001dQ\u0002B\u0005\u0003\u0013\u0005A*\u0001\u0007\u0003R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0007\"A\u0011!D\u0001\u0019\u0004E\u001bA!\u0002\u0001\u000e\u0005\u0011%\u0001\"B\u0015\b\t\u0005c\u00022B\u0007\u00021\u0019\t6!A\u0003\u0001S)!\u0011\t\u0003E\u0007\u001b\u0011I!!C\u0001\u0019\u0006a!\u0011kA\u0001\u0006\u0001%BA!\u0011\u000f\t\u000f5\u0011A\u0012\u0001M\u0003#\u000e\tQ\u0001A\u0015\b\t\u0005c\u0002rB\u0007\u00021\u0019\t6!A\u0003\u0001S!!\u0011\t\b\u0005\t\u001b\ta\t\u0001'\u0002R\u0007\u0005)\u0001!K\u0007\u0005\u0003rA\t\"\u0004\u0004\n\u0007\u0011\u0005\u0011\"\u0001M\u0003\u0019\u0003A\u0012\"U\u0002\u0003\u000b\u0005A\u0019\"\u000b\u0006\u0005\u0003\"A!\"\u0004\u0003\n\u0005%\t\u0001T\u0001\r\u0005#\u000e\tQ\u0001A\u0015\t\t\u0005c\u0002RC\u0007\u0003\u0019\u0003A*!U\u0002\u0002\u000b\u0001Is\u0001B!\u001d\u0011-i\u0011\u0001\u0007\u0004R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0007\"A!!D\u0001\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011]\u0001\u0002D\u0015\b\t\u0005c\u0002\u0012D\u0007\u00021\u0019\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/anko/db/SelectQueryBuilder;", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "tableName", "", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;)V", "columns", "Ljava/util/ArrayList;", "getDb", "()Landroid/database/sqlite/SQLiteDatabase;", "distinct", "", "groupBy", "having", "havingApplied", "limit", "nativeSelectionArgs", "", "[Ljava/lang/String;", "orderBy", "selection", "selectionApplied", "getTableName", "()Ljava/lang/String;", "useNativeSelection", "column", "name", "names", "([Ljava/lang/String;)Lorg/jetbrains/anko/db/SelectQueryBuilder;", "exec", "T", "f", "Lkotlin/Function1;", "Landroid/database/Cursor;", "Lkotlin/Extension;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "execInternal", "value", "args", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Lorg/jetbrains/anko/db/SelectQueryBuilder;", "count", "", "offset", "direction", "Lorg/jetbrains/anko/db/SqlOrderDirection;", "parseList", "", "parser", "Lorg/jetbrains/anko/db/MapRowParser;", "Lorg/jetbrains/anko/db/RowParser;", "parseOpt", "(Lorg/jetbrains/anko/db/MapRowParser;)Ljava/lang/Object;", "(Lorg/jetbrains/anko/db/RowParser;)Ljava/lang/Object;", "parseSingle", "where", "select", "whereSimple", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/anko/db/SelectQueryBuilder;", "whereSupport"}, moduleName="sqlite-compileReleaseKotlin")
public final class SelectQueryBuilder {
    private final ArrayList<String> columns;
    private final ArrayList<String> groupBy;
    private final ArrayList<String> orderBy;
    private boolean distinct;
    private boolean havingApplied;
    private String having;
    private String limit;
    private boolean selectionApplied;
    private boolean useNativeSelection;
    private String selection;
    private String[] nativeSelectionArgs;
    @NotNull
    private final SQLiteDatabase db;
    @NotNull
    private final String tableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T exec(@NotNull Function1<? super Cursor, ? extends T> f) {
        Object object;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Cursor cursor = this.execInternal();
        try {
            Cursor it = cursor;
            object = f.invoke((Object)cursor);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {}
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T parseSingle(@NotNull RowParser<T> parser) {
        T t;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor = this.execInternal();
        try {
            Cursor it = cursor;
            t = SqlParsersKt.parseSingle(it, parser);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {}
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T parseOpt(@NotNull RowParser<T> parser) {
        T t;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor = this.execInternal();
        try {
            Cursor it = cursor;
            t = SqlParsersKt.parseOpt(it, parser);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {}
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> List<T> parseList(@NotNull RowParser<T> parser) {
        List<T> list;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor = this.execInternal();
        try {
            Cursor it = cursor;
            list = SqlParsersKt.parseList(it, parser);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T parseSingle(@NotNull MapRowParser<T> parser) {
        T t;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor = this.execInternal();
        try {
            Cursor it = cursor;
            t = SqlParsersKt.parseSingle(it, parser);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {}
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T parseOpt(@NotNull MapRowParser<T> parser) {
        T t;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor = this.execInternal();
        try {
            Cursor it = cursor;
            t = SqlParsersKt.parseOpt(it, parser);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {}
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> List<T> parseList(@NotNull MapRowParser<T> parser) {
        List<T> list;
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        Cursor cursor = this.execInternal();
        try {
            Cursor it = cursor;
            list = SqlParsersKt.parseList(it, parser);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Exception e) {}
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Cursor execInternal() {
        void $receiver;
        String finalSelection = this.selectionApplied ? this.selection : (String)null;
        String[] finalSelectionArgs = this.selectionApplied && this.useNativeSelection ? this.nativeSelectionArgs : (String[])null;
        Collection collection = this.columns;
        String string = this.tableName;
        boolean bl = this.distinct;
        SQLiteDatabase sQLiteDatabase = this.db;
        void v0 = $receiver;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection = (Collection)v0;
        String[] stringArray = thisCollection.toArray(new String[thisCollection.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = stringArray;
        Cursor cursor = sQLiteDatabase.query(bl, string, (String[])objectArray, finalSelection, finalSelectionArgs, CollectionsKt.joinToString$default((Iterable)this.groupBy, (CharSequence)", ", null, null, (int)0, null, null, (int)62), this.having, CollectionsKt.joinToString$default((Iterable)this.orderBy, (CharSequence)", ", null, null, (int)0, null, null, (int)62), this.limit);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"db.query(distinct, table\u2026oinToString(\", \"), limit)");
        return cursor;
    }

    @NotNull
    public final SelectQueryBuilder distinct() {
        this.distinct = true;
        return this;
    }

    @NotNull
    public final SelectQueryBuilder column(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.columns.add(name);
        return this;
    }

    @NotNull
    public final SelectQueryBuilder groupBy(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.groupBy.add(value);
        return this;
    }

    @NotNull
    public final SelectQueryBuilder orderBy(@NotNull String value, @NotNull SqlOrderDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        if (Intrinsics.areEqual((Object)((Object)direction), (Object)((Object)SqlOrderDirection.DESC))) {
            this.orderBy.add(value + " DESC");
        } else {
            this.orderBy.add(value);
        }
        return this;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SelectQueryBuilder orderBy$default(SelectQueryBuilder selectQueryBuilder, String string, SqlOrderDirection sqlOrderDirection, int n) {
        if ((n & 2) != 0) {
            sqlOrderDirection = SqlOrderDirection.ASC;
        }
        return selectQueryBuilder.orderBy(string, sqlOrderDirection);
    }

    @NotNull
    public final SelectQueryBuilder limit(int count) {
        this.limit = String.valueOf(count);
        return this;
    }

    @NotNull
    public final SelectQueryBuilder limit(int offset, int count) {
        this.limit = offset + ", " + count;
        return this;
    }

    @NotNull
    public final SelectQueryBuilder columns(String ... names) {
        Intrinsics.checkParameterIsNotNull((Object)names, (String)"names");
        CollectionsKt.addAll((Collection)this.columns, (Object[])names);
        return this;
    }

    @NotNull
    public final SelectQueryBuilder having(@NotNull String having) {
        Intrinsics.checkParameterIsNotNull((Object)having, (String)"having");
        if (this.havingApplied) {
            throw (Throwable)new AnkoException("Query having was already applied.");
        }
        this.havingApplied = true;
        this.having = having;
        return this;
    }

    @NotNull
    public final SelectQueryBuilder having(@NotNull String having, Pair<String, Object> ... args) {
        Intrinsics.checkParameterIsNotNull((Object)having, (String)"having");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        if (this.selectionApplied) {
            throw (Throwable)new AnkoException("Query having was already applied.");
        }
        this.havingApplied = true;
        this.having = DatabaseKt.applyArguments(having, Arrays.copyOf(args, args.length));
        return this;
    }

    @NotNull
    public final SelectQueryBuilder where(@NotNull String select, Pair<String, Object> ... args) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        if (this.selectionApplied) {
            throw (Throwable)new AnkoException("Query selection was already applied.");
        }
        this.selectionApplied = true;
        this.useNativeSelection = false;
        this.selection = DatabaseKt.applyArguments(select, Arrays.copyOf(args, args.length));
        return this;
    }

    @NotNull
    public final SelectQueryBuilder where(@NotNull String select) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        if (this.selectionApplied) {
            throw (Throwable)new AnkoException("Query selection was already applied.");
        }
        this.selectionApplied = true;
        this.useNativeSelection = false;
        this.selection = select;
        return this;
    }

    @NotNull
    public final SelectQueryBuilder whereSimple(@NotNull String select, String ... args) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (this.selectionApplied) {
            throw (Throwable)new AnkoException("Query selection was already applied.");
        }
        this.selectionApplied = true;
        this.useNativeSelection = true;
        this.selection = select;
        this.nativeSelectionArgs = args;
        return this;
    }

    @Deprecated(message="Use whereSimple() instead", replaceWith=@ReplaceWith(expression="whereSimple(select, *args)", imports={}))
    @NotNull
    public final SelectQueryBuilder whereSupport(@NotNull String select, String ... args) {
        Intrinsics.checkParameterIsNotNull((Object)select, (String)"select");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return this.whereSimple(select, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public final SQLiteDatabase getDb() {
        return this.db;
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    public SelectQueryBuilder(@NotNull SQLiteDatabase db, @NotNull String tableName) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
        this.db = db;
        this.tableName = tableName;
        this.columns = CollectionsKt.arrayListOf((Object[])new String[0]);
        this.groupBy = CollectionsKt.arrayListOf((Object[])new String[0]);
        this.orderBy = CollectionsKt.arrayListOf((Object[])new String[0]);
    }
}

