/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.anko.internals;

import android.app.Activity;
import android.app.Service;
import android.app.UiModeManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import java.io.Serializable;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.Locale;
import kotlin.ArraysKt;
import kotlin.Pair;
import kotlin.Range;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.anko.AnkoException;
import org.jetbrains.anko.Orientation;
import org.jetbrains.anko.ScreenSize;
import org.jetbrains.anko.UiHelper;
import org.jetbrains.anko.UiKt;
import org.jetbrains.anko.UiMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!EQ!\u0001\u0007\u0002\u000b\u0005Aq!B\u0001\u0005\u000e\u0015\t\u0001\u0002B\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rAaY\u0001\r\u0001e\t\u0001\u0014A\u000f\u0002G\u000f\n;\u0001B\u0001R\u0007\u0005A\u0011!*\n\t\u00045\t\u0001DA\t\u0005\t\u0001A)!F\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003\u0011\u0016\u0011kA\u0001\t\u000b\u0015\u0016\u00022A\u0007\u00021\t\tB\u0001\u0002\u0001\t\u0006U\t\u0001dA\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u0007!%Q\"\u0001S\u0003#\u000e\t\u0001RBS\u0013\u0011\u0007i\u0011\u0001\u0007\u0002\u0012\t\u0011\u0001\u0001RA\u000b\u00021\rI2\u0001C\u0004\u000e\u0003a=\u0011d\u0001E\u0005\u001b\u0005!+!U\u0002\u0002\u0011!);\u0005b\u0002\t\u00125\t\u0001$C\t\u0003\t\u0001A)!G\u0002\t\f5\t\u0001DB\r\b\u0011'iQ!C\u0002\u0005\u0002%\tAU\u0001\r\u000b35A)\"D\u0006\n\u0013\u0011\u0005\u0011bB\u0005\u0003\u0013\u0005AB\"\u0003\u0002\n\u0003a\u0005\u0001t\u0003\r\f#\u000e\t\u0001\u0012DS\u0019\t\u0007AQ\"D\u0001\u0019\u0005e\u0019\u00012D\u0007\u00021%IR\u0002#\u0006\u000e\u0017%IA\u0011A\u0005\b\u0013\tI\u0011\u0001\u0007\u0007\n\u0005%\t\u0001\u0014\u0001M\f1-\t6!\u0001\u0005\u000fK\u001dAi\"D\u0001\u0019\re\u0019\u0001bB\u0007\u00021\u001f)k\u0003b\u0002\t\u001f5\tAUA\t\u0005\t\u0001A)!F\u0001\u0019\u0007e\u0019\u00012B\u0007\u00021\u0019Ib\u0001c\b\u000e\t%\u0011\u0011\"\u0001S\u00031)\t6!\u0001\u0005\u0011K\u0003\"9\u0001#\t\u000e\u0003a\u0011\u0011d\u0001E\u0006\u001b\u0005Ab!G\u0004\t\b5)\u0011b\u0001C\u0001\u0013\u0005AB\u0001\u0007\u0006\u001a\u001b!UQbC\u0005\n\t\u0003Iq!\u0003\u0002\n\u0003aa\u0011BA\u0005\u00021\u0003A:\u0002G\u0006R\u0007\u0005A\u0011#*\u0013\u0005\b!\rR\"\u0001\r\u00033\rA!#D\u0001\u0019\te9\u0001rA\u0007\u0006\u0013\r!\t!C\u0001\u0019\taQ\u0011d\u0001E\u0013\u001b\u0005A2#G\u0007\t\u00165Y\u0011\"\u0003C\u0001\u0013\u001dI!!C\u0001\u0019\u0019%\u0011\u0011\"\u0001M\u00011/A2\"U\u0002\u0002\u0011O)\u000b\u0005b\u0002\t)5\t\u0001DA\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u000f!\u001dQ\"B\u0005\u0004\t\u0003I\u0011\u0001'\u000b\u0019\u0015ei\u0001RC\u0007\f\u0013%!\t!C\u0004\n\u0005%\t\u0001\u0004D\u0005\u0003\u0013\u0005A\n\u0001g\u0006\u0019\u0017E\u001b\u0011\u0001C\t&\n\u0004!9\u0001C\u000b\u000e\u0003a-\u0012d\u0001E\u0006\u001b\u0005Ab!\u0007\u0003\t-5\u0011A\u0012\u0001M\u00173\u001dAq#D\u0003\n\u0005%\t\u0001d\u0005G\u00011_IB\u0001\u0003\r\u000e\u00051\u0005\u0001\u0004D\r\u0005\u0011ci!\u0001$\u0001\u00193e!\u00012G\u0007\u0003\u0019\u0003AZ#\u0007\u0003\t55\u0011A\u0012\u0001\r\u00143\u0011A)$\u0004\u0002\r\u0002a\u0019\u0012\u0004\u0002\u0005\u001c\u001b\ta\t\u0001g\u000e\u001a\t!aRB\u0001G\u00011WIB\u0001#\u000f\u000e\u00051\u0005\u00014F\r\u0005\u0011ui!\u0001$\u0001\u0019'E\u001b\u0011\u0001c\u000f&1\u0011\u001d\u0005\u0003\u0003\u0010\u000e\u0003\u0011\u0016\u0011C\u0001\u0003\u0001\u0011\u000bI2\u0001#\u0010\u000e\u0003ay\u0012$\u0003E \u001b\u001dI!!C\u0001\u0019?%\u0011\u0011\"\u0001S\u00031\u0001\n6!\u0001E!Ka!9\t\u0005\u0005\"\u001b\u0005!+!\u0005\u0002\u0005\u0001!\u0015\u0011d\u0001E\"\u001b\u0005A\"%G\u0005\t@59\u0011BA\u0005\u00021\tJ!!C\u0001%\u0006a\u0001\u0013kA\u0001\tF\u0001"}, strings={"Lorg/jetbrains/anko/internals/AnkoInternals;", "", "()V", "addView", "", "T", "Landroid/view/View;", "activity", "Landroid/app/Activity;", "view", "(Landroid/app/Activity;Landroid/view/View;)V", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;Landroid/view/View;)V", "manager", "Landroid/view/ViewManager;", "(Landroid/view/ViewManager;Landroid/view/View;)V", "createIntent", "Landroid/content/Intent;", "clazz", "Ljava/lang/Class;", "params", "", "Lkotlin/Pair;", "", "(Landroid/content/Context;Ljava/lang/Class;[Lkotlin/Pair;)Landroid/content/Intent;", "fillIntentArguments", "intent", "(Landroid/content/Intent;[Lkotlin/Pair;)V", "getContext", "initiateView", "viewClass", "(Landroid/content/Context;Ljava/lang/Class;)Landroid/view/View;", "internalStartActivity", "(Landroid/content/Context;Ljava/lang/Class;[Lkotlin/Pair;)V", "internalStartActivityForResult", "act", "requestCode", "", "(Landroid/app/Activity;Ljava/lang/Class;I[Lkotlin/Pair;)V", "internalStartService", "Landroid/app/Service;", "testConfiguration", "", "screenSize", "Lorg/jetbrains/anko/ScreenSize;", "density", "Lkotlin/Range;", "language", "orientation", "Lorg/jetbrains/anko/Orientation;", "long", "fromSdk", "sdk", "uiMode", "Lorg/jetbrains/anko/UiMode;", "nightMode", "rightToLeft", "smallestWidth", "(Landroid/content/Context;Lorg/jetbrains/anko/ScreenSize;Lkotlin/Range;Ljava/lang/String;Lorg/jetbrains/anko/Orientation;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Lorg/jetbrains/anko/UiMode;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;)Z", "useCursor", "cursor", "Landroid/database/Cursor;", "f", "Lkotlin/Function1;", "(Landroid/database/Cursor;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "useDatabase", "db", "Landroid/database/sqlite/SQLiteDatabase;", "(Landroid/database/sqlite/SQLiteDatabase;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "InternalConfiguration", "NoBinding"}, moduleName="common-compileReleaseKotlin")
public final class AnkoInternals {
    public static final AnkoInternals INSTANCE;
    public static final AnkoInternals INSTANCE$;

    public final <T extends View> void addView(@NotNull ViewManager manager, @NotNull T view) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(view, (String)"view");
        ViewManager viewManager = manager;
        if (viewManager instanceof ViewGroup) {
            ((ViewGroup)manager).addView(view);
        } else if (viewManager instanceof UiHelper) {
            ((UiHelper)manager).addView(view, null);
        } else {
            throw (Throwable)new AnkoException(manager + " is the wrong parent");
        }
    }

    public final <T extends View> void addView(@NotNull Context ctx, @NotNull T view) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull(view, (String)"view");
        UiKt.UI(ctx, (Function1<? super UiHelper, ? extends Unit>)((Function1)new Function1<UiHelper, Unit>(view){
            final /* synthetic */ View $view;

            public final void invoke(UiHelper $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                AnkoInternals.INSTANCE.addView($receiver, this.$view);
            }
            {
                this.$view = view;
                super(1);
            }
        }));
    }

    public final <T extends View> void addView(@NotNull Activity activity, @NotNull T view) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull(view, (String)"view");
        UiKt.UI(activity, (Function1<? super UiHelper, ? extends Unit>)((Function1)new Function1<UiHelper, Unit>(view){
            final /* synthetic */ View $view;

            public final void invoke(UiHelper $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                AnkoInternals.INSTANCE.addView($receiver, this.$view);
            }
            {
                this.$view = view;
                super(1);
            }
        }));
    }

    @NotNull
    public final Context getContext(@NotNull ViewManager manager) {
        Context context;
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        ViewManager viewManager = manager;
        if (viewManager instanceof ViewGroup) {
            Context context2 = ((ViewGroup)manager).getContext();
            context = context2;
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"manager.context");
        } else if (viewManager instanceof UiHelper) {
            context = ((UiHelper)manager).getCtx();
        } else {
            throw (Throwable)new AnkoException(manager + " is the wrong parent");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"when (manager) {\n       \u2026 the wrong parent\")\n    }");
        return context;
    }

    @JvmStatic
    @NotNull
    public static final <T> Intent createIntent(@NotNull Context ctx, @NotNull Class<? extends T> clazz, @NotNull Pair<String, Object>[] params) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intent intent = new Intent(ctx, clazz);
        if (ArraysKt.isNotEmpty((Object[])params)) {
            AnkoInternals.fillIntentArguments(intent, params);
        }
        return intent;
    }

    @JvmStatic
    public static final void internalStartActivity(@NotNull Context ctx, @NotNull Class<? extends Activity> activity, @NotNull Pair<String, Object>[] params) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull(activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        ctx.startActivity(AnkoInternals.createIntent(ctx, activity, params));
    }

    @JvmStatic
    public static final void internalStartActivityForResult(@NotNull Activity act, @NotNull Class<? extends Activity> activity, int requestCode, @NotNull Pair<String, Object>[] params) {
        Intrinsics.checkParameterIsNotNull((Object)act, (String)"act");
        Intrinsics.checkParameterIsNotNull(activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        act.startActivityForResult(AnkoInternals.createIntent((Context)act, activity, params), requestCode);
    }

    @JvmStatic
    public static final void internalStartService(@NotNull Context ctx, @NotNull Class<? extends Service> activity, @NotNull Pair<String, Object>[] params) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull(activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        ctx.startService(AnkoInternals.createIntent(ctx, activity, params));
    }

    @JvmStatic
    private static final void fillIntentArguments(Intent intent, Pair<String, Object>[] params) {
        Object[] $receiver = params;
        for (int i = 0; i < $receiver.length; ++i) {
            Object element = $receiver[i];
            Pair it = (Pair)element;
            Object value = it.getSecond();
            Object object = value;
            if (object instanceof Integer) {
                intent.putExtra((String)it.getFirst(), ((Number)value).intValue());
                continue;
            }
            if (object instanceof Long) {
                intent.putExtra((String)it.getFirst(), ((Number)value).longValue());
                continue;
            }
            if (object instanceof CharSequence) {
                intent.putExtra((String)it.getFirst(), (CharSequence)value);
                continue;
            }
            if (object instanceof String) {
                intent.putExtra((String)it.getFirst(), (String)value);
                continue;
            }
            if (object instanceof Float) {
                intent.putExtra((String)it.getFirst(), ((Number)value).floatValue());
                continue;
            }
            if (object instanceof Double) {
                intent.putExtra((String)it.getFirst(), ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Character) {
                intent.putExtra((String)it.getFirst(), ((Character)value).charValue());
                continue;
            }
            if (object instanceof Short) {
                intent.putExtra((String)it.getFirst(), ((Number)value).shortValue());
                continue;
            }
            if (object instanceof Boolean) {
                intent.putExtra((String)it.getFirst(), ((Boolean)value).booleanValue());
                continue;
            }
            if (object instanceof Serializable) {
                intent.putExtra((String)it.getFirst(), (Serializable)value);
                continue;
            }
            if (object instanceof Bundle) {
                intent.putExtra((String)it.getFirst(), (Bundle)value);
                continue;
            }
            if (object instanceof Parcelable) {
                intent.putExtra((String)it.getFirst(), (Parcelable)value);
                continue;
            }
            if (object instanceof Object[]) {
                if ((Object[])value instanceof CharSequence[]) {
                    intent.putExtra((String)it.getFirst(), (Serializable)value);
                    continue;
                }
                if ((Object[])value instanceof String[]) {
                    intent.putExtra((String)it.getFirst(), (Serializable)value);
                    continue;
                }
                if ((Object[])value instanceof Parcelable[]) {
                    intent.putExtra((String)it.getFirst(), (Serializable)value);
                    continue;
                }
                throw (Throwable)new AnkoException("Intent extra " + (String)it.getFirst() + " has wrong type " + ((Object[])value).getClass().getName());
            }
            if (object instanceof int[]) {
                intent.putExtra((String)it.getFirst(), (int[])value);
                continue;
            }
            if (object instanceof long[]) {
                intent.putExtra((String)it.getFirst(), (long[])value);
                continue;
            }
            if (object instanceof float[]) {
                intent.putExtra((String)it.getFirst(), (float[])value);
                continue;
            }
            if (object instanceof double[]) {
                intent.putExtra((String)it.getFirst(), (double[])value);
                continue;
            }
            if (object instanceof char[]) {
                intent.putExtra((String)it.getFirst(), (char[])value);
                continue;
            }
            if (object instanceof short[]) {
                intent.putExtra((String)it.getFirst(), (short[])value);
                continue;
            }
            if (object instanceof boolean[]) {
                intent.putExtra((String)it.getFirst(), (boolean[])value);
                continue;
            }
            throw (Throwable)new AnkoException("Intent extra " + (String)it.getFirst() + " has wrong type " + value.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final <T> T useDatabase(@NotNull SQLiteDatabase db, @NotNull Function1<? super SQLiteDatabase, ? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        try {
            Object object = f.invoke((Object)db);
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            try {
                db.close();
            }
            catch (Exception e) {}
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final <T> T useCursor(@NotNull Cursor cursor, @NotNull Function1<? super Cursor, ? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)cursor, (String)"cursor");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        try {
            Object object = f.invoke((Object)cursor);
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            try {
                cursor.close();
            }
            catch (Exception e) {}
            InlineMarker.finallyEnd((int)1);
        }
    }

    @JvmStatic
    @NotNull
    public static final <T extends View> T initiateView(@NotNull Context ctx, @NotNull Class<T> viewClass) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull(viewClass, (String)"viewClass");
        Function0 getConstructor1$ = new Function0<Constructor<T>>(viewClass){
            final /* synthetic */ Class $viewClass;

            public final Constructor<T> invoke() {
                return this.$viewClass.getConstructor(Context.class);
            }
            {
                this.$viewClass = clazz;
                super(0);
            }
        };
        Function0 getConstructor2$ = new Function0<Constructor<T>>(viewClass){
            final /* synthetic */ Class $viewClass;

            public final Constructor<T> invoke() {
                return this.$viewClass.getConstructor(Context.class, AttributeSet.class);
            }
            {
                this.$viewClass = clazz;
                super(0);
            }
        };
        try {
            View view = (View)((Constructor)getConstructor1$.invoke()).newInstance(ctx);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getConstructor1().newInstance(ctx)");
            return (T)view;
        }
        catch (NoSuchMethodException e) {
            try {
                View view = (View)((Constructor)getConstructor2$.invoke()).newInstance(ctx, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getConstructor2().newInstance(ctx, null)");
                return (T)view;
            }
            catch (NoSuchMethodException e2) {
                throw (Throwable)new AnkoException("Can't initiate View of class " + viewClass.getName() + ": can't find proper constructor");
            }
        }
    }

    @JvmStatic
    public static final boolean testConfiguration(@NotNull Context ctx, @Nullable ScreenSize screenSize, @Nullable Range<Integer> density, @Nullable String language, @Nullable Orientation orientation, @Nullable Boolean bl, @Nullable Integer fromSdk, @Nullable Integer sdk, @Nullable UiMode uiMode, @Nullable Boolean nightMode, @Nullable Boolean rightToLeft, @Nullable Integer smallestWidth) {
        Configuration config;
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Resources resources = ctx.getResources();
        Object object = config = resources != null ? resources.getConfiguration() : null;
        if (screenSize != null) {
            if (config == null) {
                return false;
            }
            int currentScreenSize = config.screenLayout & 0xF;
            switch (currentScreenSize) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!(Intrinsics.areEqual((Object)((Object)screenSize), (Object)((Object)ScreenSize.SMALL)) ^ true)) break;
                    return false;
                }
                case 2: {
                    if (!(Intrinsics.areEqual((Object)((Object)screenSize), (Object)((Object)ScreenSize.NORMAL)) ^ true)) break;
                    return false;
                }
                case 3: {
                    if (!(Intrinsics.areEqual((Object)((Object)screenSize), (Object)((Object)ScreenSize.LARGE)) ^ true)) break;
                    return false;
                }
                case 4: {
                    if (!(Intrinsics.areEqual((Object)((Object)screenSize), (Object)((Object)ScreenSize.XLARGE)) ^ true)) break;
                    return false;
                }
            }
        }
        if (density != null) {
            Resources resources2 = ctx.getResources();
            if (resources2 == null || (resources2 = resources2.getDisplayMetrics()) == null) {
                return false;
            }
            int currentDensityDpi = resources2.densityDpi;
            if (density.contains((Comparable)Integer.valueOf(currentDensityDpi)) ^ true || currentDensityDpi == ((Number)((Object)density.getEnd())).intValue()) {
                return false;
            }
        }
        if (language != null) {
            String currentLanguage;
            Locale locale = Locale.getDefault();
            String string = currentLanguage = StringsKt.indexOf$default((String)language, (char)'_', (int)0, (boolean)false, (int)6) >= 0 ? locale.toString() : locale.getLanguage();
            if (Intrinsics.areEqual((Object)currentLanguage, (Object)language) ^ true) {
                return false;
            }
        }
        if (orientation != null) {
            if (config == null) {
                return false;
            }
            switch (config.orientation) {
                case 2: {
                    if (!(Intrinsics.areEqual((Object)((Object)orientation), (Object)((Object)Orientation.LANDSCAPE)) ^ true)) break;
                    return false;
                }
                case 1: {
                    if (!(Intrinsics.areEqual((Object)((Object)orientation), (Object)((Object)Orientation.PORTRAIT)) ^ true)) break;
                    return false;
                }
                case 3: {
                    if (!(Intrinsics.areEqual((Object)((Object)orientation), (Object)((Object)Orientation.SQUARE)) ^ true)) break;
                    return false;
                }
            }
        }
        if (bl != null) {
            if (config == null) {
                return false;
            }
            int currentLong = config.screenLayout & 0x30;
            if (currentLong == 32 && !bl.booleanValue()) {
                return false;
            }
            if (currentLong == 16 && bl.booleanValue()) {
                return false;
            }
        }
        if (fromSdk != null && Intrinsics.compare((int)Build.VERSION.SDK_INT, (int)((Number)fromSdk).intValue()) < 0) {
            return false;
        }
        if (sdk != null && Intrinsics.areEqual((Object)Build.VERSION.SDK_INT, (Object)fromSdk) ^ true) {
            return false;
        }
        if (uiMode != null) {
            if (config == null) {
                return false;
            }
            switch (config.uiMode & 0xF) {
                case 1: {
                    if (!(Intrinsics.areEqual((Object)((Object)uiMode), (Object)((Object)UiMode.NORMAL)) ^ true)) break;
                    return false;
                }
                case 2: {
                    if (!(Intrinsics.areEqual((Object)((Object)uiMode), (Object)((Object)UiMode.DESK)) ^ true)) break;
                    return false;
                }
                case 3: {
                    if (!(Intrinsics.areEqual((Object)((Object)uiMode), (Object)((Object)UiMode.CAR)) ^ true)) break;
                    return false;
                }
                case 4: {
                    if (!(Intrinsics.areEqual((Object)((Object)uiMode), (Object)((Object)UiMode.TELEVISION)) ^ true)) break;
                    return false;
                }
                case 5: {
                    if (!(Intrinsics.areEqual((Object)((Object)uiMode), (Object)((Object)UiMode.APPLIANCE)) ^ true)) break;
                    return false;
                }
                case 6: {
                    if (!(Intrinsics.areEqual((Object)((Object)uiMode), (Object)((Object)UiMode.WATCH)) ^ true)) break;
                    return false;
                }
            }
        }
        if (nightMode != null) {
            Object object2 = ctx.getSystemService("uimode");
            if (!(object2 instanceof UiModeManager)) {
                object2 = null;
            }
            UiModeManager uiModeManager = (UiModeManager)object2;
            if (uiModeManager == null) {
                return false;
            }
            UiModeManager uiModeManager2 = uiModeManager;
            int currentMode = uiModeManager2.getNightMode();
            if (currentMode == 2 && !nightMode.booleanValue()) {
                return false;
            }
            if (currentMode == 1 && nightMode.booleanValue()) {
                return false;
            }
        }
        if (rightToLeft != null) {
            boolean rtlMode;
            if (config == null) {
                return false;
            }
            boolean bl2 = rtlMode = (config.screenLayout & InternalConfiguration.INSTANCE.getSCREENLAYOUT_LAYOUTDIR_MASK()) == InternalConfiguration.INSTANCE.getSCREENLAYOUT_LAYOUTDIR_RTL();
            if (Intrinsics.areEqual((Object)rtlMode, (Object)rightToLeft) ^ true) {
                return false;
            }
        }
        if (smallestWidth != null) {
            if (config == null) {
                return false;
            }
            if (config.smallestScreenWidthDp == 0 ? Intrinsics.areEqual((Object)smallestWidth, (Object)0) ^ true : Intrinsics.compare((int)config.smallestScreenWidthDp, (int)((Number)smallestWidth).intValue()) < 0) {
                return false;
            }
        }
        return true;
    }

    static {
        new AnkoInternals();
    }

    private AnkoInternals() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\t\u0015\tA\"A\u0003\u0002\u00117!9)\u0001\u0007\u00013\u0005A\n!\t\u0001"}, strings={"Lorg/jetbrains/anko/internals/AnkoInternals$NoBinding;", ""}, moduleName="common-compileReleaseKotlin")
    public static @interface NoBinding {
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001\u0003\u0007\t\u0005\fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!+\u0006\u0005\u0007\"\u000b\u00012A\u0007\u00021\t\t6\u0001B\u0003\u0001\u001b\t!)\u0001C\u0002*\u0016\u0011\u0019\u0005*\u0001E\u0004\u001b\u0005A\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0003\t\u0007%VAa\u0011%\u0002\u0011\u0013i\u0011\u0001\u0007\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000b!\u0019\u0011V\u0003\u0003D\u0011\u0006AY!D\u0001\u0019\u0005E\u001bA!\u0002\u0001\u000e\u0005\u00111\u0001bAU\u000b\t\rC\u0015\u0001#\u0004\u000e\u0003a\u0011\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0002\u0005\u0004S+!1\tS\u0001\t\u00105\t\u0001DA)\u0004\t\u0015\u0001QB\u0001\u0003\t\u0011\r\u0001"}, strings={"Lorg/jetbrains/anko/internals/AnkoInternals$InternalConfiguration;", "", "()V", "DENSITY_DPI_NONE", "", "getDENSITY_DPI_NONE", "()I", "SCREENLAYOUT_LAYOUTDIR_MASK", "getSCREENLAYOUT_LAYOUTDIR_MASK", "SCREENLAYOUT_LAYOUTDIR_RTL", "getSCREENLAYOUT_LAYOUTDIR_RTL", "SCREENLAYOUT_LAYOUTDIR_SHIFT", "getSCREENLAYOUT_LAYOUTDIR_SHIFT", "UI_MODE_TYPE_APPLIANCE", "getUI_MODE_TYPE_APPLIANCE", "UI_MODE_TYPE_WATCH", "getUI_MODE_TYPE_WATCH"}, moduleName="common-compileReleaseKotlin")
    private static final class InternalConfiguration {
        public static final int SCREENLAYOUT_LAYOUTDIR_MASK = 192;
        public static final int SCREENLAYOUT_LAYOUTDIR_SHIFT = 6;
        public static final int SCREENLAYOUT_LAYOUTDIR_RTL = 128;
        public static final int UI_MODE_TYPE_APPLIANCE = 5;
        public static final int UI_MODE_TYPE_WATCH = 6;
        public static final int DENSITY_DPI_NONE = 65535;
        public static final InternalConfiguration INSTANCE;
        public static final InternalConfiguration INSTANCE$;

        public final int getSCREENLAYOUT_LAYOUTDIR_MASK() {
            return SCREENLAYOUT_LAYOUTDIR_MASK;
        }

        public final int getSCREENLAYOUT_LAYOUTDIR_SHIFT() {
            return SCREENLAYOUT_LAYOUTDIR_SHIFT;
        }

        public final int getSCREENLAYOUT_LAYOUTDIR_RTL() {
            return SCREENLAYOUT_LAYOUTDIR_RTL;
        }

        public final int getUI_MODE_TYPE_APPLIANCE() {
            return UI_MODE_TYPE_APPLIANCE;
        }

        public final int getUI_MODE_TYPE_WATCH() {
            return UI_MODE_TYPE_WATCH;
        }

        public final int getDENSITY_DPI_NONE() {
            return DENSITY_DPI_NONE;
        }

        static {
            new InternalConfiguration();
        }

        private InternalConfiguration() {
            INSTANCE = this;
            INSTANCE$ = this;
            SCREENLAYOUT_LAYOUTDIR_MASK = 192;
            SCREENLAYOUT_LAYOUTDIR_SHIFT = 6;
            SCREENLAYOUT_LAYOUTDIR_RTL = 2 << SCREENLAYOUT_LAYOUTDIR_SHIFT;
            UI_MODE_TYPE_APPLIANCE = 5;
            UI_MODE_TYPE_WATCH = 6;
            DENSITY_DPI_NONE = 65535;
        }
    }
}

