/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.model;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;

public abstract class CredentialsBindingHandler<C extends StandardCredentials>
implements ExtensionPoint {
    public boolean handles(Class<? extends StandardCredentials> c) {
        return this.type().isAssignableFrom(c);
    }

    public boolean handles(StandardCredentials c) {
        return this.handles(c.getClass());
    }

    @NonNull
    public List<MultiBinding<C>> toBindings(String varName, String credentialsId) {
        return Collections.emptyList();
    }

    @NonNull
    public abstract Class<? extends StandardCredentials> type();

    @NonNull
    public abstract List<Map<String, Object>> getWithCredentialsParameters(String var1);

    @NonNull
    public static ExtensionList<CredentialsBindingHandler> all() {
        return ExtensionList.lookup(CredentialsBindingHandler.class);
    }

    @NonNull
    public static Set<Class<? extends StandardCredentials>> supportedTypes() {
        HashSet<Class<? extends StandardCredentials>> set = new HashSet<Class<? extends StandardCredentials>>();
        for (CredentialsBindingHandler handler : CredentialsBindingHandler.all()) {
            set.add(handler.type());
        }
        return set;
    }

    @NonNull
    public static Set<String> supportedTypeNames() {
        HashSet<String> set = new HashSet<String>();
        for (Class<StandardCredentials> c : CredentialsBindingHandler.supportedTypes()) {
            set.add(c.getSimpleName());
        }
        return set;
    }

    @CheckForNull
    public static CredentialsBindingHandler forCredential(StandardCredentials c) {
        for (CredentialsBindingHandler handler : CredentialsBindingHandler.all()) {
            if (!handler.handles(c)) continue;
            return handler;
        }
        return null;
    }

    @NonNull
    public static CredentialsBindingHandler forId(String id, Run context) throws CredentialNotFoundException {
        IdCredentials cred = CredentialsProvider.findCredentialById((String)id, IdCredentials.class, (Run)context, (DomainRequirement[])new DomainRequirement[0]);
        if (cred == null) {
            throw new CredentialNotFoundException(id);
        }
        if (cred instanceof StandardCredentials) {
            CredentialsBindingHandler handler = CredentialsBindingHandler.forCredential((StandardCredentials)cred);
            if (handler == null) {
                throw new CredentialNotFoundException(String.format("No suitable binding handler could be found for type %s. Supported types are %s.", cred.getClass().getName(), StringUtils.join(CredentialsBindingHandler.supportedTypeNames(), (char)',')));
            }
            return handler;
        }
        throw new CredentialNotFoundException(String.format("Credentials %s is of type %s where StandardCredentials is the expected type.", id, cred.getClass().getName()));
    }

    public static class EnvVarResolver
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String value;

        public EnvVarResolver() {
            this.value = "%s";
        }

        public EnvVarResolver(String value) {
            this.value = value;
        }

        public String resolve(String varName) {
            return String.format(this.value, varName);
        }
    }
}

