/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ModelASTWhenCondition
extends ModelASTElement
implements ModelASTWhenContent {
    private String name;
    private ModelASTArgumentList args;
    private List<ModelASTWhenContent> children = new ArrayList<ModelASTWhenContent>();

    public ModelASTWhenCondition(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.accumulate("name", (Object)this.name);
        if (this.args != null) {
            o.accumulate("arguments", this.args.toJSON());
        }
        if (!this.children.isEmpty()) {
            JSONArray a = new JSONArray();
            for (ModelASTWhenContent child : this.children) {
                a.add(child.toJSON());
            }
            o.accumulate("children", (Object)a);
        }
        return o;
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        if (this.args != null) {
            this.args.validate(validator);
        }
        for (ModelASTWhenContent c : this.children) {
            c.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder();
        if (!this.children.isEmpty()) {
            result.append(this.name).append(" {\n");
            for (ModelASTWhenContent child : this.children) {
                result.append(child.toGroovy()).append("\n");
            }
            result.append("}\n");
        } else {
            result.append(this.name).append(" ").append(this.getArgs().toGroovy());
        }
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        if (this.args != null) {
            this.args.removeSourceLocation();
        }
        for (ModelASTWhenContent child : this.children) {
            child.removeSourceLocation();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelASTArgumentList getArgs() {
        return this.args;
    }

    public void setArgs(ModelASTArgumentList args) {
        this.args = args;
    }

    public List<ModelASTWhenContent> getChildren() {
        return this.children;
    }

    public void setChildren(List<ModelASTWhenContent> c) {
        this.children = c;
    }

    @Override
    public String toString() {
        return "ModelASTWhenCondition{name='" + this.name + '\'' + ", args=" + this.args + ", children=" + this.children + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTWhenCondition that = (ModelASTWhenCondition)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getChildren() != null ? !this.getChildren().equals(that.getChildren()) : that.getChildren() != null) {
            return false;
        }
        return this.getArgs() != null ? this.getArgs().equals(that.getArgs()) : that.getArgs() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getArgs() != null ? this.getArgs().hashCode() : 0);
        result = 31 * result + (this.getChildren() != null ? this.getChildren().hashCode() : 0);
        return result;
    }
}

