/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.Messages;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMethodArg;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ModelASTMethodCall
extends ModelASTElement
implements ModelASTMethodArg {
    private String name;
    private List<ModelASTMethodArg> args = new ArrayList<ModelASTMethodArg>();

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static Map<String, String> getBlockedSteps() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("node", Messages.ModelASTMethodCall_BlockedSteps_Node());
        map.putAll(ModelASTStep.getBlockedSteps());
        return map;
    }

    public ModelASTMethodCall(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTMethodArg arg : this.args) {
            a.add(arg.toJSON());
        }
        return new JSONObject().accumulate("name", (Object)this.name).accumulate("arguments", (Object)a);
    }

    @Override
    public void validate(ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTMethodArg arg : this.args) {
            arg.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder(this.name);
        result.append('(');
        boolean first = true;
        for (ModelASTMethodArg arg : this.args) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(arg.toGroovy());
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTMethodArg arg : this.args) {
            arg.removeSourceLocation();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ModelASTMethodArg> getArgs() {
        return this.args;
    }

    public void setArgs(List<ModelASTMethodArg> args) {
        this.args = args;
    }

    @Override
    public String toString() {
        return "ModelASTMethodCall{name='" + this.name + '\'' + ", args=" + this.args + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTMethodCall that = (ModelASTMethodCall)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return this.getArgs() != null ? this.getArgs().equals(that.getArgs()) : that.getArgs() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getArgs() != null ? this.getArgs().hashCode() : 0);
        return result;
    }
}

