/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.ToString;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

@ToString(includeSuper=true, includeSuperProperties=true)
@EqualsAndHashCode(callSuper=true)
@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class ModelASTNamedArgumentList
extends ModelASTArgumentList {
    private Map<ModelASTKey, ModelASTValue> arguments = new LinkedHashMap<ModelASTKey, ModelASTValue>();

    public ModelASTNamedArgumentList(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONArray toJSON() {
        JSONArray a = new JSONArray();
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.arguments.entrySet()) {
            JSONObject o = new JSONObject();
            o.accumulate("key", entry.getKey().toJSON());
            o.accumulate("value", (Object)entry.getValue().toJSON());
            a.add((Object)o);
        }
        return a;
    }

    public boolean containsKeyName(@Nonnull String keyName) {
        for (ModelASTKey key : this.arguments.keySet()) {
            if (!keyName.equals(key.getKey())) continue;
            return true;
        }
        return false;
    }

    public ModelASTKey keyForName(@Nonnull String keyName) {
        for (ModelASTKey key : this.arguments.keySet()) {
            if (!keyName.equals(key.getKey())) continue;
            return key;
        }
        return null;
    }

    public ModelASTValue valueForName(@Nonnull String keyName) {
        if (this.containsKeyName(keyName)) {
            return this.arguments.get(this.keyForName(keyName));
        }
        return null;
    }

    @Override
    public void validate(ModelValidator validator) {
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.arguments.entrySet()) {
            entry.getKey().validate(validator);
            entry.getValue().validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.arguments.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(entry.getKey().toGroovy()).append(": ").append(entry.getValue().toGroovy());
        }
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.arguments.entrySet()) {
            entry.getKey().removeSourceLocation();
            entry.getValue().removeSourceLocation();
        }
    }

    public Map<ModelASTKey, ModelASTValue> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<ModelASTKey, ModelASTValue> arguments) {
        this.arguments = arguments;
    }

    @Override
    public String toString() {
        return "ModelASTNamedArgumentList{arguments=" + this.arguments + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTNamedArgumentList that = (ModelASTNamedArgumentList)o;
        return this.getArguments() != null ? this.getArguments().equals(that.getArguments()) : that.getArguments() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getArguments() != null ? this.getArguments().hashCode() : 0);
        return result;
    }
}

