/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

@Extension
public class DescriptorLookupCache {
    private transient Map<String, StepDescriptor> stepMap;
    private transient Map<String, DescribableModel<? extends Step>> modelMap;
    private transient Map<String, Descriptor<? extends Describable>> describableMap;
    private transient Map<String, DescribableModel<? extends Describable>> describableModelMap;

    public static DescriptorLookupCache getPublicCache() {
        return (DescriptorLookupCache)ExtensionList.lookup(DescriptorLookupCache.class).get(0);
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void invalidateGlobalCache() {
        DescriptorLookupCache.getPublicCache().invalidateAll();
    }

    public DescriptorLookupCache() {
        this.invalidateAll();
    }

    public synchronized void invalidateAll() {
        this.stepMap = new LinkedHashMap<String, StepDescriptor>();
        this.modelMap = new LinkedHashMap<String, DescribableModel<? extends Step>>();
        this.describableMap = new LinkedHashMap<String, Descriptor<? extends Describable>>();
        this.describableModelMap = new LinkedHashMap<String, DescribableModel<? extends Describable>>();
    }

    public synchronized DescribableModel<? extends Step> modelForStep(String n) {
        if (!this.modelMap.containsKey(n)) {
            StepDescriptor descriptor = this.lookupStepDescriptor(n);
            Class c = descriptor == null ? null : descriptor.clazz;
            this.modelMap.put(n, (DescribableModel<? extends Step>)(c != null ? new DescribableModel(c) : null));
        }
        return this.modelMap.get(n);
    }

    public synchronized DescribableModel<? extends Describable> modelForDescribable(String n) {
        if (!this.describableModelMap.containsKey(n)) {
            Descriptor<? extends Describable> function = this.lookupFunction(n);
            Class c = function == null ? null : function.clazz;
            this.describableModelMap.put(n, (DescribableModel<? extends Describable>)(c != null ? new DescribableModel(c) : null));
        }
        return this.describableModelMap.get(n);
    }

    public synchronized StepDescriptor lookupStepDescriptor(String n) {
        if (this.stepMap.isEmpty()) {
            for (StepDescriptor d : StepDescriptor.all()) {
                this.stepMap.put(d.getFunctionName(), d);
            }
        }
        return this.stepMap.get(n);
    }

    public synchronized Descriptor<? extends Describable> lookupFunction(String n) {
        if (!this.describableMap.containsKey(n)) {
            try {
                Descriptor d = SymbolLookup.get().findDescriptor(Describable.class, n);
                this.describableMap.put(n, (Descriptor<? extends Describable>)d);
            }
            catch (NullPointerException e) {
                this.describableMap.put(n, null);
            }
        }
        return this.describableMap.get(n);
    }

    public synchronized Descriptor<? extends Describable> lookupStepOrFunction(String name) {
        return this.lookupStepDescriptor(name) != null ? this.lookupStepDescriptor(name) : this.lookupFunction(name);
    }

    public synchronized DescribableModel<? extends Describable> modelForStepOrFunction(String name) {
        Descriptor<? extends Describable> desc = this.lookupStepDescriptor(name);
        DescribableModel<? extends Step> model = null;
        if (desc != null) {
            model = this.modelForStep(name);
        } else {
            desc = this.lookupFunction(name);
            if (desc != null) {
                model = this.modelForDescribable(name);
            }
        }
        return model;
    }

    public boolean stepTakesClosure(Descriptor d) {
        if (d instanceof StepDescriptor) {
            return ((StepDescriptor)d).takesImplicitBlockArgument();
        }
        return false;
    }
}

