/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.threshold;

import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.threshold.ThresholdAlarm;
import org.jenkinsci.plugins.octoperf.threshold.ThresholdAlarmApi;
import org.jenkinsci.plugins.octoperf.threshold.ThresholdAlarmService;
import org.jenkinsci.plugins.octoperf.threshold.ThresholdSeverity;

final class RetrofitThresholdAlarmService
implements ThresholdAlarmService {
    private static final String THRESHOLD_REPORT_ITEM = "{\"@type\":\"ThresholdAlarmReportItem\",\"metric\":{\"@type\":\"HitMetric\",\"benchResultId\":\"%s\",\"config\":null,\"field\":\"value\",\"filters\":[],\"id\":\"MONITORING\",\"scope\":\"PER_SAMPLE\",\"statistic\":\"AVERAGE\",\"type\":\"NUMBER_COUNTER\"},\"name\":\"Threshold alarms\"}";

    RetrofitThresholdAlarmService() {
    }

    @Override
    public boolean hasAlarms(RestApiFactory apiFactory, String benchResultId, ThresholdSeverity severity) throws IOException {
        ThresholdAlarmApi api = apiFactory.create(ThresholdAlarmApi.class);
        return ((List)api.getAlarms(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)String.format(THRESHOLD_REPORT_ITEM, benchResultId))).execute().body()).stream().map(ThresholdAlarm::getSeverity).anyMatch(severity::equals);
    }
}

