/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.metrics;

import java.io.IOException;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.metrics.MetricValue;
import org.jenkinsci.plugins.octoperf.metrics.MetricValues;
import org.jenkinsci.plugins.octoperf.metrics.MetricsApi;
import org.jenkinsci.plugins.octoperf.metrics.MetricsService;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

final class RestMetricsService
implements MetricsService {
    RestMetricsService() {
    }

    @Override
    public MetricValues getMetrics(RestApiFactory apiFactory, String benchResultId) throws IOException {
        MetricsApi api = apiFactory.create(MetricsApi.class);
        return (MetricValues)api.getMetrics(benchResultId).execute().body();
    }

    @Override
    public String toPrintable(DateTime startTime, MetricValues metrics) {
        DateTime now = DateTime.now();
        Duration duration = new Duration((ReadableInstant)startTime, (ReadableInstant)now);
        StringBuilder b = new StringBuilder(256);
        for (MetricValue metric : metrics.getMetrics()) {
            b.append(metric.getName()).append(": ").append(String.format("%.2f", metric.getValue())).append(metric.getUnit());
            b.append(" ");
        }
        b.append("Duration: ").append(duration.getStandardSeconds() + "s");
        return b.toString();
    }
}

