/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.log;

import com.google.common.base.Charsets;
import com.google.common.io.Closer;
import hudson.FilePath;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import okhttp3.ResponseBody;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.log.LogApi;
import org.jenkinsci.plugins.octoperf.log.LogService;
import retrofit2.Call;

final class JMeterLogService
implements LogService {
    private static final String LOG_EXT = ".log";
    private static final String JTL_EXT = ".jtl";
    private static final String LOGS_FOLDER = "logs";
    private static final String JTLS_FOLDER = "jtls";

    JMeterLogService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadLogFiles(FilePath workspace, PrintStream logger, RestApiFactory apiFactory, String benchResultId) throws IOException, InterruptedException {
        LogApi api = apiFactory.create(LogApi.class);
        Set files = (Set)api.getFiles(benchResultId).execute().body();
        logger.println("Available log files: " + files);
        FilePath logsFolder = new FilePath(workspace, LOGS_FOLDER);
        logsFolder.deleteContents();
        logsFolder.mkdirs();
        FilePath jtlsFolder = new FilePath(workspace, JTLS_FOLDER);
        jtlsFolder.deleteContents();
        jtlsFolder.mkdirs();
        int logs = 0;
        int jtls = 0;
        for (String filename : files) {
            FilePath logFile;
            String outputFilename = filename.replace(".gz", "");
            if (filename.endsWith("-agent.log")) continue;
            if (outputFilename.endsWith(JTL_EXT)) {
                logFile = new FilePath(jtlsFolder, "jmeter-" + jtls + JTL_EXT);
                ++jtls;
            } else {
                if (!outputFilename.endsWith(LOG_EXT)) continue;
                logFile = new FilePath(logsFolder, "jmeter-" + logs + LOG_EXT);
                ++logs;
            }
            logger.println("Downloading file: " + filename);
            Call<ResponseBody> response = api.getFile(benchResultId, filename);
            ResponseBody body = (ResponseBody)response.execute().body();
            Closer closer = Closer.create();
            InputStream input = (InputStream)closer.register((Closeable)new BufferedInputStream(body.byteStream()));
            try {
                CompressorStreamFactory factory = new CompressorStreamFactory();
                input = factory.createCompressorInputStream(input);
            }
            catch (CompressorException e) {
                e.printStackTrace(logger);
            }
            try {
                OutputStream output = (OutputStream)closer.register((Closeable)logFile.write());
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                closer.close();
            }
            logger.println("Archived log file: " + logFile);
        }
    }

    @Override
    public void mergeJTLs(FilePath workspace, PrintStream logger) throws IOException, InterruptedException {
        FilePath jtlsFolder = new FilePath(workspace, JTLS_FOLDER);
        FilePath merged = new FilePath(workspace, JTLS_FOLDER + File.separator + "jmeter.jtl");
        if (!merged.delete()) {
            logger.println("Could not delete " + merged.getName());
            return;
        }
        HashSet<String> headers = new HashSet<String>();
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter(merged.write(), Charsets.UTF_8));){
            for (FilePath jtl : jtlsFolder.list("*.jtl")) {
                if (Objects.equals(jtl, merged)) continue;
                logger.println("[Merge] Processing '" + jtl.getName() + "'...");
                long start = System.currentTimeMillis();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(jtl.read(), Charsets.UTF_8));){
                    String line;
                    String csvHeader = reader.readLine();
                    if (headers.isEmpty()) {
                        headers.add(csvHeader);
                        write.write(csvHeader);
                        write.newLine();
                    } else if (!headers.contains(csvHeader)) {
                        logger.println("Cannot merge JTLs: Please configure all JTLs with the same columns!");
                        return;
                    }
                    while ((line = reader.readLine()) != null) {
                        write.write(line);
                        write.newLine();
                    }
                }
                logger.println("[Merge] ... '" + jtl.getName() + "' Done in " + (System.currentTimeMillis() - start) + " ms");
                jtl.delete();
            }
        }
    }
}

