/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jenkinsci.plugins.octoperf.account.AccountApi;
import org.jenkinsci.plugins.octoperf.account.SecurityToken;
import org.jenkinsci.plugins.octoperf.client.RestClientAuthenticator;
import retrofit2.Call;

final class BearerClientAuthentication
implements RestClientAuthenticator {
    private static final String BEARER = "Bearer ";
    private volatile Optional<String> username = Optional.absent();
    private volatile Optional<String> password = Optional.absent();
    private volatile Optional<SecurityToken> token = Optional.absent();
    private final AccountApi accountApi;
    private final PrintStream logger;

    BearerClientAuthentication(AccountApi accountApi, PrintStream logger) {
        this.accountApi = (AccountApi)Preconditions.checkNotNull((Object)accountApi);
        this.logger = (PrintStream)Preconditions.checkNotNull((Object)logger);
    }

    public Request authenticate(Route route, Response response) throws IOException {
        Optional optional;
        if (!this.username.isPresent()) {
            return null;
        }
        try {
            Call<SecurityToken> login = this.accountApi.login((String)this.username.get(), (String)this.password.get());
            optional = Optional.fromNullable((Object)((SecurityToken)login.execute().body()));
        }
        catch (IOException e) {
            this.logger.println("Authentication failed. " + e);
            e.printStackTrace(this.logger);
            return null;
        }
        if (optional.isPresent()) {
            this.token = optional;
            if (response.request().headers("Authorization").isEmpty()) {
                return response.request().newBuilder().header("Authorization", BEARER + ((SecurityToken)this.token.get()).getToken()).build();
            }
        }
        return null;
    }

    @Override
    public void onUsernameAndPassword(String username, String password) {
        this.username = Optional.fromNullable((Object)username);
        this.password = Optional.fromNullable((Object)password);
    }

    @Override
    public void onLogout() {
        this.username = Optional.absent();
        this.password = Optional.absent();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.token.isPresent()) {
            String tokenStr = ((SecurityToken)this.token.get()).getToken();
            request = request.newBuilder().header("Authorization", BEARER + tokenStr).build();
        }
        return chain.proceed(request);
    }
}

