/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.tuple.Pair;
import org.jenkinsci.plugins.octoperf.OctoperfBuilderDescriptor;
import org.jenkinsci.plugins.octoperf.OctoperfCredential;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.client.RestClientAuthenticator;
import org.jenkinsci.plugins.octoperf.client.RestClientService;
import org.jenkinsci.plugins.octoperf.workspace.WorkspacesApi;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import retrofit2.Response;

public class OctoperfCredentialImpl
extends UsernamePasswordCredentialsImpl
implements OctoperfCredential {
    private static final long serialVersionUID = -3802174823289690186L;

    @DataBoundConstructor
    public OctoperfCredentialImpl(CredentialsScope scope, String id, String description, String username, String password) {
        super(scope, id, description, username, password);
    }

    @Extension(ordinal=1.0)
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "OctoPerf Account";
        }

        @POST
        public FormValidation doTestLogin(@QueryParameter(value="username") String username, @QueryParameter(value="password") Secret password) throws IOException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)username) == null || Util.fixEmptyAndTrim((String)password.getPlainText()) == null) {
                return FormValidation.error((String)"username and/or password cannot be empty");
            }
            Pair<RestApiFactory, RestClientAuthenticator> pair = RestClientService.CLIENTS.create(OctoperfBuilderDescriptor.getDescriptor().getOctoperfURL(), System.out);
            ((RestClientAuthenticator)pair.getRight()).onUsernameAndPassword(username, password.getPlainText());
            RestApiFactory factory = (RestApiFactory)pair.getLeft();
            WorkspacesApi api = factory.create(WorkspacesApi.class);
            Response response = api.memberOf().execute();
            if (response.isSuccessful()) {
                return FormValidation.ok((String)"Successfully logged in!");
            }
            return FormValidation.error((Throwable)new IOException(response.toString()), (String)"Login failed!");
        }
    }
}

