/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.jenkinsci.plugins.octoperf.OctoperfBuilder;
import org.jenkinsci.plugins.octoperf.OctoperfBuilderDescriptor;
import org.jenkinsci.plugins.octoperf.OctoperfCredential;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.client.RestClientAuthenticator;
import org.jenkinsci.plugins.octoperf.client.RestClientService;
import org.jenkinsci.plugins.octoperf.conditions.StopConditionDescriptor;
import org.jenkinsci.plugins.octoperf.conditions.TestStopCondition;
import org.jenkinsci.plugins.octoperf.credentials.CredentialsService;
import org.jenkinsci.plugins.octoperf.result.BenchResultService;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class OctoPerfTestStep
extends Step {
    private String credentialsId = "";
    private String scenarioId = "";
    private List<? extends TestStopCondition> stopConditions = new ArrayList<TestStopCondition>();
    private String serverUrl = "";

    @DataBoundConstructor
    public OctoPerfTestStep(String credentialsId, String scenarioId) {
        this.setCredentialsId(credentialsId);
        this.setScenarioId(scenarioId);
        this.setServerUrl("");
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Strings.nullToEmpty((String)credentialsId);
    }

    @DataBoundSetter
    public void setScenarioId(String scenarioId) {
        this.scenarioId = Strings.nullToEmpty((String)scenarioId);
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = OctoperfBuilderDescriptor.getDescriptor().getOctoperfURL();
    }

    @DataBoundSetter
    public void setStopConditions(List<? extends TestStopCondition> stopConditions) {
        this.stopConditions = Optional.ofNullable(stopConditions).orElse((List<? extends TestStopCondition>)ImmutableList.of());
    }

    public StepExecution start(StepContext stepContext) {
        return new OctoPerfTestExecution(stepContext, this.credentialsId, this.scenarioId, this.serverUrl, this.stopConditions);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public List<? extends TestStopCondition> getStopConditions() {
        return this.stopConditions;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public static class OctoPerfTestExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = -3802154812289490186L;
        private final String credentialsId;
        private final String scenarioId;
        private final String serverUrl;
        private List<? extends TestStopCondition> stopConditions = new ArrayList<TestStopCondition>();
        private EnvVars variables = new EnvVars();

        protected OctoPerfTestExecution(@Nonnull StepContext context, @Nonnull String credentialsId, @Nonnull String scenarioId, @Nonnull String serverUrl, @Nonnull List<? extends TestStopCondition> stopConditions) {
            super(context);
            this.credentialsId = Objects.requireNonNull(credentialsId);
            this.scenarioId = Objects.requireNonNull(scenarioId);
            this.serverUrl = Objects.requireNonNull(serverUrl);
            this.stopConditions = Objects.requireNonNull(stopConditions);
        }

        protected Void run() throws Exception {
            OctoperfBuilder builder = new OctoperfBuilder(this.credentialsId, "", "", this.scenarioId, "", this.stopConditions);
            builder.setServerUrl(this.serverUrl);
            Run run = (Run)this.getContext().get(Run.class);
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            this.variables = (EnvVars)this.getContext().get(EnvVars.class);
            builder.perform(run, workspace, listener, this.variables);
            return null;
        }

        public void stop(Throwable cause) throws Exception {
            this.getContext().onFailure(cause);
            Run run = (Run)this.getContext().get(Run.class);
            OctoperfCredential credentials = CredentialsService.CREDENTIALS_SERVICE.find(this.credentialsId, (Item)run.getParent()).orElse(null);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Pair<RestApiFactory, RestClientAuthenticator> pair = RestClientService.CLIENTS.create(this.serverUrl, listener.getLogger());
            ((RestClientAuthenticator)pair.getRight()).onUsernameAndPassword(credentials.getUsername(), credentials.getPassword().getPlainText());
            RestApiFactory apiFactory = (RestApiFactory)pair.getLeft();
            String benchResultId = (String)this.variables.getOrDefault((Object)"BENCH_RESULT_ID", (Object)"");
            if (benchResultId.isEmpty()) {
                listener.error("Could not stop test: benchResultId is empty");
            } else {
                BenchResultService.BENCH_RESULTS.stopTest(apiFactory, benchResultId);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            HashSet<Class> r = new HashSet<Class>();
            r.add(Run.class);
            r.add(FilePath.class);
            r.add(Launcher.class);
            r.add(TaskListener.class);
            return r;
        }

        public String getFunctionName() {
            return "octoPerfTest";
        }

        public String getDisplayName() {
            return "Runs test in OctoPerf Cloud";
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId, Object scope) {
            return OctoperfBuilderDescriptor.getDescriptor().doFillCredentialsIdItems(credentialsId, scope);
        }

        public ListBoxModel doFillWorkspaceIdItems(@QueryParameter String credentialsId, @QueryParameter String workspaceId) {
            return OctoperfBuilderDescriptor.getDescriptor().doFillWorkspaceIdItems(credentialsId, workspaceId);
        }

        public ListBoxModel doFillProjectIdItems(@QueryParameter String credentialsId, @QueryParameter String workspaceId, @QueryParameter String projectId) {
            return OctoperfBuilderDescriptor.getDescriptor().doFillProjectIdItems(credentialsId, workspaceId, projectId);
        }

        public ListBoxModel doFillScenarioIdItems(@QueryParameter String credentialsId, @QueryParameter String projectId, @QueryParameter String scenarioId) {
            return OctoperfBuilderDescriptor.getDescriptor().doFillScenarioIdItems(credentialsId, projectId, scenarioId);
        }

        public List<StopConditionDescriptor> getStopConditionDescriptors() {
            return StopConditionDescriptor.all();
        }
    }
}

