/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf;

import com.google.common.base.Charsets;
import com.google.common.io.Closer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Result;
import hudson.util.Secret;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.Pair;
import org.jenkinsci.plugins.octoperf.client.RestApiFactory;
import org.jenkinsci.plugins.octoperf.client.RestClientAuthenticator;
import org.jenkinsci.plugins.octoperf.client.RestClientService;
import org.jenkinsci.plugins.octoperf.conditions.TestStopCondition;
import org.jenkinsci.plugins.octoperf.junit.JUnitReportService;
import org.jenkinsci.plugins.octoperf.log.LogService;
import org.jenkinsci.plugins.octoperf.metrics.MetricValues;
import org.jenkinsci.plugins.octoperf.metrics.MetricsService;
import org.jenkinsci.plugins.octoperf.project.Project;
import org.jenkinsci.plugins.octoperf.project.ProjectService;
import org.jenkinsci.plugins.octoperf.report.BenchReport;
import org.jenkinsci.plugins.octoperf.report.BenchReportService;
import org.jenkinsci.plugins.octoperf.result.BenchResult;
import org.jenkinsci.plugins.octoperf.result.BenchResultService;
import org.jenkinsci.plugins.octoperf.result.BenchResultState;
import org.jenkinsci.plugins.octoperf.scenario.Scenario;
import org.jenkinsci.plugins.octoperf.scenario.ScenarioService;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OctoPerfBuild
implements Callable<Result> {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"HH:mm:ss");
    private static final long TEN_SECS = 10000L;
    private static final String BENCH_RESULT_ID = "BENCH_RESULT_ID";
    private final PrintStream logger;
    private final String username;
    private final Secret password;
    private final String scenarioId;
    private final Optional<String> testName;
    private final List<? extends TestStopCondition> stopConditions;
    private final FilePath workspace;
    private final String serverUrl;
    private final EnvVars envVars;

    OctoPerfBuild(PrintStream logger, String username, Secret password, String scenarioId, Optional<String> testName, List<? extends TestStopCondition> stopConditions, FilePath workspace, String serverUrl, EnvVars envVars) {
        this.logger = Objects.requireNonNull(logger);
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
        this.scenarioId = Objects.requireNonNull(scenarioId);
        this.testName = Objects.requireNonNull(testName);
        this.stopConditions = Objects.requireNonNull(stopConditions);
        this.workspace = Objects.requireNonNull(workspace);
        this.serverUrl = Objects.requireNonNull(serverUrl);
        this.envVars = Objects.requireNonNull(envVars);
    }

    @Override
    public Result call() throws Exception {
        BenchResultState currentState;
        BenchResult benchResult;
        Result result = Result.SUCCESS;
        this.logger.println("Username: " + this.username);
        this.logger.println("API Endpoint: " + this.serverUrl);
        Pair<RestApiFactory, RestClientAuthenticator> pair = RestClientService.CLIENTS.create(this.serverUrl, this.logger);
        ((RestClientAuthenticator)pair.getRight()).onUsernameAndPassword(this.username, this.password.getPlainText());
        RestApiFactory apiFactory = (RestApiFactory)pair.getLeft();
        Scenario scenario = ScenarioService.SCENARIOS.find(apiFactory, this.scenarioId);
        this.logger.println("Launching Scenario with:");
        this.logger.println("- name: " + scenario.getName() + ",");
        if (!scenario.getDescription().isEmpty()) {
            this.logger.println("- description: " + scenario.getDescription());
        }
        Properties properties = new Properties();
        try {
            BenchReport report = ScenarioService.SCENARIOS.startTest(apiFactory, this.scenarioId, this.testName);
            benchResult = BenchResultService.BENCH_RESULTS.find(apiFactory, report.getBenchResultId());
            properties.put("PROJECT_ID", benchResult.getDesignProjectId());
            this.logger.println("Starting test...");
            Project project = ProjectService.PROJECTS.find(apiFactory, scenario.getProjectId());
            this.logger.println("Bench Report: " + BenchReportService.BENCH_REPORTS.getReportUrl(this.serverUrl, project.getWorkspaceId(), report));
        }
        catch (IOException e) {
            this.logger.println("Could not start test: " + e);
            return Result.FAILURE;
        }
        String benchResultId = benchResult.getId();
        this.envVars.put(BENCH_RESULT_ID, benchResultId);
        properties.put(BENCH_RESULT_ID, benchResultId);
        this.logger.println("Launching test..");
        Optional<Object> startTime = Optional.empty();
        while (true) {
            Thread.sleep(10000L);
            currentState = BenchResultService.BENCH_RESULTS.getState(apiFactory, benchResultId);
            if (currentState.isRunning()) {
                for (TestStopCondition testStopCondition : this.stopConditions) {
                    result = testStopCondition.execute(this.logger, apiFactory, benchResultId);
                }
                DateTime now = DateTime.now();
                if (!startTime.isPresent()) {
                    startTime = Optional.of(now);
                }
                MetricValues metricValues = MetricsService.METRICS.getMetrics(apiFactory, benchResultId);
                String printable = MetricsService.METRICS.toPrintable((DateTime)startTime.get(), metricValues);
                String nowStr = DATE_FORMAT.print((ReadableInstant)now);
                String progress = String.format("[%.2f%%] ", BenchResultService.BENCH_RESULTS.getProgress(apiFactory, benchResultId));
                this.logger.println(progress + nowStr + " - " + printable);
                continue;
            }
            if (currentState.isTerminalState()) break;
            this.logger.println("Preparing test.. (" + (Object)((Object)currentState) + ")");
        }
        this.logger.println("Test finished with state: " + (Object)((Object)currentState));
        this.envVars.remove((Object)BENCH_RESULT_ID);
        this.writeProperties(properties);
        this.logger.println("Saving JUnit report...");
        FilePath junitReport = JUnitReportService.JUNIT_REPORTS.saveJUnitReport(this.workspace, apiFactory, benchResultId);
        this.logger.println("JUnit report saved to: " + junitReport);
        this.logger.println("Downloading JMeter Logs and JTLs...");
        LogService.LOGS.downloadLogFiles(this.workspace, this.logger, apiFactory, benchResultId);
        this.logger.println("Merging JTLs into a single file...");
        LogService.LOGS.mergeJTLs(this.workspace, this.logger);
        if (currentState == BenchResultState.ERROR) {
            return Result.FAILURE;
        }
        if (currentState == BenchResultState.ABORTED) {
            return Result.ABORTED;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
    private void writeProperties(Properties properties) throws IOException, InterruptedException {
        FilePath path = new FilePath(this.workspace, "octoperf.properties");
        path.deleteContents();
        try (Closer closer = Closer.create();){
            OutputStream output = (OutputStream)closer.register((Closeable)path.write());
            properties.store(new OutputStreamWriter(output, Charsets.UTF_8), "");
        }
    }
}

